/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstanceInterceptorFactory;
import org.jboss.as.ejb3.component.stateful.SerializedCdiInterceptorsKey;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.as.weld.ejb.DelegatingInterceptorInvocationContext;
import org.jboss.as.weld.ejb.WeldInterceptorInstances;
import org.jboss.as.weld.services.bootstrap.WeldEjbServices;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.ejb.spi.InterceptorBindings;
import org.jboss.weld.ejb.spi.helpers.ForwardingEjbServices;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.helpers.SerializableContextualInstance;
import org.wildfly.security.manager.WildFlySecurityManager;

public class Jsr299BindingsInterceptor
implements org.jboss.invocation.Interceptor {
    private final Map<String, SerializableContextualInstance<Interceptor<Object>, Object>> interceptorInstances;
    private final CreationalContext<Object> creationalContext;
    private final String ejbName;
    private final BeanManager beanManager;
    private final InterceptionType interceptionType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Jsr299BindingsInterceptor(BeanManagerImpl beanManager, String ejbName, InterceptorFactoryContext context, InterceptionType interceptionType, ClassLoader classLoader) {
        ClassLoader tccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)classLoader);
            this.beanManager = beanManager;
            this.ejbName = ejbName;
            this.interceptionType = interceptionType;
            EjbDescriptor descriptor = beanManager.getEjbDescriptor(this.ejbName);
            SessionBean bean = beanManager.getBean(descriptor);
            AtomicReference reference = (AtomicReference)context.getContextData().get(SerializedCdiInterceptorsKey.class);
            if (reference == null) {
                this.creationalContext = beanManager.createCreationalContext((Contextual)bean);
                this.interceptorInstances = new HashMap<String, SerializableContextualInstance<Interceptor<Object>, Object>>();
                InterceptorBindings interceptorBindings = this.getInterceptorBindings(this.ejbName);
                if (interceptorBindings != null) {
                    for (Interceptor interceptor : interceptorBindings.getAllInterceptors()) {
                        this.addInterceptorInstance((Interceptor<Object>)interceptor, beanManager, this.interceptorInstances);
                    }
                }
                WeldInterceptorInstances instances = new WeldInterceptorInstances(this.creationalContext, this.interceptorInstances);
                context.getContextData().put(SerializedCdiInterceptorsKey.class, new AtomicReference<ValueManagedReference>(new ValueManagedReference((Value)new ImmediateValue((Object)instances))));
            } else {
                WeldInterceptorInstances instances = (WeldInterceptorInstances)((ManagedReference)reference.get()).getInstance();
                this.creationalContext = instances.getCreationalContext();
                this.interceptorInstances = instances.getInterceptorInstances();
            }
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)tccl);
        }
    }

    protected Object delegateInterception(InvocationContext invocationContext, InterceptionType interceptionType, List<Interceptor<?>> currentInterceptors) throws Exception {
        ArrayList<Object> currentInterceptorInstances = new ArrayList<Object>();
        for (Interceptor<?> interceptor : currentInterceptors) {
            currentInterceptorInstances.add(this.interceptorInstances.get(interceptor.getBeanClass().getName()).getInstance());
        }
        if (currentInterceptorInstances.size() > 0) {
            return new DelegatingInterceptorInvocationContext(invocationContext, currentInterceptors, currentInterceptorInstances, interceptionType).proceed();
        }
        return invocationContext.proceed();
    }

    private Object doMethodInterception(InvocationContext invocationContext, InterceptionType interceptionType) throws Exception {
        InterceptorBindings interceptorBindings = this.getInterceptorBindings(this.ejbName);
        if (interceptorBindings != null) {
            List currentInterceptors = interceptorBindings.getMethodInterceptors(interceptionType, invocationContext.getMethod());
            return this.delegateInterception(invocationContext, interceptionType, currentInterceptors);
        }
        return invocationContext.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        switch (this.interceptionType) {
            case AROUND_INVOKE: {
                return this.doMethodInterception(context.getInvocationContext(), InterceptionType.AROUND_INVOKE);
            }
            case AROUND_TIMEOUT: {
                return this.doMethodInterception(context.getInvocationContext(), InterceptionType.AROUND_TIMEOUT);
            }
            case PRE_DESTROY: {
                try {
                    Object object = this.doLifecycleInterception(context);
                    return object;
                }
                finally {
                    this.creationalContext.release();
                }
            }
            case POST_CONSTRUCT: {
                return this.doLifecycleInterception(context);
            }
        }
        return context.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doLifecycleInterception(InterceptorContext context) throws Exception {
        try {
            InterceptorBindings interceptorBindings = this.getInterceptorBindings(this.ejbName);
            if (interceptorBindings != null) {
                List currentInterceptors = interceptorBindings.getLifecycleInterceptors(this.interceptionType);
                this.delegateInterception(context.getInvocationContext(), this.interceptionType, currentInterceptors);
            }
        }
        finally {
            return context.proceed();
        }
    }

    protected InterceptorBindings getInterceptorBindings(String ejbName) {
        BeanManagerImpl beanManager = (BeanManagerImpl)this.beanManager;
        EjbServices ejbServices = (EjbServices)beanManager.getServices().get(EjbServices.class);
        if (ejbServices instanceof ForwardingEjbServices) {
            ejbServices = ((ForwardingEjbServices)ejbServices).delegate();
        }
        InterceptorBindings interceptorBindings = null;
        if (ejbServices instanceof WeldEjbServices) {
            interceptorBindings = ((WeldEjbServices)ejbServices).getBindings(ejbName);
        }
        return interceptorBindings;
    }

    private void addInterceptorInstance(Interceptor<Object> interceptor, BeanManagerImpl beanManager, Map<String, SerializableContextualInstance<Interceptor<Object>, Object>> instances) {
        Object instance = beanManager.getContext(interceptor.getScope()).get(interceptor, this.creationalContext);
        SerializableContextualInstance serializableContextualInstance = ((ContextualStore)beanManager.getServices().get(ContextualStore.class)).getSerializableContextualInstance(interceptor, instance, this.creationalContext);
        instances.put(interceptor.getBeanClass().getName(), (SerializableContextualInstance<Interceptor<Object>, Object>)serializableContextualInstance);
    }

    public static class Factory
    extends ComponentInstanceInterceptorFactory {
        private final InjectedValue<WeldBootstrapService> weldContainer = new InjectedValue();
        private final String beanArchiveId;
        private final String ejbName;
        private final InterceptionType interceptionType;
        private final ClassLoader classLoader;

        public Factory(String beanArchiveId, String ejbName, InterceptionType interceptionType, ClassLoader classLoader) {
            this.beanArchiveId = beanArchiveId;
            this.ejbName = ejbName;
            this.interceptionType = interceptionType;
            this.classLoader = classLoader;
        }

        public org.jboss.invocation.Interceptor create(Component component, InterceptorFactoryContext context) {
            Jsr299BindingsInterceptor interceptor = new Jsr299BindingsInterceptor(((WeldBootstrapService)this.weldContainer.getValue()).getBeanManager(this.beanArchiveId), this.ejbName, context, this.interceptionType, this.classLoader);
            return interceptor;
        }

        public InjectedValue<WeldBootstrapService> getWeldContainer() {
            return this.weldContainer;
        }
    }
}

