/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import java.util.HashMap;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import org.jboss.as.jpa.container.PersistenceUnitSearch;
import org.jboss.as.jpa.container.TransactionScopedEntityManager;
import org.jboss.as.jpa.service.PersistenceUnitServiceImpl;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.weld.WeldMessages;
import org.jboss.as.weld.util.ImmediateResourceReferenceFactory;
import org.jboss.as.weld.util.ResourceInjectionUtilities;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.injection.spi.ResourceReference;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.injection.spi.helpers.SimpleResourceReference;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class WeldJpaInjectionServices
implements JpaInjectionServices {
    private final DeploymentUnit deploymentUnit;
    private final ServiceRegistry serviceRegistry;

    public WeldJpaInjectionServices(DeploymentUnit deploymentUnit, ServiceRegistry serviceRegistry) {
        this.deploymentUnit = deploymentUnit;
        this.serviceRegistry = serviceRegistry;
    }

    public EntityManager resolvePersistenceContext(InjectionPoint injectionPoint) {
        throw new UnsupportedOperationException();
    }

    public EntityManagerFactory resolvePersistenceUnit(InjectionPoint injectionPoint) {
        throw new UnsupportedOperationException();
    }

    public ResourceReferenceFactory<EntityManager> registerPersistenceContextInjectionPoint(InjectionPoint injectionPoint) {
        final PersistenceContext context = (PersistenceContext)ResourceInjectionUtilities.getResourceAnnotated(injectionPoint).getAnnotation(PersistenceContext.class);
        if (context == null) {
            throw WeldMessages.MESSAGES.annotationNotFound(PersistenceContext.class, injectionPoint.getMember());
        }
        final String scopedPuName = this.getScopedPUName(this.deploymentUnit, context.unitName());
        ServiceName persistenceUnitServiceName = PersistenceUnitServiceImpl.getPUServiceName((String)scopedPuName);
        ServiceController serviceController = this.serviceRegistry.getRequiredService(persistenceUnitServiceName);
        final PersistenceUnitServiceImpl persistenceUnitService = (PersistenceUnitServiceImpl)serviceController.getValue();
        return new ResourceReferenceFactory<EntityManager>(){

            public ResourceReference<EntityManager> createResource() {
                TransactionScopedEntityManager result = new TransactionScopedEntityManager(scopedPuName, new HashMap(), persistenceUnitService.getEntityManagerFactory(), context.synchronization());
                return new SimpleResourceReference((Object)result);
            }
        };
    }

    public ResourceReferenceFactory<EntityManagerFactory> registerPersistenceUnitInjectionPoint(InjectionPoint injectionPoint) {
        PersistenceUnit context = (PersistenceUnit)injectionPoint.getAnnotated().getAnnotation(PersistenceUnit.class);
        if (context == null) {
            throw WeldMessages.MESSAGES.annotationNotFound(PersistenceUnit.class, injectionPoint.getMember());
        }
        String scopedPuName = this.getScopedPUName(this.deploymentUnit, context.unitName());
        ServiceName persistenceUnitServiceName = PersistenceUnitServiceImpl.getPUServiceName((String)scopedPuName);
        ServiceController serviceController = this.serviceRegistry.getRequiredService(persistenceUnitServiceName);
        PersistenceUnitServiceImpl persistenceUnitService = (PersistenceUnitServiceImpl)serviceController.getValue();
        return new ImmediateResourceReferenceFactory<EntityManagerFactory>(persistenceUnitService.getEntityManagerFactory());
    }

    public void cleanup() {
    }

    private String getScopedPUName(DeploymentUnit deploymentUnit, String persistenceUnitName) {
        PersistenceUnitMetadata scopedPu = PersistenceUnitSearch.resolvePersistenceUnitSupplier((DeploymentUnit)deploymentUnit, (String)persistenceUnitName);
        if (null == scopedPu) {
            throw WeldMessages.MESSAGES.couldNotFindPersistenceUnit(persistenceUnitName, deploymentUnit.getName());
        }
        return scopedPu.getScopedPersistenceUnitName();
    }
}

