/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.connectionfactory;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.DataSources;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.jdbc.JdbcUtil;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.loaders.jdbc.logging.Log;
import org.infinispan.util.FileLookupFactory;
import org.infinispan.util.logging.LogFactory;

public class PooledConnectionFactory
extends ConnectionFactory {
    private static final Log log = (Log)LogFactory.getLog(PooledConnectionFactory.class, Log.class);
    private ComboPooledDataSource pooledDataSource;

    @Override
    public void start(ConnectionFactoryConfig config, ClassLoader classLoader) throws CacheLoaderException {
        this.logFileOverride(classLoader);
        this.pooledDataSource = new ComboPooledDataSource();
        this.pooledDataSource.setProperties(new Properties());
        try {
            Class.forName(config.getDriverClass(), true, ComboPooledDataSource.class.getClassLoader());
            this.pooledDataSource.setDriverClass(config.getDriverClass());
        }
        catch (Exception e) {
            log.errorInstantiatingJdbcDriver(config.getDriverClass(), e);
            throw new CacheLoaderException(String.format("Error while instatianting JDBC driver: '%s'", config.getDriverClass()), (Throwable)e);
        }
        this.pooledDataSource.setJdbcUrl(config.getConnectionUrl());
        this.pooledDataSource.setUser(config.getUserName());
        this.pooledDataSource.setPassword(config.getPassword());
        if (log.isTraceEnabled()) {
            log.tracef("Started connection factory with config: %s", config);
        }
    }

    private void logFileOverride(ClassLoader classLoader) {
        URL propsUrl = FileLookupFactory.newInstance().lookupFileLocation("c3p0.properties", classLoader);
        URL xmlUrl = FileLookupFactory.newInstance().lookupFileLocation("c3p0-config.xml", classLoader);
        if (log.isDebugEnabled() && propsUrl != null) {
            log.debugf("Found 'c3p0.properties' in classpath: %s", propsUrl);
        }
        if (log.isDebugEnabled() && xmlUrl != null) {
            log.debugf("Found 'c3p0-config.xml' in classpath: %s", xmlUrl);
        }
    }

    @Override
    public void stop() {
        try {
            DataSources.destroy((DataSource)this.pooledDataSource);
            if (log.isDebugEnabled()) {
                log.debug("Successfully stopped PooledConnectionFactory.");
            }
        }
        catch (SQLException sqle) {
            log.couldNotDestroyC3p0ConnectionPool(this.pooledDataSource != null ? this.pooledDataSource.toString() : null, sqle);
        }
    }

    @Override
    public Connection getConnection() throws CacheLoaderException {
        try {
            this.logBefore(true);
            Connection connection = this.pooledDataSource.getConnection();
            this.logAfter(connection, true);
            return connection;
        }
        catch (SQLException e) {
            throw new CacheLoaderException("Failed obtaining connection from PooledDataSource", (Throwable)e);
        }
    }

    @Override
    public void releaseConnection(Connection conn) {
        this.logBefore(false);
        JdbcUtil.safeClose(conn);
        this.logAfter(conn, false);
    }

    public ComboPooledDataSource getPooledDataSource() {
        return this.pooledDataSource;
    }

    private void logBefore(boolean checkout) {
        if (log.isTraceEnabled()) {
            String operation = checkout ? "checkout" : "release";
            try {
                log.tracef("DataSource before %s (NumBusyConnectionsAllUsers) : %d, (NumConnectionsAllUsers) : %d", operation, this.pooledDataSource.getNumBusyConnectionsAllUsers(), this.pooledDataSource.getNumConnectionsAllUsers());
            }
            catch (SQLException e) {
                log.sqlFailureUnexpected(e);
            }
        }
    }

    private void logAfter(Connection connection, boolean checkout) {
        if (log.isTraceEnabled()) {
            String operation = checkout ? "checkout" : "release";
            try {
                log.tracef("DataSource after %s (NumBusyConnectionsAllUsers) : %d, (NumConnectionsAllUsers) : %d", operation, this.pooledDataSource.getNumBusyConnectionsAllUsers(), this.pooledDataSource.getNumConnectionsAllUsers());
            }
            catch (SQLException e) {
                log.sqlFailureUnexpected(e);
            }
            log.tracef("Connection %s : %s", operation, connection);
        }
    }
}

