/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.provider;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.claims.ClaimsManager;
import org.apache.cxf.sts.operation.AbstractOperation;
import org.apache.cxf.sts.operation.TokenIssueOperation;
import org.apache.cxf.sts.operation.TokenRenewOperation;
import org.apache.cxf.sts.operation.TokenValidateOperation;
import org.apache.cxf.sts.service.ServiceMBean;
import org.apache.cxf.sts.token.provider.SAMLTokenProvider;
import org.apache.cxf.sts.token.provider.TokenProvider;
import org.apache.cxf.sts.token.renewer.SAMLTokenRenewer;
import org.apache.cxf.sts.token.renewer.TokenRenewer;
import org.apache.cxf.sts.token.validator.SAMLTokenValidator;
import org.apache.cxf.sts.token.validator.TokenValidator;
import org.apache.cxf.sts.token.validator.UsernameTokenValidator;
import org.apache.cxf.sts.token.validator.X509TokenValidator;
import org.apache.cxf.ws.security.sts.provider.SecurityTokenServiceProvider;
import org.apache.cxf.ws.security.tokenstore.TokenStore;

public class DefaultSecurityTokenServiceProvider
extends SecurityTokenServiceProvider {
    private STSPropertiesMBean stsProperties;
    private boolean encryptIssuedToken;
    private List<ServiceMBean> services;
    private boolean returnReferences = true;
    private TokenStore tokenStore;
    private ClaimsManager claimsManager = new ClaimsManager();

    public void setReturnReferences(boolean returnReferences) {
        this.returnReferences = returnReferences;
    }

    public void setTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
    }

    public void setStsProperties(STSPropertiesMBean stsProperties) {
        this.stsProperties = stsProperties;
    }

    public void setEncryptIssuedToken(boolean encryptIssuedToken) {
        this.encryptIssuedToken = encryptIssuedToken;
    }

    public void setServices(List<ServiceMBean> services) {
        this.services = services;
    }

    public void setClaimsManager(ClaimsManager claimsManager) {
        this.claimsManager = claimsManager;
    }

    public Source invoke(Source request) {
        if (this.getIssueOperation() == null) {
            this.setIssueOperation(this.createTokenIssueOperation());
        }
        if (this.getValidateOperation() == null) {
            this.setValidateOperation(this.createTokenValidateOperation());
        }
        if (this.getRenewOperation() == null) {
            this.setRenewOperation(this.createTokenRenewOperation());
        }
        return super.invoke(request);
    }

    private TokenIssueOperation createTokenIssueOperation() {
        TokenIssueOperation issueOperation = new TokenIssueOperation();
        this.populateAbstractOperation(issueOperation);
        return issueOperation;
    }

    private TokenValidateOperation createTokenValidateOperation() {
        TokenValidateOperation validateOperation = new TokenValidateOperation();
        this.populateAbstractOperation(validateOperation);
        return validateOperation;
    }

    private TokenRenewOperation createTokenRenewOperation() {
        TokenRenewOperation renewOperation = new TokenRenewOperation();
        this.populateAbstractOperation(renewOperation);
        ArrayList<TokenRenewer> tokenRenewers = new ArrayList<TokenRenewer>();
        tokenRenewers.add(new SAMLTokenRenewer());
        renewOperation.setTokenRenewers(tokenRenewers);
        return renewOperation;
    }

    private void populateAbstractOperation(AbstractOperation abstractOperation) {
        ArrayList<TokenProvider> tokenProviders = new ArrayList<TokenProvider>();
        tokenProviders.add(new SAMLTokenProvider());
        ArrayList<TokenValidator> tokenValidators = new ArrayList<TokenValidator>();
        tokenValidators.add(new SAMLTokenValidator());
        tokenValidators.add(new UsernameTokenValidator());
        tokenValidators.add(new X509TokenValidator());
        abstractOperation.setTokenProviders(tokenProviders);
        abstractOperation.setTokenValidators(tokenValidators);
        abstractOperation.setStsProperties(this.stsProperties);
        abstractOperation.setEncryptIssuedToken(this.encryptIssuedToken);
        abstractOperation.setServices(this.services);
        abstractOperation.setReturnReferences(this.returnReferences);
        abstractOperation.setTokenStore(this.tokenStore);
        abstractOperation.setClaimsManager(this.claimsManager);
    }
}

