/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.extensions.policy;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import org.apache.cxf.annotations.Policy;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.service.factory.AbstractServiceFactoryBean;
import org.apache.cxf.service.factory.FactoryBeanListener;
import org.apache.cxf.service.model.AbstractPropertiesHolder;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.DescriptionInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.jboss.ws.api.annotation.PolicySets;
import org.jboss.wsf.stack.cxf.Loggers;
import org.jboss.wsf.stack.cxf.extensions.policy.EndpointPolicyAttachments;
import org.jboss.wsf.stack.cxf.extensions.policy.PolicyAttachment;
import org.jboss.wsf.stack.cxf.extensions.policy.PolicyAttachmentStore;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PolicySetsAnnotationListener
implements FactoryBeanListener {
    private final Map<Class<?>, EndpointPolicyAttachments> epaMap = new HashMap();
    private PolicyAttachmentStore store;

    public PolicySetsAnnotationListener() {
        this.store = PolicyAttachmentStore.getDefaultInstance();
    }

    public PolicySetsAnnotationListener(ClassLoader cl) {
        PolicyAttachmentStore pas;
        this.store = PolicyAttachmentStore.getDefaultInstance();
        if (cl != null && !(pas = new PolicyAttachmentStore(cl)).isEmpty()) {
            pas.merge(this.store);
            this.store = pas;
        }
    }

    public PolicySetsAnnotationListener(PolicyAttachmentStore store) {
        this.store = store;
    }

    protected EndpointPolicyAttachments getEndpointPolicyAttachment(Class<?> clazz) {
        if (this.epaMap.containsKey(clazz)) {
            return this.epaMap.get(clazz);
        }
        PolicySets ps = clazz.getAnnotation(PolicySets.class);
        EndpointPolicyAttachments epa = ps != null ? EndpointPolicyAttachments.newInstance(ps.value(), this.store) : null;
        this.epaMap.put(clazz, epa);
        return epa;
    }

    public void handleEvent(FactoryBeanListener.Event ev, AbstractServiceFactoryBean factory, Object ... args) {
        switch (ev) {
            case ENDPOINT_SELECTED: {
                Class cls = (Class)args[2];
                Class implCls = (Class)args[3];
                Endpoint ep = (Endpoint)args[1];
                this.addPolicies(factory, ep, cls, implCls);
                break;
            }
            case BINDING_OPERATION_CREATED: {
                BindingOperationInfo boi = (BindingOperationInfo)args[1];
                Method m = (Method)args[2];
                this.addPolicies(factory, boi.getOperationInfo(), m);
                break;
            }
        }
    }

    private void addPolicies(AbstractServiceFactoryBean factory, OperationInfo inf, Method m) {
        if (m == null) {
            return;
        }
        Class<?> cls = m.getDeclaringClass();
        EndpointPolicyAttachments epa = this.getEndpointPolicyAttachment(cls);
        if (epa != null) {
            ServiceInfo service = inf.getInterface().getService();
            for (PolicyAttachment pa : epa.getPolicyAttachments(Policy.Placement.PORT_TYPE_OPERATION)) {
                this.addPolicy((AbstractPropertiesHolder)inf, service, pa, cls, inf.getName().getLocalPart() + "PortTypeOpPolicy");
            }
            for (PolicyAttachment pa : epa.getPolicyAttachments(Policy.Placement.PORT_TYPE_OPERATION_INPUT)) {
                this.addPolicy((AbstractPropertiesHolder)inf.getInput(), service, pa, cls, inf.getName().getLocalPart() + "PortTypeOpInputPolicy");
            }
            for (PolicyAttachment pa : epa.getPolicyAttachments(Policy.Placement.PORT_TYPE_OPERATION_OUTPUT)) {
                this.addPolicy((AbstractPropertiesHolder)inf.getOutput(), service, pa, cls, inf.getName().getLocalPart() + "PortTypeOpOutputPolicy");
            }
            for (PolicyAttachment pa : epa.getPolicyAttachments(Policy.Placement.PORT_TYPE_OPERATION_FAULT)) {
                for (FaultInfo f : inf.getFaults()) {
                    this.addPolicy((AbstractPropertiesHolder)f, service, pa, cls, f.getName().getLocalPart() + "PortTypeOpFaultPolicy");
                }
            }
        }
    }

    private void addPolicies(AbstractServiceFactoryBean factory, Endpoint ep, Class<?> seiCls, Class<?> implCls) {
        EndpointPolicyAttachments epa = null;
        Class<?> cls = seiCls;
        if (ep.getEndpointInfo().getInterface() != null) {
            epa = this.getEndpointPolicyAttachment(seiCls);
        }
        if (epa == null) {
            cls = implCls;
            epa = this.getEndpointPolicyAttachment(implCls);
        }
        if (epa != null) {
            BindingInfo binf = ep.getBinding().getBindingInfo();
            ServiceInfo si = (ServiceInfo)ep.getService().getServiceInfos().get(0);
            InterfaceInfo inf = ep.getEndpointInfo().getInterface();
            for (PolicyAttachment pa : epa.getPolicyAttachments(Policy.Placement.BINDING)) {
                this.addPolicy((AbstractPropertiesHolder)binf, si, pa, cls, binf.getName().getLocalPart() + "BindingPolicy");
            }
            for (PolicyAttachment pa : epa.getPolicyAttachments(Policy.Placement.PORT_TYPE)) {
                this.addPolicy((AbstractPropertiesHolder)inf, si, pa, cls, inf.getName().getLocalPart() + "PortTypePolicy");
            }
            for (PolicyAttachment pa : epa.getPolicyAttachments(Policy.Placement.SERVICE)) {
                this.addPolicy((AbstractPropertiesHolder)si, si, pa, cls, si.getName().getLocalPart() + "ServicePolicy");
            }
            for (PolicyAttachment pa : epa.getPolicyAttachments(Policy.Placement.SERVICE_PORT)) {
                this.addPolicy((AbstractPropertiesHolder)ep.getEndpointInfo(), si, pa, cls, ep.getEndpointInfo().getName().getLocalPart() + "PortPolicy");
            }
            for (BindingOperationInfo binfo : binf.getOperations()) {
                for (PolicyAttachment pa : epa.getPolicyAttachments(Policy.Placement.BINDING_OPERATION)) {
                    this.addPolicy((AbstractPropertiesHolder)binfo, si, pa, cls, binfo.getName().getLocalPart() + "BindingOpPolicy");
                }
                for (PolicyAttachment pa : epa.getPolicyAttachments(Policy.Placement.BINDING_OPERATION_INPUT)) {
                    this.addPolicy((AbstractPropertiesHolder)binfo.getInput(), si, pa, cls, binfo.getName().getLocalPart() + "BindingOpInputPolicy");
                }
                for (PolicyAttachment pa : epa.getPolicyAttachments(Policy.Placement.BINDING_OPERATION_OUTPUT)) {
                    this.addPolicy((AbstractPropertiesHolder)binfo.getOutput(), si, pa, cls, binfo.getName().getLocalPart() + "BindingOpOutputPolicy");
                }
                for (PolicyAttachment pa : epa.getPolicyAttachments(Policy.Placement.BINDING_OPERATION_FAULT)) {
                    for (BindingFaultInfo f : binfo.getFaults()) {
                        this.addPolicy((AbstractPropertiesHolder)f, si, pa, cls, f.getFaultInfo().getName().getLocalPart() + "BindingOpFaultPolicy");
                    }
                }
            }
        }
    }

    private void addPolicy(AbstractPropertiesHolder place, ServiceInfo service, PolicyAttachment pa, Class<?> cls, String defName) {
        Element el = this.addPolicy(service, pa, cls, defName);
        UnknownExtensibilityElement uee = new UnknownExtensibilityElement();
        uee.setElement(el);
        uee.setRequired(Boolean.valueOf(true));
        uee.setElementType(DOMUtils.getElementQName((Element)el));
        place.addExtensor((Object)uee);
    }

    private Element addPolicy(ServiceInfo service, PolicyAttachment pa, Class<?> cls, String defName) {
        Element element = pa.read(defName);
        String refId = this.getPolicyId(element);
        Loggers.ROOT_LOGGER.addingPolicyAttachment(pa.getPlacement(), refId, cls);
        if (service.getDescription() == null && cls != null) {
            service.setDescription(new DescriptionInfo());
            URL u = cls.getResource("/");
            if (u != null) {
                service.getDescription().setBaseURI(u.toString());
            }
        }
        if (!this.isExistsPolicy(service, refId)) {
            UnknownExtensibilityElement uee = new UnknownExtensibilityElement();
            uee.setElement(element);
            uee.setRequired(Boolean.valueOf(true));
            uee.setElementType(DOMUtils.getElementQName((Element)element));
            service.getDescription().addExtensor((Object)uee);
        }
        refId = "#" + refId;
        Document doc = DOMUtils.createDocument();
        Element el = doc.createElementNS(element.getNamespaceURI(), "wsp:PolicyReference");
        Attr att = doc.createAttributeNS(null, "URI");
        att.setValue(refId);
        el.setAttributeNodeNS(att);
        return el;
    }

    private String getPolicyId(Element element) {
        return element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    private boolean isExistsPolicy(ServiceInfo service, String uri) {
        Object[] exts = (Object[])service.getDescription().getExtensors().get();
        for (Object o : exts = exts == null ? new Object[]{} : exts) {
            UnknownExtensibilityElement uee;
            String uri2;
            if (!(o instanceof UnknownExtensibilityElement) || !uri.equals(uri2 = this.getPolicyId((uee = (UnknownExtensibilityElement)o).getElement()))) continue;
            return true;
        }
        return false;
    }
}

