/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jasper.Constants;
import org.apache.jasper.EmbeddedServletOptions;
import org.apache.jasper.JasperLogger;
import org.apache.jasper.JasperMessages;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.security.SecurityUtil;
import org.apache.jasper.servlet.JspServletWrapper;
import org.apache.tomcat.PeriodicEventListener;

public class JspServlet
extends HttpServlet
implements PeriodicEventListener {
    private ServletContext context;
    private ServletConfig config;
    private Options options;
    private JspRuntimeContext rctxt;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.config = config;
        this.context = config.getServletContext();
        Object optionsObject = this.context.getAttribute(Constants.SERVLET_OPTIONS);
        if (optionsObject != null && optionsObject instanceof Options) {
            this.options = (Options)optionsObject;
        } else {
            String engineOptionsName = config.getInitParameter("engineOptionsClass");
            if (engineOptionsName != null) {
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    Class<?> engineOptionsClass = loader.loadClass(engineOptionsName);
                    Class[] ctorSig = new Class[]{ServletConfig.class, ServletContext.class};
                    Constructor<?> ctor = engineOptionsClass.getConstructor(ctorSig);
                    Object[] args = new Object[]{config, this.context};
                    this.options = (Options)ctor.newInstance(args);
                }
                catch (Throwable e) {
                    JasperLogger.SERVLET_LOGGER.failedLoadingOptions(engineOptionsName, e);
                    this.options = new EmbeddedServletOptions(config, this.context);
                }
            } else {
                this.options = new EmbeddedServletOptions(config, this.context);
            }
        }
        this.rctxt = new JspRuntimeContext(this.context, this.options);
    }

    public int getJspCount() {
        return this.rctxt.getJspCount();
    }

    public void setJspReloadCount(int count) {
        this.rctxt.setJspReloadCount(count);
    }

    public int getJspReloadCount() {
        return this.rctxt.getJspReloadCount();
    }

    boolean preCompile(HttpServletRequest request) throws ServletException {
        String value;
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        int start = queryString.indexOf(Constants.PRECOMPILE);
        if (start < 0) {
            return false;
        }
        if ((queryString = queryString.substring(start + Constants.PRECOMPILE.length())).length() == 0) {
            return true;
        }
        if (queryString.startsWith("&")) {
            return true;
        }
        if (!queryString.startsWith("=")) {
            return false;
        }
        int limit = queryString.length();
        int ampersand = queryString.indexOf("&");
        if (ampersand > 0) {
            limit = ampersand;
        }
        if ((value = queryString.substring(1, limit)).equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return true;
        }
        throw new ServletException(JasperMessages.MESSAGES.invalidRequestParameterValue(Constants.PRECOMPILE, value));
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String jspUri = null;
        String jspFile = (String)request.getAttribute(Constants.JSP_FILE);
        if (jspFile != null) {
            jspUri = jspFile;
        } else {
            String pathInfo;
            jspUri = (String)request.getAttribute("javax.servlet.include.servlet_path");
            if (jspUri != null) {
                pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
                if (pathInfo != null) {
                    jspUri = jspUri + pathInfo;
                }
            } else {
                jspUri = request.getServletPath();
                pathInfo = request.getPathInfo();
                if (pathInfo != null) {
                    jspUri = jspUri + pathInfo;
                }
            }
        }
        try {
            boolean precompile = this.preCompile(request);
            this.serviceJspFile(request, response, jspUri, null, precompile);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    public void destroy() {
        this.rctxt.destroy();
    }

    @Override
    public void periodicEvent() {
        this.rctxt.checkCompile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceJspFile(HttpServletRequest request, HttpServletResponse response, String jspUri, Throwable exception, boolean precompile) throws ServletException, IOException {
        JspServletWrapper wrapper = this.rctxt.getWrapper(jspUri);
        if (wrapper == null) {
            JspServlet jspServlet = this;
            synchronized (jspServlet) {
                wrapper = this.rctxt.getWrapper(jspUri);
                if (wrapper == null) {
                    if (null == this.context.getResource(jspUri)) {
                        String includeRequestUri = (String)request.getAttribute("javax.servlet.include.request_uri");
                        if (includeRequestUri != null) {
                            String msg = JasperMessages.MESSAGES.fileNotFound(jspUri);
                            throw new ServletException(SecurityUtil.filter(msg));
                        }
                        try {
                            response.sendError(404, request.getRequestURI());
                        }
                        catch (IllegalStateException ise) {
                            JasperLogger.SERVLET_LOGGER.fileNotFound(jspUri);
                        }
                        return;
                    }
                    boolean isErrorPage = exception != null;
                    wrapper = new JspServletWrapper(this.config, this.options, jspUri, isErrorPage, this.rctxt);
                    this.rctxt.addWrapper(jspUri, wrapper);
                }
            }
        }
        wrapper.service(request, response, precompile);
    }
}

