/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.catalina.session;

import java.security.Principal;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Manager;
import org.apache.catalina.SessionListener;
import org.wildfly.clustering.web.Batcher;
import org.wildfly.clustering.web.catalina.session.LocalSessionContext;
import org.wildfly.clustering.web.session.HttpSessionAdapter;
import org.wildfly.clustering.web.session.Session;

public class SessionFacade
implements org.apache.catalina.Session {
    private final Manager manager;
    private final Session<LocalSessionContext> session;
    private final String internalId;
    private final Batcher batcher;

    public SessionFacade(Manager manager, Session<LocalSessionContext> session, String internalId, Batcher batcher) {
        this.manager = manager;
        this.session = session;
        this.internalId = internalId;
        this.batcher = batcher;
    }

    public String getAuthType() {
        return ((LocalSessionContext)this.session.getLocalContext()).getAuthType();
    }

    public void setAuthType(String authType) {
        ((LocalSessionContext)this.session.getLocalContext()).setAuthType(authType);
    }

    public long getCreationTime() {
        return this.session.getMetaData().getCreationTime().getTime();
    }

    public void setCreationTime(long time) {
    }

    public String getId() {
        return this.session.getId();
    }

    public String getIdInternal() {
        return this.internalId;
    }

    public void setId(String id) {
    }

    public String getInfo() {
        return String.format("%s/1.0", this.getClass().getSimpleName());
    }

    public long getLastAccessedTime() {
        return this.session.getMetaData().getLastAccessedTime().getTime();
    }

    public long getLastAccessedTimeInternal() {
        return this.getLastAccessedTime();
    }

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
    }

    public int getMaxInactiveInterval() {
        return (int)this.session.getMetaData().getMaxInactiveInterval(TimeUnit.SECONDS);
    }

    public void setMaxInactiveInterval(int interval) {
        this.session.getMetaData().setMaxInactiveInterval((long)interval, TimeUnit.SECONDS);
    }

    public void setNew(boolean isNew) {
    }

    public Principal getPrincipal() {
        return ((LocalSessionContext)this.session.getLocalContext()).getPrincipal();
    }

    public void setPrincipal(Principal principal) {
        ((LocalSessionContext)this.session.getLocalContext()).setPrincipal(principal);
    }

    public HttpSession getSession() {
        return new HttpSessionAdapter(this.session);
    }

    public void setValid(boolean isValid) {
    }

    public boolean isValid() {
        return true;
    }

    public boolean isValidInternal() {
        return this.isValidInternal();
    }

    public void addSessionListener(SessionListener listener) {
        ((LocalSessionContext)this.session.getLocalContext()).getSessionListeners().add(listener);
    }

    public void removeSessionListener(SessionListener listener) {
        ((LocalSessionContext)this.session.getLocalContext()).getSessionListeners().remove(listener);
    }

    public void access() {
    }

    public void endAccess() {
        this.session.close();
        this.batcher.endBatch(true);
    }

    public void expire() {
        this.session.invalidate();
        this.batcher.endBatch(true);
    }

    public Object getNote(String name) {
        return ((LocalSessionContext)this.session.getLocalContext()).getNotes().get(name);
    }

    public Iterator<String> getNoteNames() {
        return ((LocalSessionContext)this.session.getLocalContext()).getNotes().keySet().iterator();
    }

    public void recycle() {
    }

    public void removeNote(String name) {
        ((LocalSessionContext)this.session.getLocalContext()).getNotes().remove(name);
    }

    public void setNote(String name, Object value) {
        ((LocalSessionContext)this.session.getLocalContext()).getNotes().put(name, value);
    }
}

