/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletPathMatch;
import java.util.HashMap;
import java.util.Map;

class ServletPathMatchesData {
    private final Map<String, ServletPathMatch> exactPathMatches;
    private final Map<String, PathMatch> prefixMatches;
    private final Map<String, ServletChain> nameMatches;
    private final ServletChain defaultServlet;

    public ServletPathMatchesData(Map<String, ServletChain> exactPathMatches, Map<String, PathMatch> prefixMatches, Map<String, ServletChain> nameMatches, ServletChain defaultServlet) {
        this.prefixMatches = prefixMatches;
        this.nameMatches = nameMatches;
        this.defaultServlet = defaultServlet;
        HashMap<String, ServletPathMatch> newExactPathMatches = new HashMap<String, ServletPathMatch>();
        for (Map.Entry<String, ServletChain> entry : exactPathMatches.entrySet()) {
            newExactPathMatches.put(entry.getKey(), new ServletPathMatch(entry.getValue(), entry.getKey()));
        }
        this.exactPathMatches = newExactPathMatches;
    }

    public ServletChain getServletHandlerByName(String name) {
        return this.nameMatches.get(name);
    }

    public ServletPathMatch getServletHandlerByExactPath(String path) {
        return this.exactPathMatches.get(path);
    }

    public ServletPathMatch getServletHandlerByPath(String path) {
        ServletPathMatch exact = this.exactPathMatches.get(path);
        if (exact != null) {
            return exact;
        }
        PathMatch match = this.prefixMatches.get(path);
        if (match != null) {
            return this.handleMatch(path, match, path.lastIndexOf(46));
        }
        int extensionPos = -1;
        for (int i = path.length() - 1; i >= 0; --i) {
            char c = path.charAt(i);
            if (c == '/') {
                String part = path.substring(0, i);
                match = this.prefixMatches.get(part);
                if (match == null) continue;
                return this.handleMatch(path, match, extensionPos);
            }
            if (c != '.' || extensionPos != -1) continue;
            extensionPos = i;
        }
        return new ServletPathMatch(this.defaultServlet, path);
    }

    private ServletPathMatch handleMatch(String path, PathMatch match, int extensionPos) {
        if (match.extensionMatches.isEmpty()) {
            return new ServletPathMatch(match.defaultHandler, path);
        }
        if (extensionPos == -1) {
            return new ServletPathMatch(match.defaultHandler, path);
        }
        String ext = path.substring(extensionPos + 1, path.length());
        ServletChain handler = (ServletChain)match.extensionMatches.get(ext);
        if (handler != null) {
            return new ServletPathMatch(handler, path);
        }
        return new ServletPathMatch(match.defaultHandler, path);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class PathMatch {
        private final Map<String, ServletChain> extensionMatches = new HashMap<String, ServletChain>();
        private volatile ServletChain defaultHandler;

        public PathMatch(ServletChain defaultHandler) {
            this.defaultHandler = defaultHandler;
        }
    }

    public static final class Builder {
        private final Map<String, ServletChain> exactPathMatches = new HashMap<String, ServletChain>();
        private final Map<String, PathMatch> prefixMatches = new HashMap<String, PathMatch>();
        private final Map<String, ServletChain> nameMatches = new HashMap<String, ServletChain>();
        private ServletChain defaultServlet;

        public void addExactMatch(String exactMatch, ServletChain match) {
            this.exactPathMatches.put(exactMatch, match);
        }

        public void addPrefixMatch(String prefix, ServletChain match) {
            PathMatch m = this.prefixMatches.get(prefix);
            if (m == null) {
                m = new PathMatch(match);
                this.prefixMatches.put(prefix, m);
            }
            m.defaultHandler = match;
        }

        public void addExtensionMatch(String prefix, String extension, ServletChain match) {
            PathMatch m = this.prefixMatches.get(prefix);
            if (m == null) {
                m = new PathMatch(null);
                this.prefixMatches.put(prefix, m);
            }
            m.extensionMatches.put(extension, match);
        }

        public void addNameMatch(String name, ServletChain match) {
            this.nameMatches.put(name, match);
        }

        public ServletChain getDefaultServlet() {
            return this.defaultServlet;
        }

        public void setDefaultServlet(ServletChain defaultServlet) {
            this.defaultServlet = defaultServlet;
        }

        public ServletPathMatchesData build() {
            return new ServletPathMatchesData(this.exactPathMatches, this.prefixMatches, this.nameMatches, this.defaultServlet);
        }
    }
}

