/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import org.hornetq.ra.inflow.HornetQActivationSpec;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;

@MessageLogger(projectCode="HQ")
public interface HornetQRALogger
extends BasicLogger {
    public static final HornetQRALogger LOGGER = (HornetQRALogger)Logger.getMessageLogger(HornetQRALogger.class, (String)HornetQRALogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=151000, value="awaiting topic/queue creation {0}", format=Message.Format.MESSAGE_FORMAT)
    public void awaitingTopicQueueCreation(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=151001, value="Attempting to reconnect {0}", format=Message.Format.MESSAGE_FORMAT)
    public void attemptingReconnect(HornetQActivationSpec var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=151002, value="Reconnected with HornetQ", format=Message.Format.MESSAGE_FORMAT)
    public void reconnected();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=151003, value="HornetQ resource adaptor stopped", format=Message.Format.MESSAGE_FORMAT)
    public void raStopped();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=151004, value="Instantiating {0} \"{1}\" directly since UseJNDI=false.", format=Message.Format.MESSAGE_FORMAT)
    public void instantiatingDestination(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=151005, value="awaiting HornetQ Server availability", format=Message.Format.MESSAGE_FORMAT)
    public void awaitingJMSServerCreation();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=152000, value="It wasn't possible to lookup for a Transaction Manager through the configured properties TransactionManagerLocatorClass and TransactionManagerLocatorMethod\nHornetQ Resource Adapter won't be able to set and verify transaction timeouts in certain cases.", format=Message.Format.MESSAGE_FORMAT)
    public void noTXLocator();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=152001, value="problem resetting HornetQ xa session after failure", format=Message.Format.MESSAGE_FORMAT)
    public void problemResettingXASession();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=152002, value="Unable to roll local transaction back", format=Message.Format.MESSAGE_FORMAT)
    public void unableToRollbackTX();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=152003, value="unable to reset session after failure", format=Message.Format.MESSAGE_FORMAT)
    public void unableToResetSession();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=152004, value="Handling JMS exception failure", format=Message.Format.MESSAGE_FORMAT)
    public void handlingJMSFailure(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=152005, value="Failure in HornetQ activation {0}", format=Message.Format.MESSAGE_FORMAT)
    public void failureInActivation(@Cause Throwable var1, HornetQActivationSpec var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=152006, value="Unable to call after delivery", format=Message.Format.MESSAGE_FORMAT)
    public void unableToCallAfterDelivery(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=152007, value="unable to clear the transaction", format=Message.Format.MESSAGE_FORMAT)
    public void unableToClearTX(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=154000, value="Error while creating object Reference.", format=Message.Format.MESSAGE_FORMAT)
    public void errorCreatingReference(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=154001, value="Unable to stop HornetQ resource adapter.", format=Message.Format.MESSAGE_FORMAT)
    public void errorStoppingRA(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=154002, value="Could not create session", format=Message.Format.MESSAGE_FORMAT)
    public void errorCreatingSession(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=154003, value="Unable to reconnect {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorReconnecting(@Cause Throwable var1, HornetQActivationSpec var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=154004, value="Failed to deliver message", format=Message.Format.MESSAGE_FORMAT)
    public void errorDeliveringMessage(@Cause Throwable var1);
}

