/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra.inflow;

import java.io.Serializable;
import java.util.Hashtable;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import org.hornetq.ra.ConnectionFactoryProperties;
import org.hornetq.ra.HornetQRALogger;
import org.hornetq.ra.HornetQRaUtils;
import org.hornetq.ra.HornetQResourceAdapter;

public class HornetQActivationSpec
extends ConnectionFactoryProperties
implements ActivationSpec,
Serializable {
    private static final long serialVersionUID = -7997041053897964654L;
    private static final int DEFAULT_MAX_SESSION = 15;
    private static boolean trace = HornetQRALogger.LOGGER.isTraceEnabled();
    public String strConnectorClassName;
    public String strConnectionParameters;
    private HornetQResourceAdapter ra;
    private String destination;
    private String destinationType;
    private String messageSelector;
    private int acknowledgeMode;
    private boolean subscriptionDurability;
    private String subscriptionName;
    private boolean shareSubscriptions;
    private String user;
    private String password;
    private Integer maxSession;
    private Integer transactionTimeout;
    private Boolean useJNDI = true;
    private String jndiParams = null;
    private Hashtable parsedJndiParams;
    private Boolean localTx;
    private Integer setupAttempts;
    private Long setupInterval;

    public HornetQActivationSpec() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("constructor()");
        }
        this.ra = null;
        this.destination = null;
        this.destinationType = null;
        this.messageSelector = null;
        this.acknowledgeMode = 1;
        this.subscriptionDurability = false;
        this.subscriptionName = null;
        this.user = null;
        this.password = null;
        this.maxSession = 15;
        this.transactionTimeout = 0;
    }

    public ResourceAdapter getResourceAdapter() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getResourceAdapter()");
        }
        return this.ra;
    }

    public boolean isUseJNDI() {
        if (this.useJNDI == null) {
            return this.ra.isUseJNDI();
        }
        return this.useJNDI;
    }

    public void setUseJNDI(boolean value) {
        this.useJNDI = value;
    }

    public String getJndiParams() {
        if (this.jndiParams == null) {
            return this.ra.getJndiParams();
        }
        return this.jndiParams;
    }

    public void setJndiParams(String jndiParams) {
        this.jndiParams = jndiParams;
        this.parsedJndiParams = HornetQRaUtils.parseHashtableConfig(jndiParams);
    }

    public Hashtable<?, ?> getParsedJndiParams() {
        if (this.parsedJndiParams == null) {
            return this.ra.getParsedJndiParams();
        }
        return this.parsedJndiParams;
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setResourceAdapter(" + ra + ")");
        }
        if (ra == null || !(ra instanceof HornetQResourceAdapter)) {
            throw new ResourceException("Resource adapter is " + ra);
        }
        this.ra = (HornetQResourceAdapter)ra;
    }

    public String getDestination() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getDestination()");
        }
        return this.destination;
    }

    public void setDestination(String value) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setDestination(" + value + ")");
        }
        this.destination = value;
    }

    public String getDestinationType() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getDestinationType()");
        }
        return this.destinationType;
    }

    public void setDestinationType(String value) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setDestinationType(" + value + ")");
        }
        this.destinationType = value;
    }

    public String getMessageSelector() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getMessageSelector()");
        }
        return this.messageSelector;
    }

    public void setMessageSelector(String value) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setMessageSelector(" + value + ")");
        }
        this.messageSelector = value;
    }

    public String getAcknowledgeMode() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getAcknowledgeMode()");
        }
        if (3 == this.acknowledgeMode) {
            return "Dups-ok-acknowledge";
        }
        return "Auto-acknowledge";
    }

    public void setAcknowledgeMode(String value) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setAcknowledgeMode(" + value + ")");
        }
        if ("DUPS_OK_ACKNOWLEDGE".equalsIgnoreCase(value) || "Dups-ok-acknowledge".equalsIgnoreCase(value)) {
            this.acknowledgeMode = 3;
        } else if ("AUTO_ACKNOWLEDGE".equalsIgnoreCase(value) || "Auto-acknowledge".equalsIgnoreCase(value)) {
            this.acknowledgeMode = 1;
        } else {
            throw new IllegalArgumentException("Unsupported acknowledgement mode " + value);
        }
    }

    public int getAcknowledgeModeInt() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getAcknowledgeMode()");
        }
        return this.acknowledgeMode;
    }

    public String getSubscriptionDurability() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getSubscriptionDurability()");
        }
        if (this.subscriptionDurability) {
            return "Durable";
        }
        return "NonDurable";
    }

    public void setSubscriptionDurability(String value) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setSubscriptionDurability(" + value + ")");
        }
        this.subscriptionDurability = "Durable".equals(value);
    }

    public boolean isSubscriptionDurable() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("isSubscriptionDurable()");
        }
        return this.subscriptionDurability;
    }

    public String getSubscriptionName() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getSubscriptionName()");
        }
        return this.subscriptionName;
    }

    public void setSubscriptionName(String value) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setSubscriptionName(" + value + ")");
        }
        this.subscriptionName = value;
    }

    public boolean isShareSubscriptions() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("isShareSubscriptions() = " + this.shareSubscriptions);
        }
        return this.shareSubscriptions;
    }

    public void setShareSubscriptions(boolean shareSubscriptions) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setShareSubscriptions(" + shareSubscriptions + ")");
        }
        this.shareSubscriptions = shareSubscriptions;
    }

    public String getUser() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getUser()");
        }
        if (this.user == null) {
            return this.ra.getUserName();
        }
        return this.user;
    }

    public void setUser(String value) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setUser(" + value + ")");
        }
        this.user = value;
    }

    public String getPassword() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getPassword()");
        }
        if (this.password == null) {
            return this.ra.getPassword();
        }
        return this.password;
    }

    public String getOwnPassword() {
        return this.password;
    }

    public void setPassword(String value) throws Exception {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setPassword(" + value + ")");
        }
        this.password = value;
    }

    public Integer getMaxSession() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getMaxSession()");
        }
        if (this.maxSession == null) {
            return 15;
        }
        return this.maxSession;
    }

    public void setMaxSession(Integer value) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setMaxSession(" + value + ")");
        }
        this.maxSession = value;
    }

    public Integer getTransactionTimeout() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getTransactionTimeout()");
        }
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(Integer value) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setTransactionTimeout(" + value + ")");
        }
        this.transactionTimeout = value;
    }

    public Boolean isUseLocalTx() {
        if (this.localTx == null) {
            return this.ra.getUseLocalTx();
        }
        return this.localTx;
    }

    public void setUseLocalTx(Boolean localTx) {
        this.localTx = localTx;
    }

    public int getSetupAttempts() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getSetupAttempts()");
        }
        if (this.setupAttempts == null) {
            return this.ra.getSetupAttempts();
        }
        return this.setupAttempts;
    }

    public void setSetupAttempts(int setupAttempts) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setSetupAttempts(" + setupAttempts + ")");
        }
        this.setupAttempts = setupAttempts;
    }

    public long getSetupInterval() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getSetupInterval()");
        }
        if (this.setupInterval == null) {
            return this.ra.getSetupInterval();
        }
        return this.setupInterval;
    }

    public void setSetupInterval(long setupInterval) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setSetupInterval(" + setupInterval + ")");
        }
        this.setupInterval = setupInterval;
    }

    public void validate() throws InvalidPropertyException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("validate()");
        }
        if (this.destination == null || this.destination.trim().equals("")) {
            throw new InvalidPropertyException("Destination is mandatory");
        }
    }

    public String getConnectorClassName() {
        return this.strConnectorClassName;
    }

    public void setConnectorClassName(String connectorClassName) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setConnectorClassName(" + connectorClassName + ")");
        }
        this.strConnectorClassName = connectorClassName;
        this.setParsedConnectorClassNames(HornetQRaUtils.parseConnectorConnectorConfig(connectorClassName));
    }

    public String getConnectionParameters() {
        return this.strConnectionParameters;
    }

    public void setConnectionParameters(String configuration) {
        this.strConnectionParameters = configuration;
        this.setParsedConnectionParameters(HornetQRaUtils.parseConfig(configuration));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(HornetQActivationSpec.class.getName()).append('(');
        buffer.append("ra=").append(this.ra);
        buffer.append(" destination=").append(this.destination);
        buffer.append(" destinationType=").append(this.destinationType);
        if (this.messageSelector != null) {
            buffer.append(" selector=").append(this.messageSelector);
        }
        buffer.append(" ack=").append(this.getAcknowledgeMode());
        buffer.append(" durable=").append(this.subscriptionDurability);
        buffer.append(" clientID=").append(this.getClientID());
        if (this.subscriptionName != null) {
            buffer.append(" subscription=").append(this.subscriptionName);
        }
        buffer.append(" user=").append(this.user);
        if (this.password != null) {
            buffer.append(" password=").append("****");
        }
        buffer.append(" maxSession=").append(this.maxSession);
        buffer.append(')');
        return buffer.toString();
    }

    public void setUseDLQ(boolean b) {
    }

    public void setDLQJNDIName(String name) {
    }

    public void setDLQHandler(String handler) {
    }

    public void setDLQMaxResent(int maxResent) {
    }

    public void setProviderAdapterJNDI(String jndi) {
    }

    public void setKeepAlive(boolean keepAlive) {
    }

    public void setKeepAliveMillis(long keepAliveMillis) {
    }

    public void setReconnectInterval(long interval) {
    }

    public void setMinSession(Integer value) {
    }

    public void setMaxMessages(Integer value) {
    }
}

