/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Permission;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorService;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.AbstractBundleContext;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.BundleStateRevision;
import org.jboss.osgi.framework.internal.CoreServices;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.BundleStartLevelSupport;
import org.jboss.osgi.framework.spi.FrameworkEvents;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.framework.spi.ServiceState;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.metadata.CaseInsensitiveDictionary;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.spi.AbstractElement;
import org.jboss.osgi.spi.ConstantsHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Wire;
import org.osgi.service.resolver.ResolutionException;

abstract class AbstractBundleState<R extends BundleStateRevision>
extends AbstractElement
implements XBundle,
LockManager.LockableItem,
BundleStartLevel {
    private final long bundleId;
    private final FrameworkState frameworkState;
    private final ReentrantLock bundleLock = new ReentrantLock();
    private final AtomicInteger bundleState = new AtomicInteger(2);
    private final List<ServiceState<?>> registeredServices = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<ServiceState<?>, AtomicInteger> usedServices = new ConcurrentHashMap();
    private AbstractBundleContext<? extends AbstractBundleState<?>> bundleContext;
    private Exception lastResolverException;
    private R initialRevision;
    private R currentRevision;

    AbstractBundleState(FrameworkState frameworkState, R brev, long bundleId) {
        assert (frameworkState != null) : "Null frameworkState";
        assert (brev != null) : "Null revision";
        String symbolicName = ((BundleStateRevision)((Object)brev)).getOSGiMetaData().getBundleSymbolicName();
        if (symbolicName != null && symbolicName.indexOf(59) > 0) {
            symbolicName = symbolicName.substring(0, symbolicName.indexOf(59));
        }
        this.bundleId = bundleId;
        this.frameworkState = frameworkState;
        this.initialRevision = brev;
        brev.setBundle((XBundle)this);
    }

    static AbstractBundleState<?> assertBundleState(Bundle bundle2) {
        assert (bundle2 != null) : "Null bundle";
        assert (bundle2 instanceof AbstractBundleState) : "Not a BundleState: " + bundle2;
        return (AbstractBundleState)bundle2;
    }

    FrameworkState getFrameworkState() {
        return this.frameworkState;
    }

    BundleManagerPlugin getBundleManager() {
        return this.frameworkState.getBundleManager();
    }

    CoreServices getCoreServices() {
        return this.frameworkState.getCoreServices();
    }

    public int getState() {
        return this.bundleState.get();
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public String getSymbolicName() {
        return this.getBundleRevision().getSymbolicName();
    }

    abstract AbstractBundleContext<?> createContextInternal();

    public <T> T adapt(Class<T> type) {
        Object result = null;
        if (type.isAssignableFrom(BundleContext.class)) {
            result = this.getBundleContext();
        } else if (type.isAssignableFrom(BundleRevision.class)) {
            result = !this.isUninstalled() ? this.getBundleRevision() : null;
        } else if (type.isAssignableFrom(BundleRevisions.class)) {
            result = this.getBundleRevisions();
        } else if (type.isAssignableFrom(BundleStartLevel.class)) {
            result = this;
        } else if (type.isAssignableFrom(BundleWiring.class)) {
            result = !this.isUninstalled() ? this.getBundleWiring() : null;
        } else if (type.isAssignableFrom(OSGiMetaData.class)) {
            result = this.getOSGiMetaData();
        } else if (type.isAssignableFrom(StorageState.class)) {
            result = this.getStorageState();
        } else if (type.isAssignableFrom(BundleManager.class)) {
            result = this.getBundleManager();
        }
        return (T)result;
    }

    abstract BundleRevisions getBundleRevisions();

    public R getBundleRevision() {
        return this.currentRevision != null ? this.currentRevision : this.initialRevision;
    }

    void addBundleRevision(R rev) {
        rev.setBundle((XBundle)this);
        this.currentRevision = rev;
    }

    abstract R getBundleRevisionById(int var1);

    abstract boolean isSingleton();

    StorageState getStorageState() {
        return ((BundleStateRevision)((Object)this.getBundleRevision())).getStorageState();
    }

    ModuleIdentifier getModuleIdentifier() {
        return ((BundleStateRevision)((Object)this.getBundleRevision())).getModuleIdentifier();
    }

    void changeState(int state) {
        int bundleEvent;
        switch (state) {
            case 8: {
                bundleEvent = 128;
                break;
            }
            case 32: {
                bundleEvent = 2;
                break;
            }
            case 16: {
                bundleEvent = 256;
                break;
            }
            case 1: {
                bundleEvent = 16;
                break;
            }
            case 2: {
                bundleEvent = 1;
                break;
            }
            case 4: {
                bundleEvent = 32;
                break;
            }
            default: {
                throw FrameworkMessages.MESSAGES.illegalArgumentUnknownBundleState(state);
            }
        }
        this.changeState(state, bundleEvent);
    }

    void changeState(int state, int eventType) {
        FrameworkLogger.LOGGER.tracef("changeState: %s -> %s", this, ConstantsHelper.bundleState((int)state));
        boolean frameworkActive = this.getBundleManager().isFrameworkCreated();
        if (frameworkActive && this.getBundleId() > 0L) {
            LifecycleInterceptorService plugin = this.getCoreServices().getLifecycleInterceptorService();
            plugin.handleStateChange(state, (Bundle)this);
        }
        this.bundleState.set(state);
        if (frameworkActive && eventType != 0) {
            this.fireBundleEvent(eventType);
        }
    }

    void fireBundleEvent(int eventType) {
        FrameworkEvents eventsPlugin = this.getFrameworkState().getFrameworkEvents();
        eventsPlugin.fireBundleEvent(this, eventType);
    }

    void addRegisteredService(ServiceState<?> serviceState) {
        FrameworkLogger.LOGGER.tracef("Add registered service %s to: %s", serviceState, this);
        this.registeredServices.add(serviceState);
    }

    public Bundle getBundle() {
        return this;
    }

    public int getStartLevel() {
        BundleStartLevelSupport plugin = this.frameworkState.getBundleStartLevel();
        return plugin.getBundleStartLevel(this);
    }

    public void setStartLevel(int level) {
        BundleStartLevelSupport plugin = this.frameworkState.getBundleStartLevel();
        plugin.setBundleStartLevel(this, level);
    }

    public boolean isPersistentlyStarted() {
        BundleStartLevelSupport plugin = this.frameworkState.getBundleStartLevel();
        return plugin.isBundlePersistentlyStarted(this);
    }

    public boolean isActivationPolicyUsed() {
        BundleStartLevelSupport plugin = this.frameworkState.getBundleStartLevel();
        return plugin.isBundleActivationPolicyUsed(this);
    }

    void removeRegisteredService(ServiceState<?> serviceState) {
        FrameworkLogger.LOGGER.tracef("Remove registered service %s from: %s", serviceState, this);
        this.registeredServices.remove(serviceState);
    }

    public ServiceReference<?>[] getRegisteredServices() {
        this.assertNotUninstalled();
        List<ServiceState<?>> rs = this.getRegisteredServicesInternal();
        if (rs.isEmpty()) {
            return null;
        }
        ArrayList<ServiceReference> srefs = new ArrayList<ServiceReference>();
        for (ServiceState<?> serviceState : rs) {
            srefs.add(serviceState.getReference());
        }
        return srefs.toArray(new ServiceReference[srefs.size()]);
    }

    List<ServiceState<?>> getRegisteredServicesInternal() {
        return Collections.unmodifiableList(this.registeredServices);
    }

    public ServiceReference<?>[] getServicesInUse() {
        this.assertNotUninstalled();
        Set<ServiceState<?>> servicesInUse = this.getServicesInUseInternal();
        if (servicesInUse.isEmpty()) {
            return null;
        }
        ArrayList<ServiceReference> srefs = new ArrayList<ServiceReference>();
        for (ServiceState<?> serviceState : servicesInUse) {
            srefs.add(serviceState.getReference());
        }
        return srefs.toArray(new ServiceReference[srefs.size()]);
    }

    Set<ServiceState<?>> getServicesInUseInternal() {
        return Collections.unmodifiableSet(this.usedServices.keySet());
    }

    void addServiceInUse(ServiceState<?> serviceState) {
        FrameworkLogger.LOGGER.tracef("Add service in use %s to: %s", serviceState, this);
        this.usedServices.putIfAbsent(serviceState, new AtomicInteger());
        AtomicInteger count = this.usedServices.get(serviceState);
        count.incrementAndGet();
    }

    int removeServiceInUse(ServiceState<?> serviceState) {
        FrameworkLogger.LOGGER.tracef("Remove service in use %s from: %s", serviceState, this);
        AtomicInteger count = this.usedServices.get(serviceState);
        if (count == null) {
            return -1;
        }
        int countVal = count.decrementAndGet();
        if (countVal == 0) {
            this.usedServices.remove(serviceState);
        }
        return countVal;
    }

    public boolean hasPermission(Object permission) {
        if (permission == null || !(permission instanceof Permission)) {
            return false;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return true;
        }
        return true;
    }

    public URL getResource(String name) {
        return this.getBundleRevision().getResource(name);
    }

    public Dictionary<String, String> getHeaders() {
        return this.getHeaders(null);
    }

    public Dictionary<String, String> getHeaders(String locale) {
        URL entryURL;
        String baseName;
        Dictionary rawHeaders = this.getOSGiMetaData().getHeaders();
        if ("".equals(locale)) {
            return rawHeaders;
        }
        if (locale == null) {
            locale = Locale.getDefault().toString();
        }
        if ((baseName = (String)rawHeaders.get("Bundle-Localization")) == null) {
            baseName = "OSGI-INF/l10n/bundle";
        }
        if ((entryURL = this.getLocalizationEntry(baseName, locale)) == null) {
            String defaultLocale = Locale.getDefault().toString();
            entryURL = this.getLocalizationEntry(baseName, defaultLocale);
        }
        PropertyResourceBundle resBundle = null;
        if (entryURL != null) {
            try {
                resBundle = new PropertyResourceBundle(entryURL.openStream());
            }
            catch (IOException ex) {
                throw FrameworkMessages.MESSAGES.illegalStateCannotReadResourceBundle(ex, entryURL);
            }
        }
        Hashtable<String, String> locHeaders = new Hashtable<String, String>();
        Enumeration e = rawHeaders.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)rawHeaders.get(key);
            if (value.startsWith("%")) {
                value = value.substring(1);
            }
            if (resBundle != null) {
                try {
                    value = resBundle.getString(value);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
            }
            ((Dictionary)locHeaders).put(key, value);
        }
        return new CaseInsensitiveDictionary(locHeaders);
    }

    OSGiMetaData getOSGiMetaData() {
        return ((BundleStateRevision)((Object)this.getBundleRevision())).getOSGiMetaData();
    }

    public boolean isResolved() {
        return this.getBundleWiring() != null;
    }

    BundleWiring getBundleWiring() {
        return this.getBundleRevision().getWiring();
    }

    boolean isUninstalled() {
        return this.getState() == 1;
    }

    private URL getLocalizationEntry(String baseName, String locale) {
        String entryPath = baseName + "_" + locale + ".properties";
        URL entryURL = this.getLocalizationEntry(entryPath);
        while (entryURL == null && !entryPath.equals(baseName + ".properties")) {
            int lastIndex = locale.lastIndexOf(95);
            if (lastIndex > 0) {
                locale = locale.substring(0, lastIndex);
                entryPath = baseName + "_" + locale + ".properties";
            } else {
                entryPath = baseName + ".properties";
            }
            entryURL = this.getLocalizationEntry(entryPath);
        }
        return entryURL;
    }

    private URL getLocalizationEntry(String entryPath) {
        return ((BundleStateRevision)((Object)this.getBundleRevision())).getLocalizationEntry(entryPath);
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        this.assertNotUninstalled();
        return ((BundleStateRevision)((Object)this.getBundleRevision())).loadClass(className);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return this.getBundleRevision().getResources(name);
    }

    public Enumeration<String> getEntryPaths(String path) {
        return this.getBundleRevision().getEntryPaths(path);
    }

    public URL getEntry(String path) {
        return this.getBundleRevision().getEntry(path);
    }

    public long getLastModified() {
        return this.getStorageState().getLastModified();
    }

    void updateLastModified() {
        this.getStorageState().updateLastModified();
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        return this.getBundleRevision().findEntries(path, filePattern, recurse);
    }

    AbstractBundleContext<? extends AbstractBundleState<?>> getBundleContextInternal() {
        return this.bundleContext;
    }

    AbstractBundleContext<? extends AbstractBundleState<?>> createBundleContext() {
        assert (this.bundleContext == null) : "BundleContext already available";
        this.bundleContext = this.createContextInternal();
        return this.bundleContext;
    }

    void destroyBundleContext() {
        if (this.bundleContext != null) {
            this.bundleContext.destroy();
            this.bundleContext = null;
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
        throw new UnsupportedOperationException();
    }

    public Version getVersion() {
        return this.getBundleRevision().getVersion();
    }

    public void start() throws BundleException {
        this.startWithOptions(0);
    }

    public void start(int options) throws BundleException {
        this.startWithOptions(options);
    }

    private void startWithOptions(int options) throws BundleException {
        this.assertStartConditions(options);
        this.getBundleManager().startBundleLifecycle(this, options);
    }

    void assertStartConditions(int options) throws BundleException {
        if (this.isFragment()) {
            throw FrameworkMessages.MESSAGES.cannotStartFragment();
        }
        this.assertNotUninstalled();
    }

    abstract void startInternal(int var1) throws BundleException;

    public void stop() throws BundleException {
        this.stopWithOptions(0);
    }

    public void stop(int options) throws BundleException {
        this.stopWithOptions(options);
    }

    void stopWithOptions(int options) throws BundleException {
        this.assertStopConditions(options);
        this.getBundleManager().stopBundleLifecycle(this, options);
    }

    void assertStopConditions(int options) throws BundleException {
        if (this.isFragment()) {
            throw FrameworkMessages.MESSAGES.cannotStopFragment();
        }
        this.assertNotUninstalled();
    }

    abstract void stopInternal(int var1) throws BundleException;

    public void update() throws BundleException {
        this.updateWithInputStream(null);
    }

    public void update(InputStream input) throws BundleException {
        this.updateWithInputStream(input);
    }

    private void updateWithInputStream(InputStream input) throws BundleException {
        this.assertNotUninstalled();
        this.getBundleManager().updateBundle(this, input);
    }

    abstract void updateInternal(InputStream var1) throws BundleException;

    public void uninstall() throws BundleException {
        this.assertNotUninstalled();
        this.getBundleManager().uninstallBundle(this, 256);
    }

    abstract void uninstallInternal(int var1) throws BundleException;

    boolean ensureResolved(boolean fireEvent) {
        if (this.isUninstalled()) {
            throw FrameworkMessages.MESSAGES.illegalStateBundleAlreadyUninstalled((Bundle)this);
        }
        boolean result = true;
        if (!this.isResolved()) {
            try {
                this.getBundleManager().resolveBundleLifecycle(this);
                if (FrameworkLogger.LOGGER.isDebugEnabled()) {
                    BundleWiring wiring = this.getBundleRevision().getWiring();
                    FrameworkLogger.LOGGER.tracef("Required resource wires for: %s", wiring.getResource());
                    for (Wire wire : wiring.getRequiredResourceWires(null)) {
                        FrameworkLogger.LOGGER.tracef("   %s", wire);
                    }
                    FrameworkLogger.LOGGER.tracef("Provided resource wires for: %s", wiring.getResource());
                    for (Wire wire : wiring.getProvidedResourceWires(null)) {
                        FrameworkLogger.LOGGER.tracef("   %s", wire);
                    }
                }
            }
            catch (ResolutionException ex) {
                result = false;
                this.handleResolverException(fireEvent, 4, (Exception)((Object)ex));
            }
            catch (RuntimeException ex) {
                result = false;
                this.handleResolverException(fireEvent, 12, ex);
            }
        }
        return result;
    }

    private void handleResolverException(boolean fireEvent, int type, Exception ex) {
        FrameworkLogger.LOGGER.debugf(ex, "Cannot resolve bundle: %s", this);
        this.lastResolverException = ex;
        if (fireEvent) {
            FrameworkEvents eventsPlugin = this.getFrameworkState().getFrameworkEvents();
            eventsPlugin.fireFrameworkEvent(this, 2, new BundleException(ex.getMessage(), type, (Throwable)ex), new FrameworkListener[0]);
        }
    }

    Exception getLastResolverException() {
        return this.lastResolverException;
    }

    @Override
    public ReentrantLock getReentrantLock() {
        return this.bundleLock;
    }

    void assertNotUninstalled() {
        if (this.isUninstalled()) {
            throw FrameworkMessages.MESSAGES.illegalStateBundleAlreadyUninstalled((Bundle)this);
        }
    }

    public String getCanonicalName() {
        return ((BundleStateRevision)((Object)this.getBundleRevision())).getCanonicalName();
    }

    public int hashCode() {
        return (int)this.getBundleId() * 51;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XBundle)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        XBundle other = (XBundle)obj;
        return this.getBundleId() == other.getBundleId();
    }

    public String toString() {
        return this.getCanonicalName();
    }

    public File getDataFile(String filename) {
        throw new UnsupportedOperationException();
    }

    public int compareTo(Bundle o) {
        throw new UnsupportedOperationException();
    }
}

