/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.FrameworkWiringLock;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResource;

final class FrameworkEnvironment
extends AbstractIntegrationService<FrameworkEnvironment> {
    static final ServiceName SERVICE_NAME = IntegrationServices.INTERNAL_BASE_NAME.append(new String[]{"FrameworkEnvironment"});
    private final InjectedValue<LockManager> injectedLockManager = new InjectedValue();
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();

    FrameworkEnvironment() {
        super(SERVICE_NAME);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<FrameworkEnvironment> builder) {
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, this.injectedEnvironment);
        builder.addDependency(IntegrationServices.LOCK_MANAGER_PLUGIN, LockManager.class, this.injectedLockManager);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    protected FrameworkEnvironment createServiceValue(StartContext startContext) throws StartException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void installResources(XBundleRevision brev) {
        if (brev == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("brev");
        }
        LockManager.LockContext lockContext = null;
        try {
            lockContext = this.lockResources(LockManager.Method.INSTALL, brev);
            ((XEnvironment)this.injectedEnvironment.getValue()).installResources(new XResource[]{brev});
        }
        finally {
            this.unlockResources(lockContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uninstallResources(XBundleRevision brev) {
        if (brev == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("brev");
        }
        LockManager.LockContext lockContext = null;
        try {
            lockContext = this.lockResources(LockManager.Method.UNINSTALL, brev);
            ((XEnvironment)this.injectedEnvironment.getValue()).uninstallResources(new XResource[]{brev});
        }
        finally {
            this.unlockResources(lockContext);
        }
    }

    private LockManager.LockContext lockResources(LockManager.Method method, XBundleRevision brev) {
        LockManager lockManager = (LockManager)this.injectedLockManager.getValue();
        FrameworkWiringLock wireLock = lockManager.getItemForType(FrameworkWiringLock.class);
        return lockManager.lockItems(method, wireLock, (LockManager.LockableItem)brev.getBundle());
    }

    private void unlockResources(LockManager.LockContext context) {
        LockManager lockManager = (LockManager)this.injectedLockManager.getValue();
        lockManager.unlockItems(context);
    }
}

