/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.AbstractBundleContext;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.NoFilter;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.framework.spi.FrameworkEvents;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.framework.spi.ServiceState;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.spi.RemoveOnlyCollection;
import org.jboss.osgi.resolver.spi.RemoveOnlyMap;
import org.jboss.osgi.spi.ConstantsHelper;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.UnfilteredServiceListener;
import org.osgi.framework.hooks.bundle.EventHook;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.framework.hooks.service.ListenerHook;

final class FrameworkEventsImpl
implements FrameworkEvents {
    private final BundleManagerPlugin bundleManager;
    private final ExecutorService executorService;
    private final LockManager lockManager;
    private final Map<XBundle, List<BundleListenerRegistration>> bundleListeners = new ConcurrentHashMap<XBundle, List<BundleListenerRegistration>>();
    private final Map<XBundle, List<FrameworkListener>> frameworkListeners = new ConcurrentHashMap<XBundle, List<FrameworkListener>>();
    private final Map<XBundle, List<ServiceListenerRegistration>> serviceListeners = new ConcurrentHashMap<XBundle, List<ServiceListenerRegistration>>();
    private Set<Integer> asyncBundleEvents = new HashSet<Integer>();
    private Set<String> infoEvents = new HashSet<String>();

    FrameworkEventsImpl(BundleManagerPlugin bundleManager, ExecutorService executorService, LockManager lockManager) {
        this.bundleManager = bundleManager;
        this.executorService = executorService;
        this.lockManager = lockManager;
        this.asyncBundleEvents.add(new Integer(1));
        this.asyncBundleEvents.add(new Integer(32));
        this.asyncBundleEvents.add(new Integer(2));
        this.asyncBundleEvents.add(new Integer(4));
        this.asyncBundleEvents.add(new Integer(8));
        this.asyncBundleEvents.add(new Integer(64));
        this.asyncBundleEvents.add(new Integer(16));
        this.infoEvents.add(ConstantsHelper.frameworkEvent((int)4));
        this.infoEvents.add(ConstantsHelper.frameworkEvent((int)2));
        this.infoEvents.add(ConstantsHelper.frameworkEvent((int)16));
        this.infoEvents.add(ConstantsHelper.frameworkEvent((int)32));
        this.infoEvents.add(ConstantsHelper.bundleEvent((int)1));
        this.infoEvents.add(ConstantsHelper.bundleEvent((int)2));
        this.infoEvents.add(ConstantsHelper.bundleEvent((int)4));
        this.infoEvents.add(ConstantsHelper.bundleEvent((int)16));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBundleListener(XBundle bundle2, BundleListener listener) {
        assert (listener != null) : "Null listener";
        Map<XBundle, List<BundleListenerRegistration>> map = this.bundleListeners;
        synchronized (map) {
            BundleListenerRegistration registration;
            List<BundleListenerRegistration> registrations = this.bundleListeners.get(bundle2);
            if (registrations == null) {
                registrations = new ArrayList<BundleListenerRegistration>();
                this.bundleListeners.put(bundle2, registrations);
            }
            if (!registrations.contains(registration = new BundleListenerRegistration(bundle2, listener))) {
                registrations.add(registration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBundleListener(XBundle bundle2, BundleListener listener) {
        assert (listener != null) : "Null listener";
        Map<XBundle, List<BundleListenerRegistration>> map = this.bundleListeners;
        synchronized (map) {
            List<BundleListenerRegistration> registrations = this.bundleListeners.get(bundle2);
            if (registrations != null) {
                if (registrations.size() > 1) {
                    Iterator<BundleListenerRegistration> iterator = registrations.iterator();
                    while (iterator.hasNext()) {
                        BundleListenerRegistration registration = iterator.next();
                        if (registration.getListener() != listener) continue;
                        iterator.remove();
                        break;
                    }
                } else {
                    this.removeBundleListeners(bundle2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBundleListeners(XBundle bundleState) {
        Map<XBundle, List<BundleListenerRegistration>> map = this.bundleListeners;
        synchronized (map) {
            this.bundleListeners.remove(bundleState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllBundleListeners() {
        Map<XBundle, List<BundleListenerRegistration>> map = this.bundleListeners;
        synchronized (map) {
            this.bundleListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFrameworkListener(XBundle bundleState, FrameworkListener listener) {
        assert (listener != null) : "Null listener";
        Map<XBundle, List<FrameworkListener>> map = this.frameworkListeners;
        synchronized (map) {
            List<FrameworkListener> listeners = this.frameworkListeners.get(bundleState);
            if (listeners == null) {
                listeners = new ArrayList<FrameworkListener>();
                this.frameworkListeners.put(bundleState, listeners);
            }
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFrameworkListener(XBundle bundleState, FrameworkListener listener) {
        assert (listener != null) : "Null listener";
        Map<XBundle, List<FrameworkListener>> map = this.frameworkListeners;
        synchronized (map) {
            List<FrameworkListener> listeners = this.frameworkListeners.get(bundleState);
            if (listeners != null) {
                if (listeners.size() > 1) {
                    listeners.remove(listener);
                } else {
                    this.removeFrameworkListeners(bundleState);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFrameworkListeners(XBundle bundleState) {
        Map<XBundle, List<FrameworkListener>> map = this.frameworkListeners;
        synchronized (map) {
            this.frameworkListeners.remove(bundleState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllFrameworkListeners() {
        Map<XBundle, List<FrameworkListener>> map = this.frameworkListeners;
        synchronized (map) {
            this.frameworkListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServiceListener(XBundle bundleState, ServiceListener listener, String filterstr) throws InvalidSyntaxException {
        assert (listener != null) : "Null listener";
        Map<XBundle, List<ServiceListenerRegistration>> map = this.serviceListeners;
        synchronized (map) {
            List<ServiceListenerRegistration> listeners = this.serviceListeners.get(bundleState);
            if (listeners == null) {
                listeners = new ArrayList<ServiceListenerRegistration>();
                this.serviceListeners.put(bundleState, listeners);
            }
            this.removeServiceListener(bundleState, listener);
            Filter filter = filterstr != null ? FrameworkUtil.createFilter((String)filterstr) : NoFilter.INSTANCE;
            ServiceListenerRegistration slreg = new ServiceListenerRegistration(bundleState, listener, filter);
            for (ListenerHook hook : this.getServiceListenerHooks()) {
                try {
                    hook.added(Collections.singleton(slreg.getListenerInfo()));
                }
                catch (RuntimeException ex) {
                    FrameworkLogger.LOGGER.errorProcessingServiceListenerHook(ex, hook);
                }
            }
            listeners.add(slreg);
        }
    }

    @Override
    public Collection<ListenerHook.ListenerInfo> getServiceListenerInfos(XBundle bundleState) {
        ArrayList<ListenerHook.ListenerInfo> listeners = new ArrayList<ListenerHook.ListenerInfo>();
        for (Map.Entry<XBundle, List<ServiceListenerRegistration>> entry : this.serviceListeners.entrySet()) {
            if (bundleState != null && !bundleState.equals(entry.getKey())) continue;
            for (ServiceListenerRegistration aux : entry.getValue()) {
                ListenerHook.ListenerInfo info = aux.getListenerInfo();
                listeners.add(info);
            }
        }
        return Collections.unmodifiableCollection(listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServiceListener(XBundle bundleState, ServiceListener listener) {
        assert (listener != null) : "Null listener";
        Map<XBundle, List<ServiceListenerRegistration>> map = this.serviceListeners;
        synchronized (map) {
            ServiceListenerRegistration slreg;
            int index;
            List<ServiceListenerRegistration> listeners = this.serviceListeners.get(bundleState);
            if (listeners != null && (index = listeners.indexOf(slreg = new ServiceListenerRegistration(bundleState, listener, NoFilter.INSTANCE))) >= 0) {
                slreg = listeners.remove(index);
                for (ListenerHook hook : this.getServiceListenerHooks()) {
                    try {
                        ListenerHook.ListenerInfo info = slreg.getListenerInfo();
                        ((ListenerInfoImpl)info).setRemoved(true);
                        hook.removed(Collections.singleton(info));
                    }
                    catch (RuntimeException ex) {
                        FrameworkLogger.LOGGER.errorProcessingServiceListenerHook(ex, hook);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServiceListeners(XBundle bundleState) {
        Map<XBundle, List<ServiceListenerRegistration>> map = this.serviceListeners;
        synchronized (map) {
            Collection<ListenerHook.ListenerInfo> listenerInfos = this.getServiceListenerInfos(bundleState);
            this.serviceListeners.remove(bundleState);
            for (ListenerHook hook : this.getServiceListenerHooks()) {
                try {
                    hook.removed(listenerInfos);
                }
                catch (RuntimeException ex) {
                    FrameworkLogger.LOGGER.errorProcessingServiceListenerHook(ex, hook);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllServiceListeners() {
        Map<XBundle, List<ServiceListenerRegistration>> map = this.serviceListeners;
        synchronized (map) {
            this.serviceListeners.clear();
        }
    }

    private List<ListenerHook> getServiceListenerHooks() {
        if (!this.bundleManager.isFrameworkCreated()) {
            return Collections.emptyList();
        }
        ServiceReference[] srefs = null;
        SystemBundleState sysbundle = this.bundleManager.getSystemBundle();
        BundleContext syscontext = sysbundle.getBundleContext();
        try {
            srefs = syscontext.getServiceReferences(ListenerHook.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            // empty catch block
        }
        if (srefs == null) {
            return Collections.emptyList();
        }
        ArrayList<ListenerHook> hooks = new ArrayList<ListenerHook>();
        for (ServiceReference sref : srefs) {
            hooks.add((ListenerHook)syscontext.getService(sref));
        }
        return Collections.unmodifiableList(hooks);
    }

    @Override
    public void fireBundleEvent(XBundle bundle2, int type) {
        this.fireBundleEvent(null, bundle2, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireBundleEvent(BundleContext context, final XBundle bundle2, final int type) {
        if (bundle2 == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("bundle");
        }
        if (!this.bundleManager.isFrameworkCreated()) {
            return;
        }
        final ArrayList<BundleListenerRegistration> registrations = new ArrayList<BundleListenerRegistration>();
        Map<XBundle, List<BundleListenerRegistration>> map = this.bundleListeners;
        synchronized (map) {
            for (Map.Entry<XBundle, List<BundleListenerRegistration>> entry : this.bundleListeners.entrySet()) {
                for (BundleListenerRegistration blreg : entry.getValue()) {
                    registrations.add(blreg);
                }
            }
        }
        final BundleEventImpl event = new BundleEventImpl(type, (Bundle)bundle2, (Bundle)(context != null ? context.getBundle() : bundle2));
        final String typeName = ConstantsHelper.bundleEvent((int)event.getType());
        RemoveOnlyCollection contexts = new ArrayList();
        for (XBundle aux : this.bundleListeners.keySet()) {
            contexts.add(aux.getBundleContext());
        }
        SystemBundleState sysbundle = this.bundleManager.getSystemBundle();
        BundleContext syscontext = sysbundle.getBundleContext();
        contexts = new RemoveOnlyCollection(contexts);
        this.callBundleEventHooks(syscontext, (Collection<BundleContext>)contexts, event);
        Iterator iterator = registrations.iterator();
        while (iterator.hasNext()) {
            BundleListenerRegistration blreg = (BundleListenerRegistration)iterator.next();
            if (contexts.contains(blreg.getBundleContext())) continue;
            iterator.remove();
        }
        if (registrations.isEmpty()) {
            return;
        }
        LockManager.LockContext currentLock = this.lockManager.getCurrentLockContext();
        iterator = registrations.iterator();
        while (iterator.hasNext()) {
            BundleListenerRegistration blreg = (BundleListenerRegistration)iterator.next();
            BundleListener listener = blreg.listener;
            try {
                if (!(listener instanceof SynchronousBundleListener)) continue;
                if (currentLock != null) {
                    FrameworkLogger.LOGGER.debugf("Calling out to client code with current lock: %s", currentLock);
                }
                iterator.remove();
                listener.bundleChanged((BundleEvent)event);
            }
            catch (Throwable th) {
                FrameworkLogger.LOGGER.warnErrorWhileFiringBundleEvent(th, typeName, (Bundle)bundle2);
            }
        }
        if (!registrations.isEmpty()) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    if (FrameworkEventsImpl.this.asyncBundleEvents.contains(type)) {
                        for (BundleListenerRegistration blreg : registrations) {
                            BundleListener listener = blreg.listener;
                            try {
                                if (listener instanceof SynchronousBundleListener) continue;
                                listener.bundleChanged(event);
                            }
                            catch (Throwable th) {
                                FrameworkLogger.LOGGER.warnErrorWhileFiringBundleEvent(th, typeName, (Bundle)bundle2);
                            }
                        }
                    }
                }
            };
            if (!this.executorService.isShutdown()) {
                this.executorService.execute(runner);
            }
        }
    }

    private void callBundleEventHooks(BundleContext syscontext, Collection<BundleContext> contexts, BundleEvent event) {
        for (EventHook hook : this.getBundleEventHooks(syscontext)) {
            try {
                hook.event(event, contexts);
            }
            catch (Exception ex) {
                FrameworkLogger.LOGGER.warnErrorWhileCallingBundleEventHook(ex, hook);
            }
        }
    }

    private List<EventHook> getBundleEventHooks(BundleContext syscontext) {
        ArrayList<EventHook> hooks = new ArrayList<EventHook>();
        Collection srefs = null;
        try {
            srefs = syscontext.getServiceReferences(EventHook.class, null);
        }
        catch (InvalidSyntaxException e) {
            // empty catch block
        }
        ArrayList sorted = new ArrayList(srefs);
        Collections.reverse(sorted);
        for (ServiceReference sref : sorted) {
            hooks.add((EventHook)syscontext.getService(sref));
        }
        return hooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireFrameworkEvent(final XBundle bundle2, final int type, Throwable th, FrameworkListener ... providedListeners) {
        if (!this.bundleManager.isFrameworkCreated()) {
            return;
        }
        final ArrayList<FrameworkListener> listeners = new ArrayList<FrameworkListener>();
        Map<XBundle, List<FrameworkListener>> map = this.frameworkListeners;
        synchronized (map) {
            if (providedListeners != null) {
                for (FrameworkListener listener : providedListeners) {
                    if (listener == null) continue;
                    listeners.add(listener);
                }
            }
            for (Map.Entry<XBundle, List<FrameworkListener>> entry : this.frameworkListeners.entrySet()) {
                for (FrameworkListener listener : entry.getValue()) {
                    listeners.add(listener);
                }
            }
        }
        final FrameworkEventImpl event = new FrameworkEventImpl(type, (Bundle)bundle2, th);
        final String typeName = ConstantsHelper.frameworkEvent((int)event.getType());
        switch (event.getType()) {
            case 2: {
                FrameworkLogger.LOGGER.errorFrameworkEvent(th);
                break;
            }
            case 16: {
                FrameworkLogger.LOGGER.warnFrameworkEvent(th);
                break;
            }
            default: {
                FrameworkLogger.LOGGER.debugf(th, "Framework event: %s", typeName);
            }
        }
        if (listeners.isEmpty()) {
            return;
        }
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                for (FrameworkListener listener : listeners) {
                    try {
                        listener.frameworkEvent(event);
                    }
                    catch (RuntimeException ex) {
                        FrameworkLogger.LOGGER.warnErrorWhileFiringEvent(ex, typeName);
                        if (type == 2) continue;
                        FrameworkEventsImpl.this.fireFrameworkEvent(bundle2, 2, ex, new FrameworkListener[0]);
                    }
                    catch (Throwable th) {
                        FrameworkLogger.LOGGER.warnErrorWhileFiringEvent(th, typeName);
                    }
                }
            }
        };
        if (!this.executorService.isShutdown()) {
            this.executorService.execute(runner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireServiceEvent(XBundle bundle2, int type, ServiceState<?> serviceState) {
        RemoveOnlyMap listeners;
        if (!this.bundleManager.isFrameworkCreated()) {
            return;
        }
        Map<XBundle, List<ServiceListenerRegistration>> map = this.serviceListeners;
        synchronized (map) {
            listeners = new HashMap();
            for (Map.Entry<XBundle, List<ServiceListenerRegistration>> entry : this.serviceListeners.entrySet()) {
                for (ServiceListenerRegistration listener : entry.getValue()) {
                    BundleContext context = listener.getBundleContext();
                    if (context == null) continue;
                    ArrayList<ListenerHook.ListenerInfo> infos = (ArrayList<ListenerHook.ListenerInfo>)listeners.get(context);
                    if (infos == null) {
                        infos = new ArrayList<ListenerHook.ListenerInfo>();
                        listeners.put(context, infos);
                    }
                    infos.add(listener.getListenerInfo());
                }
            }
            for (Map.Entry<Object, List<ServiceListenerRegistration>> entry : listeners.entrySet()) {
                listeners.put(entry.getKey(), new RemoveOnlyCollection((Collection)entry.getValue()));
            }
            listeners = new RemoveOnlyMap(listeners);
        }
        ServiceEventImpl event = new ServiceEventImpl(type, serviceState);
        String typeName = ConstantsHelper.serviceEvent((int)event.getType());
        FrameworkLogger.LOGGER.tracef("Service %s: %s", typeName, serviceState);
        SystemBundleState systemBundleState = this.bundleManager.getSystemBundle();
        BundleContext syscontext = systemBundleState.getBundleContext();
        this.callServiceEventHooks(syscontext, (Map<BundleContext, Collection<ListenerHook.ListenerInfo>>)listeners, event);
        this.callServieEventListenerHooks(syscontext, (Map<BundleContext, Collection<ListenerHook.ListenerInfo>>)listeners, event);
        if (listeners.isEmpty()) {
            return;
        }
        for (Map.Entry entry : listeners.entrySet()) {
            for (ListenerHook.ListenerInfo info : (Collection)entry.getValue()) {
                ServiceListenerRegistration listenerReg = ((ListenerInfoImpl)info).getRegistration();
                AbstractBundleContext context = (AbstractBundleContext)info.getBundleContext();
                if (context.isDestroyed()) continue;
                if (!listenerReg.isAllServiceListener()) {
                    String[] clazzes;
                    boolean assignableToOwner = true;
                    Object owner = context.getBundleState();
                    for (String clazz : clazzes = (String[])serviceState.getProperty("objectClass")) {
                        if (serviceState.isAssignableTo((Bundle)owner, clazz)) continue;
                        assignableToOwner = false;
                        break;
                    }
                    if (!assignableToOwner) continue;
                }
                try {
                    String filterstr = info.getFilter();
                    ServiceListener listener = listenerReg.getListener();
                    if (listenerReg.isAllServiceListener() || listener instanceof UnfilteredServiceListener || listenerReg.filter.match(serviceState)) {
                        listener.serviceChanged((ServiceEvent)event);
                        continue;
                    }
                    if (filterstr == null || 2 != event.getType() || !listenerReg.filter.match(serviceState.getPreviousProperties())) continue;
                    event = new ServiceEventImpl(8, serviceState);
                    listener.serviceChanged((ServiceEvent)event);
                }
                catch (Throwable th) {
                    FrameworkLogger.LOGGER.warnErrorWhileFiringServiceEvent(th, typeName, serviceState);
                }
            }
        }
    }

    private void callServieEventListenerHooks(BundleContext syscontext, Map<BundleContext, Collection<ListenerHook.ListenerInfo>> listeners, ServiceEvent event) {
        for (EventListenerHook hook : this.getServiceEventListenerHooks(syscontext)) {
            try {
                hook.event(event, listeners);
            }
            catch (Exception ex) {
                FrameworkLogger.LOGGER.warnErrorWhileCallingEventListenerHook(ex, hook);
            }
        }
    }

    private List<EventListenerHook> getServiceEventListenerHooks(BundleContext syscontext) {
        ArrayList<EventListenerHook> hooks = new ArrayList<EventListenerHook>();
        Collection srefs = null;
        try {
            srefs = syscontext.getServiceReferences(EventListenerHook.class, null);
        }
        catch (InvalidSyntaxException e) {
            // empty catch block
        }
        ArrayList sortedRefs = new ArrayList(srefs);
        Collections.reverse(sortedRefs);
        for (ServiceReference sref : sortedRefs) {
            hooks.add((EventListenerHook)syscontext.getService(sref));
        }
        return hooks;
    }

    private void callServiceEventHooks(BundleContext syscontext, Map<BundleContext, Collection<ListenerHook.ListenerInfo>> listeners, ServiceEvent event) {
        RemoveOnlyCollection contexts = new RemoveOnlyCollection(listeners.keySet());
        List<org.osgi.framework.hooks.service.EventHook> eventHooks = this.getServiceEventHooks(syscontext);
        for (org.osgi.framework.hooks.service.EventHook hook : eventHooks) {
            try {
                hook.event(event, (Collection)contexts);
            }
            catch (Exception ex) {
                FrameworkLogger.LOGGER.warnErrorWhileCallingEventHook(ex, hook);
            }
        }
        if (contexts.size() != listeners.size()) {
            Iterator<BundleContext> it = listeners.keySet().iterator();
            while (it.hasNext()) {
                BundleContext context = it.next();
                if (contexts.contains(context)) continue;
                it.remove();
            }
        }
    }

    private List<org.osgi.framework.hooks.service.EventHook> getServiceEventHooks(BundleContext syscontext) {
        ArrayList<org.osgi.framework.hooks.service.EventHook> hooks = new ArrayList<org.osgi.framework.hooks.service.EventHook>();
        Collection srefs = null;
        try {
            srefs = syscontext.getServiceReferences(org.osgi.framework.hooks.service.EventHook.class, null);
        }
        catch (InvalidSyntaxException e) {
            // empty catch block
        }
        if (srefs != null && !srefs.isEmpty()) {
            ArrayList sorted = new ArrayList(srefs);
            Collections.reverse(sorted);
            for (ServiceReference sref : sorted) {
                hooks.add((org.osgi.framework.hooks.service.EventHook)syscontext.getService(sref));
            }
        }
        return hooks;
    }

    static class ServiceEventImpl
    extends ServiceEvent {
        private static final long serialVersionUID = 62018288275708239L;

        public ServiceEventImpl(int type, ServiceState<?> serviceState) {
            super(type, serviceState.getReference());
        }

        public String toString() {
            return "ServiceEvent[type=" + ConstantsHelper.serviceEvent((int)this.getType()) + ",source=" + this.getSource() + "]";
        }
    }

    static class BundleEventImpl
    extends BundleEvent {
        private static final long serialVersionUID = -2705304702665185935L;

        BundleEventImpl(int type, Bundle bundle2, Bundle origin) {
            super(type, bundle2, origin);
        }

        public String toString() {
            return "BundleEvent[type=" + ConstantsHelper.bundleEvent((int)this.getType()) + ",source=" + this.getSource() + "]";
        }
    }

    static class FrameworkEventImpl
    extends FrameworkEvent {
        private static final long serialVersionUID = 6505331543651318189L;

        public FrameworkEventImpl(int type, Bundle bundle2, Throwable throwable) {
            super(type, bundle2, throwable);
        }

        public String toString() {
            return "FrameworkEvent[type=" + ConstantsHelper.frameworkEvent((int)this.getType()) + ",source=" + this.getSource() + "]";
        }
    }

    static class ListenerInfoImpl
    implements ListenerHook.ListenerInfo {
        private final ServiceListenerRegistration registration;
        private final AbstractBundleContext<?> bundleContext;
        private boolean removed;

        ListenerInfoImpl(BundleContext bundleContext, ServiceListenerRegistration registration) {
            this.bundleContext = (AbstractBundleContext)bundleContext;
            this.registration = registration;
        }

        public BundleContext getBundleContext() {
            return this.bundleContext;
        }

        public String getFilter() {
            Filter filter = this.registration.filter;
            return filter != NoFilter.INSTANCE ? filter.toString() : null;
        }

        public boolean isRemoved() {
            return this.removed;
        }

        ServiceListenerRegistration getRegistration() {
            return this.registration;
        }

        void setRemoved(boolean removed) {
            this.removed = removed;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public String toString() {
            String className = this.registration.listener.getClass().getName();
            return "ListenerInfo[" + this.bundleContext.getBundleState() + "," + className + "," + this.removed + "]";
        }
    }

    static class BundleListenerRegistration {
        private final BundleListener listener;
        private final BundleContext bundleContext;
        private final XBundle bundle;

        BundleListenerRegistration(XBundle bundle2, BundleListener listener) {
            this.listener = listener;
            this.bundle = bundle2;
            this.bundleContext = bundle2.getBundleContext();
        }

        BundleListener getListener() {
            return this.listener;
        }

        XBundle getBundle() {
            return this.bundle;
        }

        BundleContext getBundleContext() {
            return this.bundleContext;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BundleListenerRegistration)) {
                return false;
            }
            BundleListenerRegistration other = (BundleListenerRegistration)obj;
            return other.listener.equals(this.listener);
        }

        public String toString() {
            String className = this.listener.getClass().getName();
            return "BundleListener[" + this.bundle + "," + className + "]";
        }
    }

    static class ServiceListenerRegistration {
        private final XBundle bundle;
        private final BundleContext bundleContext;
        private final ServiceListener listener;
        private final Filter filter;
        private final ListenerHook.ListenerInfo info;
        AccessControlContext accessControlContext;

        ServiceListenerRegistration(XBundle bundle2, ServiceListener listener, Filter filter) {
            assert (bundle2 != null) : "Null bundle";
            assert (listener != null) : "Null listener";
            assert (filter != null) : "Null filter";
            this.bundle = bundle2;
            this.listener = listener;
            this.filter = filter;
            this.bundleContext = bundle2.getBundleContext();
            this.info = new ListenerInfoImpl(this.bundleContext, this);
            if (System.getSecurityManager() != null) {
                this.accessControlContext = AccessController.getContext();
            }
        }

        XBundle getBundle() {
            return this.bundle;
        }

        BundleContext getBundleContext() {
            return this.bundleContext;
        }

        ServiceListener getListener() {
            return this.listener;
        }

        ListenerHook.ListenerInfo getListenerInfo() {
            return this.info;
        }

        boolean isAllServiceListener() {
            return this.listener instanceof AllServiceListener;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ServiceListenerRegistration)) {
                return false;
            }
            ServiceListenerRegistration other = (ServiceListenerRegistration)obj;
            return other.listener.equals(this.listener);
        }

        public String toString() {
            String className = this.listener.getClass().getName();
            return "ServiceListener[" + this.bundle + "," + className + "," + this.filter + "]";
        }
    }
}

