/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FragmentBundleRevision;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.InternalConstants;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.FrameworkModuleLoader;
import org.jboss.osgi.framework.spi.FrameworkWiringLock;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.framework.spi.ModuleManager;
import org.jboss.osgi.framework.spi.NativeCode;
import org.jboss.osgi.metadata.NativeLibraryMetaData;
import org.jboss.osgi.resolver.ResolverMessages;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XResolveContext;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceCapability;
import org.jboss.osgi.resolver.XWiring;
import org.jboss.osgi.resolver.spi.AbstractBundleWire;
import org.jboss.osgi.resolver.spi.ResolverHookProcessor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;

final class FrameworkResolverImpl
implements XResolver {
    private final BundleManagerPlugin bundleManager;
    private final NativeCode nativeCode;
    private final ModuleManager moduleManager;
    private final FrameworkModuleLoader moduleLoader;
    private final LockManager lockManager;
    private final XResolver resolver;

    FrameworkResolverImpl(BundleManager bundleManager, NativeCode nativeCode, ModuleManager moduleManager, FrameworkModuleLoader moduleLoader, XResolver resolver, LockManager lockManager) {
        this.bundleManager = (BundleManagerPlugin)bundleManager;
        this.nativeCode = nativeCode;
        this.moduleManager = moduleManager;
        this.moduleLoader = moduleLoader;
        this.lockManager = lockManager;
        this.resolver = resolver;
    }

    public XResolveContext createResolveContext(XEnvironment environment, Collection<? extends Resource> mandatory, Collection<? extends Resource> optional) {
        return this.resolver.createResolveContext(environment, mandatory, optional);
    }

    public synchronized Map<Resource, List<Wire>> resolve(ResolveContext resolveContext) throws ResolutionException {
        return this.resolveInternal((XResolveContext)resolveContext, false);
    }

    public synchronized Map<Resource, List<Wire>> resolveAndApply(XResolveContext resolveContext) throws ResolutionException {
        return this.resolveInternal(resolveContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Resource, List<Wire>> resolveInternal(XResolveContext resolveContext, boolean applyResults) throws ResolutionException {
        if (ResolverHookProcessor.getCurrentProcessor() != null) {
            throw ResolverMessages.MESSAGES.illegalStateResolverHookCannotTriggerResolveOperation();
        }
        XEnvironment env = resolveContext.getEnvironment();
        BundleContext syscontext = this.bundleManager.getSystemContext();
        HashSet manres = new HashSet(resolveContext.getMandatoryResources());
        HashSet<Resource> optres = new HashSet<Resource>(resolveContext.getOptionalResources());
        ResolverHookProcessor hookregs = new ResolverHookProcessor(syscontext, this.bundleManager.getBundles(2));
        try {
            Map wiremap;
            if (hookregs.hasResolverHooks()) {
                hookregs.begin(manres, optres);
                hookregs.filterResolvable();
                hookregs.filterSingletonCollisions(new ResolverHookProcessor.SingletonLocator(){

                    public Collection<BundleCapability> findCollisionCandidates(BundleCapability viewpoint) {
                        HashSet<BundleCapability> result = new HashSet<BundleCapability>();
                        if (viewpoint instanceof XResourceCapability) {
                            String symbolicName = ((XResourceCapability)viewpoint).getName();
                            for (XBundle bundle2 : FrameworkResolverImpl.this.bundleManager.getBundles(symbolicName, null)) {
                                XBundleRevision xres = bundle2.getBundleRevision();
                                List bcaps = xres.getDeclaredCapabilities(viewpoint.getNamespace());
                                if (bcaps.size() != 1) continue;
                                BundleCapability bcap = (BundleCapability)bcaps.get(0);
                                String spec = (String)bcap.getDirectives().get("singleton");
                                if (bcap == viewpoint || !Boolean.parseBoolean(spec)) continue;
                                result.add(bcap);
                            }
                        }
                        return result;
                    }
                });
                resolveContext = this.resolver.createResolveContext(env, this.getFilteredResources(hookregs, manres), this.getFilteredResources(hookregs, optres));
            } else {
                this.filterSingletons(manres, optres);
                resolveContext = this.resolver.createResolveContext(env, manres, optres);
            }
            LockManager.LockContext lockContext = null;
            try {
                FrameworkWiringLock wireLock = this.lockManager.getItemForType(FrameworkWiringLock.class);
                lockContext = this.lockManager.lockItems(LockManager.Method.RESOLVE, wireLock);
                wiremap = this.resolver.resolve((ResolveContext)resolveContext);
                if (applyResults) {
                    this.applyResolverResults(env, wiremap);
                }
                this.lockManager.unlockItems(lockContext);
            }
            catch (Throwable throwable) {
                this.lockManager.unlockItems(lockContext);
                throw throwable;
            }
            if (applyResults) {
                this.sendBundleResolvedEvents(wiremap);
            }
            Map map = wiremap;
            return map;
        }
        finally {
            hookregs.end();
        }
    }

    private Collection<? extends Resource> getFilteredResources(ResolverHookProcessor hookregs, Collection<? extends Resource> resources) {
        ArrayList<? extends Resource> filtered = null;
        if (resources != null) {
            filtered = new ArrayList<Resource>(resources);
            Iterator iterator = filtered.iterator();
            while (iterator.hasNext()) {
                Resource res = (Resource)iterator.next();
                if (hookregs.hasResource(res)) continue;
                iterator.remove();
            }
        }
        return filtered;
    }

    private HashSet<Resource> getCombinedResources(Collection<? extends Resource> manres, Collection<Resource> optres) {
        HashSet<Resource> combined = new HashSet<Resource>(manres);
        combined.addAll(optres);
        return combined;
    }

    private void filterSingletons(Collection<? extends Resource> manres, Collection<Resource> optres) {
        HashMap<String, XResource> singletons = new HashMap<String, XResource>();
        for (Resource res : this.getCombinedResources(manres, optres)) {
            XResource xres = (XResource)res;
            XIdentityCapability icap = xres.getIdentityCapability();
            if (!icap.isSingleton()) continue;
            if (singletons.get(icap.getName()) != null) {
                manres.remove(res);
                optres.remove(res);
                continue;
            }
            singletons.put(icap.getName(), xres);
        }
    }

    private Map<Resource, Wiring> applyResolverResults(XEnvironment environment, Map<Resource, List<Wire>> wiremap) throws ResolutionException {
        LinkedHashMap<BundleRevision, List<BundleWire>> brevmap = new LinkedHashMap<BundleRevision, List<BundleWire>>();
        for (Map.Entry<Resource, List<Wire>> entry : wiremap.entrySet()) {
            ArrayList<AbstractBundleWire> bwires = new ArrayList<AbstractBundleWire>();
            ArrayList<AbstractBundleWire> wires = new ArrayList<AbstractBundleWire>();
            for (Wire wire : entry.getValue()) {
                AbstractBundleWire bwire = new AbstractBundleWire(wire);
                bwires.add(bwire);
                wires.add(bwire);
            }
            Resource res = entry.getKey();
            brevmap.put((BundleRevision)res, bwires);
            wiremap.put(res, wires);
        }
        this.attachFragmentsToHost(brevmap);
        try {
            this.resolveNativeCodeLibraries(brevmap);
        }
        catch (BundleException ex) {
            throw new ResolutionException((Throwable)ex);
        }
        this.addModules(brevmap);
        this.createModuleServices(brevmap);
        Map wirings = environment.updateWiring(wiremap);
        for (Map.Entry entry : wirings.entrySet()) {
            XBundleRevision res = (XBundleRevision)entry.getKey();
            res.getWiringSupport().setWiring((XWiring)entry.getValue());
        }
        this.setBundleStatesToResolved(brevmap);
        return wirings;
    }

    private void attachFragmentsToHost(Map<BundleRevision, List<BundleWire>> wiremap) {
        for (Map.Entry<BundleRevision, List<BundleWire>> entry : wiremap.entrySet()) {
            XBundleRevision brev = (XBundleRevision)entry.getKey();
            if (!brev.isFragment()) continue;
            FragmentBundleRevision fragRev = (FragmentBundleRevision)brev;
            for (BundleWire wire : entry.getValue()) {
                BundleCapability cap = wire.getCapability();
                if (!"osgi.wiring.host".equals(cap.getNamespace())) continue;
                HostBundleRevision hostRev = (HostBundleRevision)cap.getResource();
                fragRev.attachToHost(hostRev);
            }
        }
    }

    private void resolveNativeCodeLibraries(Map<BundleRevision, List<BundleWire>> wiremap) throws BundleException {
        for (Map.Entry<BundleRevision, List<BundleWire>> entry : wiremap.entrySet()) {
            UserBundleRevision userRev;
            Deployment deployment;
            NativeLibraryMetaData libMetaData;
            XBundleRevision brev = (XBundleRevision)entry.getKey();
            if (!(brev instanceof UserBundleRevision) || (libMetaData = (NativeLibraryMetaData)(deployment = (userRev = (UserBundleRevision)brev).getDeployment()).getAttachment(InternalConstants.NATIVE_LIBRARY_METADATA_KEY)) == null) continue;
            this.nativeCode.resolveNativeCode((XBundleRevision)userRev);
        }
    }

    private void addModules(Map<BundleRevision, List<BundleWire>> wiremap) {
        for (Map.Entry<BundleRevision, List<BundleWire>> entry : wiremap.entrySet()) {
            XBundleRevision brev = (XBundleRevision)entry.getKey();
            if (brev.isFragment()) continue;
            List<BundleWire> wires = wiremap.get(brev);
            this.moduleManager.addModule(brev, wires);
        }
    }

    private void createModuleServices(Map<BundleRevision, List<BundleWire>> wiremap) {
        for (Map.Entry<BundleRevision, List<BundleWire>> entry : wiremap.entrySet()) {
            XBundleRevision brev = (XBundleRevision)entry.getKey();
            List<BundleWire> wires = entry.getValue();
            XBundle bundle2 = brev.getBundle();
            if (bundle2 == null || bundle2.getBundleId() == 0L || brev.isFragment()) continue;
            this.moduleLoader.createModuleService(brev, wires);
        }
    }

    private void setBundleStatesToResolved(Map<BundleRevision, List<BundleWire>> wiremap) {
        for (Map.Entry<BundleRevision, List<BundleWire>> entry : wiremap.entrySet()) {
            Bundle bundle2 = entry.getKey().getBundle();
            if (!(bundle2 instanceof AbstractBundleState)) continue;
            AbstractBundleState bundleState = (AbstractBundleState)bundle2;
            bundleState.changeState(4, 0);
        }
    }

    private void sendBundleResolvedEvents(Map<Resource, List<Wire>> wiremap) {
        for (Map.Entry<Resource, List<Wire>> entry : wiremap.entrySet()) {
            XBundleRevision brev;
            XBundle bundle2;
            Resource res = entry.getKey();
            if (!(res instanceof XBundleRevision) || !((bundle2 = (brev = (XBundleRevision)res).getBundle()) instanceof AbstractBundleState)) continue;
            AbstractBundleState bundleState = (AbstractBundleState)bundle2;
            if (!this.bundleManager.isFrameworkCreated()) continue;
            bundleState.fireBundleEvent(32);
        }
    }
}

