/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.FrameworkResolverImpl;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.FrameworkModuleLoader;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.framework.spi.ModuleManager;
import org.jboss.osgi.framework.spi.NativeCode;
import org.jboss.osgi.resolver.XResolver;

final class FrameworkResolverPlugin
extends AbstractIntegrationService<XResolver> {
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<NativeCode> injectedNativeCode = new InjectedValue();
    private final InjectedValue<ModuleManager> injectedModuleManager = new InjectedValue();
    private final InjectedValue<FrameworkModuleLoader> injectedModuleLoader = new InjectedValue();
    private final InjectedValue<LockManager> injectedLockManager = new InjectedValue();
    private final InjectedValue<XResolver> injectedResolver = new InjectedValue();

    FrameworkResolverPlugin() {
        super(Services.RESOLVER);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<XResolver> builder) {
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, this.injectedBundleManager);
        builder.addDependency(IntegrationServices.ABSTRACT_RESOLVER, XResolver.class, this.injectedResolver);
        builder.addDependency(IntegrationServices.NATIVE_CODE_PLUGIN, NativeCode.class, this.injectedNativeCode);
        builder.addDependency(IntegrationServices.MODULE_MANGER_PLUGIN, ModuleManager.class, this.injectedModuleManager);
        builder.addDependency(IntegrationServices.FRAMEWORK_MODULE_LOADER_PLUGIN, FrameworkModuleLoader.class, this.injectedModuleLoader);
        builder.addDependency(IntegrationServices.LOCK_MANAGER_PLUGIN, LockManager.class, this.injectedLockManager);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    protected XResolver createServiceValue(StartContext startContext) throws StartException {
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        NativeCode nativeCode = (NativeCode)this.injectedNativeCode.getValue();
        ModuleManager moduleManager = (ModuleManager)this.injectedModuleManager.getValue();
        FrameworkModuleLoader moduleLoader = (FrameworkModuleLoader)this.injectedModuleLoader.getValue();
        XResolver resolver = (XResolver)this.injectedResolver.getValue();
        LockManager lockManager = (LockManager)this.injectedLockManager.getValue();
        return new FrameworkResolverImpl(bundleManager, nativeCode, moduleManager, moduleLoader, resolver, lockManager);
    }
}

