/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.InternalConstants;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.IntegrationConstants;
import org.jboss.osgi.framework.spi.NativeCode;
import org.jboss.osgi.framework.spi.NativeLibraryProvider;
import org.jboss.osgi.framework.spi.StorageManager;
import org.jboss.osgi.metadata.NativeLibrary;
import org.jboss.osgi.metadata.NativeLibraryMetaData;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.Parameter;
import org.jboss.osgi.metadata.ParameterizedAttribute;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.vfs.VFSUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.framework.wiring.BundleRevision;

public final class NativeCodeImpl
implements NativeCode {
    private static final String ABSPATH_VARIABLE = "${abspath}";
    private static Map<String, String> processorAlias = new HashMap<String, String>();
    private static Map<String, String> osAlias;
    private final BundleManagerPlugin bundleManager;

    public NativeCodeImpl(BundleManager bundleManager) {
        this.bundleManager = (BundleManagerPlugin)bundleManager;
    }

    @Override
    public void deployNativeCode(Deployment dep) {
        NativeLibraryMetaData nativeLibraries = new NativeLibraryMetaData();
        dep.putAttachment(InternalConstants.NATIVE_LIBRARY_METADATA_KEY, (Object)nativeLibraries);
    }

    @Override
    public void resolveNativeCode(XBundleRevision brev) throws BundleException {
        UserBundleRevision userRev = UserBundleRevision.assertBundleRevision((BundleRevision)brev);
        OSGiMetaData metaData = (OSGiMetaData)userRev.getAttachment(IntegrationConstants.OSGI_METADATA_KEY);
        List params = metaData.getBundleNativeCode();
        if (params == null) {
            throw FrameworkMessages.MESSAGES.cannotFindNativeCodeHeader((BundleRevision)userRev);
        }
        ArrayList<ParameterizedAttribute> matchedParams = new ArrayList<ParameterizedAttribute>();
        for (ParameterizedAttribute param : params) {
            if (!this.matchParameter(param)) continue;
            matchedParams.add(param);
        }
        Deployment dep = userRev.getDeployment();
        NativeLibraryMetaData nativeLibraries = (NativeLibraryMetaData)dep.getAttachment(InternalConstants.NATIVE_LIBRARY_METADATA_KEY);
        if (matchedParams.size() == 0) {
            if (params.size() > 0 && "*".equals(((ParameterizedAttribute)params.get(params.size() - 1)).getAttribute())) {
                dep.removeAttachment(InternalConstants.NATIVE_LIBRARY_METADATA_KEY);
                return;
            }
            throw FrameworkMessages.MESSAGES.noNativeCodeClauseSelected(params);
        }
        for (ParameterizedAttribute param : matchedParams) {
            String libpath = param.getAttribute();
            NativeLibrary library = new NativeLibrary(libpath);
            nativeLibraries.addNativeLibrary(library);
        }
    }

    private List<String> getCollection(Object value, boolean allowsplit) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Collection) {
            return new ArrayList<String>((Collection)value);
        }
        if (value instanceof String && allowsplit) {
            String valueString = (String)value;
            String[] split = valueString.split(",\\s");
            return Arrays.asList(split);
        }
        return Collections.singletonList(value.toString());
    }

    private boolean matchParameter(ParameterizedAttribute param) throws BundleException {
        Parameter procParam;
        boolean match;
        Parameter osnameParam = param.getAttribute("osname");
        BundleContext systemContext = this.bundleManager.getSystemBundle().getBundleContext();
        boolean bl = match = osnameParam != null;
        if (match && osnameParam != null) {
            String osname;
            String fwOSName = systemContext.getProperty("org.osgi.framework.os.name");
            boolean osmatch = false;
            List<String> osNames = this.getCollection(osnameParam.getValue(), true);
            Iterator i$ = osNames.iterator();
            while (i$.hasNext() && !(osmatch = (osname = (String)i$.next()).equalsIgnoreCase(fwOSName) || osname.equalsIgnoreCase(osAlias.get(fwOSName)))) {
            }
            match &= osmatch;
        }
        if ((match &= (procParam = param.getAttribute("processor")) != null) && procParam != null) {
            String proc;
            String fwProcessor = systemContext.getProperty("org.osgi.framework.processor");
            boolean procmatch = false;
            List<String> processors = this.getCollection(procParam.getValue(), true);
            Iterator<String> i$ = processors.iterator();
            while (i$.hasNext() && !(procmatch = (proc = i$.next()).equals(fwProcessor) || proc.equals(processorAlias.get(fwProcessor)))) {
            }
            match &= procmatch;
        }
        Parameter osversionParam = param.getAttribute("osversion");
        if (match && osversionParam != null) {
            VersionRange vr;
            String fwOSVersion = systemContext.getProperty("org.osgi.framework.os.version");
            boolean versionMatch = false;
            Version currentVersion = Version.parseVersion((String)fwOSVersion);
            String versionRange = (String)osversionParam.getValue();
            if (versionRange != null && (vr = new VersionRange(versionRange)).includes(currentVersion)) {
                versionMatch = true;
            }
            match &= versionMatch;
        }
        Parameter languageParam = param.getAttribute("language");
        if (match && languageParam != null) {
            String fwLanguage = systemContext.getProperty("org.osgi.framework.language");
            boolean languageMatch = false;
            for (String language : this.getCollection(languageParam.getValue(), true)) {
                if (!language.equals(fwLanguage)) continue;
                languageMatch = true;
                break;
            }
            match &= languageMatch;
        }
        Parameter filterSelectionParam = param.getAttribute("selection-filter");
        if (match && filterSelectionParam != null) {
            boolean filterMatch = false;
            Hashtable<String, Object> frameworkProps = new Hashtable<String, Object>(this.bundleManager.getProperties());
            String filterSpec = (String)filterSelectionParam.getValue();
            if (filterSpec != null) {
                try {
                    Filter filter = FrameworkUtil.createFilter((String)filterSpec);
                    if (filter.match(frameworkProps)) {
                        filterMatch = true;
                    }
                }
                catch (InvalidSyntaxException ex) {
                    throw FrameworkMessages.MESSAGES.invalidFilterExpression(ex, filterSpec);
                }
            }
            match &= filterMatch;
        }
        return match;
    }

    static {
        processorAlias.put("amd64", "x86-64");
        processorAlias.put("em64t", "x86-64");
        processorAlias.put("i386", "x86");
        processorAlias.put("i486", "x86");
        processorAlias.put("i586", "x86");
        processorAlias.put("i686", "x86");
        processorAlias.put("pentium", "x86");
        processorAlias.put("x86_64", "x86-64");
        osAlias = new HashMap<String, String>();
        osAlias.put("hp-ux", "HPUX");
        osAlias.put("Mac OS", "MacOS");
        osAlias.put("Mac OS X", "MacOSX");
        osAlias.put("OS/2", "OS2");
        osAlias.put("procnto", "QNX");
        osAlias.put("SymbianOS", "Epoc32");
        osAlias.put("Win2000", "Windows2000");
        osAlias.put("Win2003", "Windows2003");
        osAlias.put("Win32", "Windows");
        osAlias.put("Win95", "Windows95");
        osAlias.put("Win98", "Windows98");
        osAlias.put("WinCE", "WindowsCE");
        osAlias.put("Windows 2000", "Windows2000");
        osAlias.put("Windows 2003", "Windows2003");
        osAlias.put("Windows 7", "Windows7");
        osAlias.put("Windows 95", "Windows95");
        osAlias.put("Windows 98", "Windows98");
        osAlias.put("Windows CE", "WindowsCE");
        osAlias.put("Windows NT", "WindowsNT");
        osAlias.put("Windows Server 2003", "Windows2003");
        osAlias.put("Windows Vista", "WindowsVista");
        osAlias.put("Windows XP", "WindowsXP");
        osAlias.put("WinNT", "WindowsNT");
        osAlias.put("WinVista", "WindowsVista");
        osAlias.put("WinXP", "WindowsXP");
    }

    static class NativeLibraryProviderImpl
    implements NativeLibraryProvider {
        private final UserBundleState hostBundle;
        private final String libname;
        private final String libpath;
        private final URL libURL;
        private File libraryFile;

        NativeLibraryProviderImpl(HostBundleRevision hostrev, String libname, String libpath) {
            String filename;
            String path;
            this.hostBundle = hostrev.getBundleState();
            this.libpath = libpath;
            this.libname = libname;
            int idx = libpath.lastIndexOf(47);
            if (idx >= 0) {
                path = libpath.substring(0, idx);
                filename = libpath.substring(idx + 1);
            } else {
                path = "";
                filename = libpath;
            }
            Enumeration<URL> urls = hostrev.findResolvedEntries(path, filename, false);
            if (urls == null || !urls.hasMoreElements()) {
                throw FrameworkMessages.MESSAGES.illegalStateCannotFindNativeLibrary(libpath);
            }
            this.libURL = urls.nextElement();
        }

        @Override
        public String getLibraryName() {
            return this.libname;
        }

        @Override
        public String getLibraryPath() {
            return this.libpath;
        }

        @Override
        public File getLibraryLocation() throws IOException {
            if (this.libraryFile == null) {
                this.libraryFile = this.getUniqueLibraryFile(this.hostBundle, this.libpath);
                this.libraryFile.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(this.libraryFile);
                VFSUtils.copyStream((InputStream)this.libURL.openStream(), (OutputStream)fos);
                fos.close();
                this.handleExecPermission();
            }
            return this.libraryFile;
        }

        private void handleExecPermission() throws IOException {
            String epProp = this.hostBundle.getBundleContext().getProperty("org.osgi.framework.command.execpermission");
            if (epProp == null) {
                return;
            }
            StringBuilder command = new StringBuilder(epProp);
            int idx = command.indexOf(NativeCodeImpl.ABSPATH_VARIABLE);
            if (idx >= 0) {
                command.replace(idx, idx + NativeCodeImpl.ABSPATH_VARIABLE.length(), this.libraryFile.getAbsolutePath());
            }
            Process process = Runtime.getRuntime().exec(command.toString());
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }

        private File getUniqueLibraryFile(UserBundleState userBundle, String libpath) {
            StorageManager storagePlugin = userBundle.getFrameworkState().getStorageManager();
            return storagePlugin.getDataFile(userBundle.getBundleId(), libpath);
        }
    }
}

