/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.osgi.framework.internal.ServiceReferenceComparator;
import org.osgi.framework.ServiceReference;
import org.osgi.service.url.URLStreamHandlerService;

final class OSGiStreamHandlerFactoryDelegate
implements URLStreamHandlerFactory {
    private URLStreamHandlerFactory delegate;
    private Map<String, List<ServiceReference<URLStreamHandlerService>>> streamHandlers = new HashMap<String, List<ServiceReference<URLStreamHandlerService>>>();

    OSGiStreamHandlerFactoryDelegate() {
    }

    void setDelegateFactory(URLStreamHandlerFactory factory) {
        this.delegate = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addHandler(String protocol, ServiceReference<URLStreamHandlerService> reference) {
        Map<String, List<ServiceReference<URLStreamHandlerService>>> map = this.streamHandlers;
        synchronized (map) {
            List<ServiceReference<URLStreamHandlerService>> list = this.streamHandlers.get(protocol);
            if (list == null) {
                list = new ArrayList<ServiceReference<URLStreamHandlerService>>();
                this.streamHandlers.put(protocol, list);
            }
            list.add(reference);
            Collections.sort(list, Collections.reverseOrder(ServiceReferenceComparator.getInstance()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ServiceReference<URLStreamHandlerService>> getStreamHandlers(String protocol) {
        Map<String, List<ServiceReference<URLStreamHandlerService>>> map = this.streamHandlers;
        synchronized (map) {
            return this.streamHandlers.get(protocol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeHandler(ServiceReference<URLStreamHandlerService> reference) {
        Map<String, List<ServiceReference<URLStreamHandlerService>>> map = this.streamHandlers;
        synchronized (map) {
            block3: for (List<ServiceReference<URLStreamHandlerService>> list : this.streamHandlers.values()) {
                Iterator<ServiceReference<URLStreamHandlerService>> it = list.iterator();
                while (it.hasNext()) {
                    if (!it.next().equals(reference)) continue;
                    it.remove();
                    continue block3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearHandlers() {
        Map<String, List<ServiceReference<URLStreamHandlerService>>> map = this.streamHandlers;
        synchronized (map) {
            for (List<ServiceReference<URLStreamHandlerService>> list : this.streamHandlers.values()) {
                list.clear();
            }
        }
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        return this.delegate != null ? this.delegate.createURLStreamHandler(protocol) : null;
    }
}

