/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.SystemBundleContext;
import org.jboss.osgi.framework.internal.SystemBundleRevision;
import org.jboss.osgi.framework.spi.FrameworkModuleProvider;
import org.jboss.osgi.framework.spi.IntegrationConstants;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;

final class SystemBundleState
extends AbstractBundleState<SystemBundleRevision> {
    private final SystemBundleRevision systemRevision;
    private final BundleRevisions bundleRevisions;

    SystemBundleState(FrameworkState frameworkState, SystemBundleRevision brev) {
        super(frameworkState, brev, 0L);
        this.systemRevision = brev;
        brev.putAttachment(IntegrationConstants.MODULE_IDENTIFIER_KEY, FrameworkModuleProvider.FRAMEWORK_MODULE_IDENTIFIER);
        SystemBundleState bundle2 = this;
        this.bundleRevisions = new BundleRevisions((Bundle)bundle2, brev){
            final /* synthetic */ Bundle val$bundle;
            final /* synthetic */ SystemBundleRevision val$brev;
            {
                this.val$bundle = bundle2;
                this.val$brev = systemBundleRevision;
            }

            public Bundle getBundle() {
                return this.val$bundle;
            }

            public List<BundleRevision> getRevisions() {
                return Collections.singletonList(this.val$brev);
            }
        };
    }

    static SystemBundleState assertBundleState(Bundle bundle2) {
        bundle2 = AbstractBundleState.assertBundleState(bundle2);
        assert (bundle2 instanceof SystemBundleState) : "Not an SystemBundleState: " + bundle2;
        return (SystemBundleState)bundle2;
    }

    @Override
    public String getSymbolicName() {
        return "org.jboss.osgi.framework";
    }

    public String getLocation() {
        return "org.jboss.osgi.framework";
    }

    @Override
    public Version getVersion() {
        return BundleManagerPlugin.getFrameworkVersion();
    }

    SystemBundleContext createContextInternal() {
        return new SystemBundleContext(this);
    }

    @Override
    public SystemBundleRevision getBundleRevision() {
        return this.systemRevision;
    }

    @Override
    BundleRevisions getBundleRevisions() {
        return this.bundleRevisions;
    }

    @Override
    public <T> T adapt(Class<T> type) {
        T result = super.adapt(type);
        if (result == null) {
            result = this.getBundleManager().adapt(type);
        }
        return result;
    }

    public boolean isFragment() {
        return false;
    }

    @Override
    boolean isSingleton() {
        return true;
    }

    @Override
    SystemBundleRevision getBundleRevisionById(int revisionId) {
        assert (revisionId == 0) : "System bundle does not have a revision with id: " + revisionId;
        return this.systemRevision;
    }

    @Override
    void startInternal(int options) throws BundleException {
    }

    @Override
    void stopWithOptions(int options) throws BundleException {
        this.getBundleManager().shutdownManager(false);
    }

    @Override
    void stopInternal(int options) throws BundleException {
    }

    @Override
    void updateInternal(InputStream input) throws BundleException {
    }

    @Override
    void uninstallInternal(int options) throws BundleException {
        throw FrameworkMessages.MESSAGES.cannotUninstallSystemBundle();
    }
}

