/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ContentHandler;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.BundleProtocolHandler;
import org.jboss.osgi.framework.internal.OSGiContentHandlerFactory;
import org.jboss.osgi.framework.internal.OSGiContentHandlerFactoryDelegate;
import org.jboss.osgi.framework.internal.OSGiStreamHandlerFactory;
import org.jboss.osgi.framework.internal.OSGiStreamHandlerFactoryDelegate;
import org.jboss.osgi.framework.internal.OSGiStreamHandlerFactoryService;
import org.jboss.osgi.framework.spi.URLHandlerSupport;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerSetter;
import org.osgi.util.tracker.ServiceTracker;

final class URLHandlerSupportImpl
implements URLHandlerSupport {
    private final BundleManagerPlugin bundleManager;
    private ServiceTracker<URLStreamHandlerService, URLStreamHandlerService> streamServiceTracker;
    private ServiceTracker<ContentHandler, ContentHandler> contentServiceTracker;
    private ServiceRegistration<URLStreamHandlerService> registration;
    private static OSGiContentHandlerFactoryDelegate contentHandlerDelegate;
    private static OSGiStreamHandlerFactoryDelegate streamHandlerDelegate;

    static void initURLHandlerSupport() {
        if (streamHandlerDelegate == null) {
            streamHandlerDelegate = new OSGiStreamHandlerFactoryDelegate();
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        URL.setURLStreamHandlerFactory(streamHandlerDelegate);
                    }
                    catch (Throwable th) {
                        FrameworkLogger.LOGGER.debugf("Unable to set the URLStreamHandlerFactory", new Object[0]);
                    }
                    return null;
                }
            });
        }
        if (contentHandlerDelegate == null) {
            contentHandlerDelegate = new OSGiContentHandlerFactoryDelegate();
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        URLConnection.setContentHandlerFactory(contentHandlerDelegate);
                    }
                    catch (Throwable th) {
                        FrameworkLogger.LOGGER.debugf("Unable to set the ContentHandlerFactory", new Object[0]);
                    }
                    return null;
                }
            });
        }
    }

    public URLHandlerSupportImpl(BundleManagerPlugin bundleManager) {
        this.bundleManager = bundleManager;
    }

    @Override
    public void start(BundleContext systemContext) {
        OSGiStreamHandlerFactoryService.setDelegateFactory(this);
        streamHandlerDelegate.setDelegateFactory(new OSGiStreamHandlerFactory(this));
        contentHandlerDelegate.setDelegateFactory(new OSGiContentHandlerFactory(this));
        this.registerStreamHandlerService();
        this.setupStreamHandlerTracker(systemContext);
        this.setupContentHandlerTracker(systemContext);
    }

    @Override
    public void stop() {
        streamHandlerDelegate.clearHandlers();
        contentHandlerDelegate.clearHandlers();
        this.registration.unregister();
        streamHandlerDelegate.setDelegateFactory(null);
        contentHandlerDelegate.setDelegateFactory(null);
        OSGiStreamHandlerFactoryService.setDelegateFactory(null);
    }

    private void registerStreamHandlerService() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("url.handler.protocol", "bundle");
        BundleProtocolHandler service = new BundleProtocolHandler(this.bundleManager);
        BundleContext systemContext = this.bundleManager.getSystemBundle().getBundleContext();
        this.registration = systemContext.registerService(URLStreamHandlerService.class, (Object)service, props);
    }

    private void setupContentHandlerTracker(BundleContext systemContext) {
        this.contentServiceTracker = new ServiceTracker<ContentHandler, ContentHandler>(systemContext, ContentHandler.class, null){

            public ContentHandler addingService(ServiceReference<ContentHandler> reference) {
                ContentHandler service = (ContentHandler)super.addingService(reference);
                String[] mimeTypes = URLHandlerSupportImpl.this.parseServiceProperty(reference.getProperty("url.content.mimetype"));
                if (mimeTypes != null && service instanceof ContentHandler) {
                    FrameworkLogger.LOGGER.debugf("Adding content handler '%s' for: %s", service, Arrays.asList(mimeTypes));
                    for (String mimeType : mimeTypes) {
                        contentHandlerDelegate.addHandler(mimeType, reference);
                    }
                }
                return service;
            }

            public void modifiedService(ServiceReference<ContentHandler> reference, ContentHandler service) {
                this.removedService(reference, service);
                this.addingService((ServiceReference)reference);
            }

            public void removedService(ServiceReference<ContentHandler> reference, ContentHandler service) {
                super.removedService(reference, (Object)service);
                contentHandlerDelegate.removeHandler(reference);
            }
        };
        this.contentServiceTracker.open();
    }

    private void setupStreamHandlerTracker(BundleContext systemContext) {
        this.streamServiceTracker = new ServiceTracker<URLStreamHandlerService, URLStreamHandlerService>(systemContext, URLStreamHandlerService.class, null){

            public URLStreamHandlerService addingService(ServiceReference<URLStreamHandlerService> reference) {
                URLStreamHandlerService service = (URLStreamHandlerService)super.addingService(reference);
                String[] protocols = URLHandlerSupportImpl.this.parseServiceProperty(reference.getProperty("url.handler.protocol"));
                if (protocols != null && service instanceof URLStreamHandlerService) {
                    FrameworkLogger.LOGGER.tracef("Adding stream handler '%s' for: %s", service, Arrays.asList(protocols));
                    for (String protocol : protocols) {
                        streamHandlerDelegate.addHandler(protocol, reference);
                    }
                }
                return service;
            }

            public void modifiedService(ServiceReference<URLStreamHandlerService> reference, URLStreamHandlerService service) {
                this.removedService(reference, service);
                this.addingService(reference);
            }

            public void removedService(ServiceReference<URLStreamHandlerService> reference, URLStreamHandlerService service) {
                super.removedService(reference, (Object)service);
                streamHandlerDelegate.removeHandler(reference);
            }
        };
        this.streamServiceTracker.open();
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        List<ServiceReference<URLStreamHandlerService>> refList = streamHandlerDelegate.getStreamHandlers(protocol);
        if (refList == null || refList.isEmpty()) {
            return null;
        }
        return new URLStreamHandlerProxy(protocol, refList);
    }

    @Override
    public ContentHandler createContentHandler(String mimetype) {
        List<ServiceReference<ContentHandler>> refList = contentHandlerDelegate.getContentHandlers(mimetype);
        if (refList == null || refList.isEmpty()) {
            return null;
        }
        ServiceReference<ContentHandler> ref = refList.get(0);
        Object service = ref.getBundle().getBundleContext().getService(ref);
        if (service instanceof ContentHandler) {
            return (ContentHandler)service;
        }
        return null;
    }

    private String[] parseServiceProperty(Object prop) {
        if (prop == null) {
            return null;
        }
        if (prop instanceof String) {
            return new String[]{(String)prop};
        }
        if (prop instanceof String[]) {
            return (String[])prop;
        }
        return null;
    }

    private static final class URLStreamHandlerProxy
    extends URLStreamHandler
    implements URLStreamHandlerSetter {
        private final List<ServiceReference<URLStreamHandlerService>> serviceReferences;
        private final String protocol;

        public URLStreamHandlerProxy(String protocol, List<ServiceReference<URLStreamHandlerService>> refList) {
            this.protocol = protocol;
            this.serviceReferences = refList;
        }

        @Override
        public void setURL(URL u, String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
            super.setURL(u, protocol, host, port, authority, userInfo, path, query, ref);
        }

        @Override
        public void setURL(URL u, String protocol, String host, int port, String file, String ref) {
            super.setURL(u, protocol, host, port, file, ref);
        }

        @Override
        protected void parseURL(URL u, String spec, int start, int limit) {
            this.getHandlerService().parseURL((URLStreamHandlerSetter)this, u, spec, start, limit);
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return this.getHandlerService().openConnection(u);
        }

        @Override
        protected String toExternalForm(URL u) {
            return this.getHandlerService().toExternalForm(u);
        }

        @Override
        protected URLConnection openConnection(URL u, Proxy p) throws IOException {
            URLStreamHandlerService handler = this.getHandlerService();
            try {
                Method method = handler.getClass().getDeclaredMethod("openConnection", URL.class, Proxy.class);
                return (URLConnection)method.invoke((Object)handler, u, p);
            }
            catch (Throwable th) {
                if (th instanceof InvocationTargetException) {
                    th = ((InvocationTargetException)th).getTargetException();
                }
                throw FrameworkMessages.MESSAGES.cannotOpenConnectionOnHandler(th, handler);
            }
        }

        @Override
        protected int getDefaultPort() {
            return this.getHandlerService().getDefaultPort();
        }

        @Override
        protected boolean equals(URL u1, URL u2) {
            return this.getHandlerService().equals(u1, u2);
        }

        @Override
        protected int hashCode(URL u) {
            return this.getHandlerService().hashCode(u);
        }

        @Override
        protected boolean sameFile(URL u1, URL u2) {
            return this.getHandlerService().sameFile(u1, u2);
        }

        @Override
        protected synchronized InetAddress getHostAddress(URL u) {
            return this.getHandlerService().getHostAddress(u);
        }

        @Override
        protected boolean hostsEqual(URL u1, URL u2) {
            return this.getHandlerService().hostsEqual(u1, u2);
        }

        private URLStreamHandlerService getHandlerService() {
            if (this.serviceReferences.isEmpty()) {
                throw FrameworkMessages.MESSAGES.illegalStateNoStreamHandlersForProtocol(this.protocol);
            }
            ServiceReference<URLStreamHandlerService> ref = this.serviceReferences.get(0);
            URLStreamHandlerService service = (URLStreamHandlerService)ref.getBundle().getBundleContext().getService(ref);
            return service;
        }
    }
}

