/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.FallbackLoader;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.WeavingContext;
import org.jboss.osgi.framework.spi.BundleReferenceClassLoader;
import org.jboss.osgi.framework.spi.FrameworkEvents;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevisionBuilder;
import org.jboss.osgi.resolver.XBundleRevisionBuilderFactory;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XResource;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.weaving.WeavingException;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.resource.Requirement;

final class WeavingHookProcessor
implements ClassFileTransformer {
    private final FrameworkEvents frameworkEvents;
    private final HostBundleRevision hostRev;
    private List<String> processedImports = new ArrayList<String>();

    WeavingHookProcessor(HostBundleRevision hostRev, FrameworkEvents frameworkEvents) {
        this.frameworkEvents = frameworkEvents;
        this.hostRev = hostRev;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        WeavingContext context = WeavingContext.getCurrentContext();
        if (context == null || context.getWeavingHooks().isEmpty()) {
            return classfileBuffer;
        }
        WeavingContext.ContextClass wovenClass = context.createContextClass(className, classBeingRedefined, protectionDomain, classfileBuffer);
        Iterator<WeavingContext.HookRegistration> iterator = context.getWeavingHooks().iterator();
        while (iterator.hasNext()) {
            WeavingContext.HookRegistration hookreg = iterator.next();
            WeavingHook hook = hookreg.hook;
            try {
                hook.weave((WovenClass)wovenClass);
            }
            catch (RuntimeException rte) {
                if (!(rte instanceof WeavingException)) {
                    context.blacklist(hookreg.sref);
                    iterator.remove();
                }
                wovenClass.markComplete();
                BundleReferenceClassLoader bref = (BundleReferenceClassLoader)((Object)hook.getClass().getClassLoader());
                this.frameworkEvents.fireFrameworkEvent((XBundle)bref.getBundleState(), 2, rte, null);
                throw rte;
            }
        }
        this.addDynamicWeavingImports(wovenClass);
        return wovenClass.getBytes();
    }

    private void addDynamicWeavingImports(WeavingContext.ContextClass wovenClass) {
        ArrayList<String> unprocessedImports = new ArrayList<String>();
        for (String importSpec : wovenClass.getDynamicImports()) {
            if (this.processedImports.contains(importSpec)) continue;
            unprocessedImports.add(importSpec);
            this.processedImports.add(importSpec);
        }
        for (String importSpec : unprocessedImports) {
            try {
                OSGiMetaDataBuilder mdbuilder = OSGiMetaDataBuilder.createBuilder((String)this.hostRev.getSymbolicName(), (Version)this.hostRev.getVersion());
                mdbuilder.addDynamicImportPackages(new String[]{importSpec});
                OSGiMetaData metadata = mdbuilder.getOSGiMetaData();
                XBundleRevisionBuilder resbuilder = XBundleRevisionBuilderFactory.create();
                XResource res = resbuilder.loadFrom(metadata).getResource();
                for (Requirement req : res.getRequirements("osgi.wiring.package")) {
                    FallbackLoader fallbackLoader = this.hostRev.getFallbackLoader();
                    fallbackLoader.addDynamicWeavingImport((XPackageRequirement)req);
                }
            }
            catch (RuntimeException rte) {
                throw FrameworkMessages.MESSAGES.illegalArgumentDynamicWeavingImport(rte, importSpec);
            }
        }
    }
}

