/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.FrameworkModuleLoader;
import org.jboss.osgi.framework.spi.FrameworkWiringLock;
import org.jboss.osgi.framework.spi.IntegrationConstants;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.framework.spi.StartLevelManager;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.spi.AbstractElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;

public class AbstractBundleAdaptor
extends AbstractElement
implements XBundle,
LockManager.LockableItem,
BundleStartLevel {
    private final AtomicInteger bundleState = new AtomicInteger(4);
    private final ReentrantLock bundleLock = new ReentrantLock();
    private final BundleManager bundleManager;
    private final BundleContext context;
    private final XBundleRevision brev;
    private final Module module;
    private BundleActivator bundleActivator;
    private long lastModified;

    public AbstractBundleAdaptor(BundleContext context, Module module, XBundleRevision brev) {
        if (context == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("context");
        }
        if (module == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("module");
        }
        if (brev == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("brev");
        }
        XBundle sysbundle = (XBundle)context.getBundle();
        this.bundleManager = (BundleManager)sysbundle.adapt(BundleManager.class);
        this.context = context;
        this.module = module;
        this.brev = brev;
        this.lastModified = System.currentTimeMillis();
    }

    public Bundle getBundle() {
        return this;
    }

    public long getBundleId() {
        Long bundleId = (Long)this.brev.getAttachment(XResource.RESOURCE_IDENTIFIER_KEY);
        return bundleId != null ? bundleId : -1L;
    }

    public String getLocation() {
        String location = this.module.getIdentifier().getName();
        String slot = this.module.getIdentifier().getSlot();
        if (!slot.equals("main")) {
            location = location + ":" + slot;
        }
        return location;
    }

    public String getSymbolicName() {
        String symbolicName = null;
        List icaps = this.brev.getCapabilities("osgi.identity");
        if (icaps.size() > 0) {
            XIdentityCapability icap = (XIdentityCapability)icaps.get(0);
            symbolicName = icap.getName();
        } else {
            symbolicName = this.module.getIdentifier().getName();
        }
        return symbolicName;
    }

    public String getCanonicalName() {
        return this.getSymbolicName() + ":" + this.getVersion();
    }

    public int getState() {
        return this.bundleState.get();
    }

    public Version getVersion() {
        Version version = Version.emptyVersion;
        List icaps = this.brev.getCapabilities("osgi.identity");
        if (icaps.size() > 0) {
            XIdentityCapability icap = (XIdentityCapability)icaps.get(0);
            version = icap.getVersion();
        } else {
            String slot = this.module.getIdentifier().getSlot();
            try {
                version = Version.parseVersion((String)slot);
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        return version;
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.module.getClassLoader().loadClass(name);
    }

    public <T> T adapt(Class<T> type) {
        Object result = null;
        if (type.isAssignableFrom(BundleContext.class)) {
            result = this.getBundleContext();
        } else if (type.isAssignableFrom(BundleRevision.class)) {
            result = this.getBundleRevision();
        } else if (type.isAssignableFrom(BundleRevisions.class)) {
            result = this.getBundleRevisions();
        } else if (type.isAssignableFrom(BundleStartLevel.class)) {
            result = this;
        } else if (type.isAssignableFrom(BundleManager.class)) {
            result = this.bundleManager;
        } else if (type.isAssignableFrom(Module.class)) {
            result = this.module;
        }
        return (T)result;
    }

    BundleRevisions getBundleRevisions() {
        AbstractBundleAdaptor bundle2 = this;
        return new BundleRevisions((Bundle)bundle2){
            final /* synthetic */ Bundle val$bundle;
            {
                this.val$bundle = bundle2;
            }

            public Bundle getBundle() {
                return this.val$bundle;
            }

            public List<BundleRevision> getRevisions() {
                return Collections.singletonList(AbstractBundleAdaptor.this.brev);
            }

            public String toString() {
                return this.val$bundle + ": [" + AbstractBundleAdaptor.this.brev + "]";
            }
        };
    }

    public void start(int options) throws BundleException {
        LockManager lockManager;
        LockManager.LockContext lockContext;
        block12: {
            block11: {
                lockContext = null;
                lockManager = this.getPluginService(IntegrationServices.LOCK_MANAGER_PLUGIN, LockManager.class);
                lockContext = lockManager.lockItems(LockManager.Method.START, this);
                if (this.getState() != 32) break block11;
                lockManager.unlockItems(lockContext);
                return;
            }
            this.setPersistentlyStarted(true);
            if (this.startLevelValidForStart()) break block12;
            if ((options & 1) != 0) {
                throw FrameworkMessages.MESSAGES.cannotStartBundleDueToStartLevel();
            }
            int frameworkState = this.bundleManager.getSystemBundle().getState();
            StartLevelManager plugin = this.getPluginService(IntegrationServices.START_LEVEL_PLUGIN, StartLevelManager.class);
            Logger.Level level = plugin.isFrameworkStartLevelChanging() || frameworkState != 32 ? Logger.Level.DEBUG : Logger.Level.INFO;
            FrameworkLogger.LOGGER.log(level, FrameworkMessages.MESSAGES.bundleStartLevelNotValid(this.getStartLevel(), plugin.getFrameworkStartLevel(), (Bundle)this));
            lockManager.unlockItems(lockContext);
            return;
        }
        try {
            String activatorName;
            this.bundleState.set(8);
            OSGiMetaData metadata = (OSGiMetaData)this.brev.getAttachment(IntegrationConstants.OSGI_METADATA_KEY);
            String string = activatorName = metadata != null ? metadata.getBundleActivator() : null;
            if (this.bundleActivator == null && activatorName != null) {
                Object result = this.loadClass(activatorName).newInstance();
                if (result instanceof BundleActivator) {
                    this.bundleActivator = (BundleActivator)result;
                } else {
                    throw FrameworkMessages.MESSAGES.invalidBundleActivator(activatorName);
                }
            }
            if (this.bundleActivator != null) {
                this.bundleActivator.start(this.context);
            }
            this.setPersistentlyStarted(true);
            this.bundleState.set(32);
            FrameworkLogger.LOGGER.infoBundleStarted((Bundle)this);
            lockManager.unlockItems(lockContext);
        }
        catch (Throwable th) {
            try {
                this.bundleState.set(4);
                throw new BundleException(FrameworkMessages.MESSAGES.cannotStartBundle((Bundle)this), th);
            }
            catch (Throwable throwable) {
                lockManager.unlockItems(lockContext);
                throw throwable;
            }
        }
    }

    public void start() throws BundleException {
        this.start(0);
    }

    public void stop(int options) throws BundleException {
        LockManager lockManager;
        LockManager.LockContext lockContext;
        block7: {
            lockContext = null;
            lockManager = this.getPluginService(IntegrationServices.LOCK_MANAGER_PLUGIN, LockManager.class);
            lockContext = lockManager.lockItems(LockManager.Method.STOP, this);
            if (this.getState() == 32) break block7;
            lockManager.unlockItems(lockContext);
            return;
        }
        try {
            if ((options & 1) == 0) {
                this.setPersistentlyStarted(false);
            }
            if (this.bundleActivator != null) {
                this.bundleActivator.stop(this.context);
            }
            this.bundleState.set(4);
            FrameworkLogger.LOGGER.infoBundleStopped((Bundle)this);
            lockManager.unlockItems(lockContext);
        }
        catch (Throwable th) {
            try {
                throw FrameworkMessages.MESSAGES.cannotStopBundle(th, (Bundle)this);
            }
            catch (Throwable throwable) {
                lockManager.unlockItems(lockContext);
                throw throwable;
            }
        }
    }

    public void stop() throws BundleException {
        this.stop(0);
    }

    public void update(InputStream input) throws BundleException {
        throw FrameworkMessages.MESSAGES.unsupportedBundleOpertaion((Bundle)this);
    }

    public void update() throws BundleException {
        throw FrameworkMessages.MESSAGES.unsupportedBundleOpertaion((Bundle)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall() throws BundleException {
        LockManager.LockContext lockContext = null;
        LockManager lockManager = this.getPluginService(IntegrationServices.LOCK_MANAGER_PLUGIN, LockManager.class);
        try {
            FrameworkWiringLock wireLock = lockManager.getItemForType(FrameworkWiringLock.class);
            lockContext = lockManager.lockItems(LockManager.Method.RESOLVE, wireLock, this);
            XEnvironment env = this.getPluginService(Services.ENVIRONMENT, XEnvironment.class);
            env.uninstallResources(new XResource[]{this.getBundleRevision()});
            FrameworkModuleLoader provider = this.getPluginService(IntegrationServices.FRAMEWORK_MODULE_LOADER_PLUGIN, FrameworkModuleLoader.class);
            provider.removeModule(this.brev);
            this.bundleState.set(1);
            lockManager.unlockItems(lockContext);
        }
        catch (Throwable throwable) {
            lockManager.unlockItems(lockContext);
            throw throwable;
        }
    }

    public Dictionary<String, String> getHeaders() {
        return this.getHeaders(null);
    }

    public Dictionary<String, String> getHeaders(String locale) {
        return new Hashtable<String, String>();
    }

    public ServiceReference<?>[] getRegisteredServices() {
        return null;
    }

    public ServiceReference<?>[] getServicesInUse() {
        return null;
    }

    public boolean hasPermission(Object permission) {
        return false;
    }

    public URL getResource(String name) {
        return this.getBundleRevision().getResource(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return this.getBundleRevision().getResources(name);
    }

    public Enumeration<String> getEntryPaths(String path) {
        return this.getBundleRevision().getEntryPaths(path);
    }

    public URL getEntry(String path) {
        return this.getBundleRevision().getEntry(path);
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        return this.getBundleRevision().findEntries(path, filePattern, recurse);
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
        return Collections.emptyMap();
    }

    public boolean isResolved() {
        return true;
    }

    public boolean isFragment() {
        return this.getBundleRevision().isFragment();
    }

    public XBundleRevision getBundleRevision() {
        return this.brev;
    }

    public int getStartLevel() {
        StartLevelManager plugin = this.getPluginService(IntegrationServices.START_LEVEL_PLUGIN, StartLevelManager.class);
        return plugin.getBundleStartLevel(this);
    }

    public void setStartLevel(int level) {
        StartLevelManager plugin = this.getPluginService(IntegrationServices.START_LEVEL_PLUGIN, StartLevelManager.class);
        plugin.setBundleStartLevel(this, level);
    }

    public boolean isPersistentlyStarted() {
        StartLevelManager plugin = this.getPluginService(IntegrationServices.START_LEVEL_PLUGIN, StartLevelManager.class);
        return plugin.isBundlePersistentlyStarted(this);
    }

    public boolean isActivationPolicyUsed() {
        StartLevelManager plugin = this.getPluginService(IntegrationServices.START_LEVEL_PLUGIN, StartLevelManager.class);
        return plugin.isBundleActivationPolicyUsed(this);
    }

    private void setPersistentlyStarted(boolean started) {
        StartLevelManager plugin = this.getPluginService(IntegrationServices.START_LEVEL_PLUGIN, StartLevelManager.class);
        plugin.setBundlePersistentlyStarted(this, started);
    }

    private boolean startLevelValidForStart() {
        StartLevelManager plugin = this.getPluginService(IntegrationServices.START_LEVEL_PLUGIN, StartLevelManager.class);
        return plugin.getBundleStartLevel(this) <= plugin.getFrameworkStartLevel();
    }

    @Override
    public ReentrantLock getReentrantLock() {
        return this.bundleLock;
    }

    private <T> T getPluginService(ServiceName serviceName, Class<T> pluginType) {
        ServiceContainer serviceContainer = this.bundleManager.getServiceContainer();
        ServiceController service = serviceContainer.getRequiredService(serviceName);
        return (T)service.getValue();
    }

    public int hashCode() {
        return (int)this.getBundleId() * 51;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XBundle)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        XBundle other = (XBundle)obj;
        return this.getBundleId() == other.getBundleId();
    }

    public File getDataFile(String filename) {
        throw new UnsupportedOperationException();
    }

    public int compareTo(Bundle o) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getCanonicalName();
    }
}

