/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.osgi.framework.FrameworkLogger;

public class ServiceTracker<S>
extends AbstractServiceListener<S> {
    private final Set<ServiceName> addedNames = new HashSet<ServiceName>();
    private final Set<ServiceController<? extends S>> trackedControllers = new HashSet<ServiceController<? extends S>>();
    private final List<ServiceController<?>> started = new ArrayList();
    private final List<ServiceController<?>> failed = new ArrayList();
    private final CountDownLatch completionLatch = new CountDownLatch(1);
    private final AtomicBoolean allComplete = new AtomicBoolean();
    private final boolean completeOnFirstFailure;
    private final String trackerName;

    public ServiceTracker() {
        this("Anonymous");
    }

    public ServiceTracker(String trackerName) {
        this(trackerName, true);
    }

    public ServiceTracker(String trackerName, boolean completeOnFail) {
        this.completeOnFirstFailure = completeOnFail;
        this.trackerName = trackerName;
    }

    public String getTrackerName() {
        return this.trackerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listenerAdded(ServiceController<? extends S> controller) {
        Set<ServiceController<? extends S>> set = this.trackedControllers;
        synchronized (set) {
            if (this.trackService(controller)) {
                this.serviceListerAddedInternal(controller);
                ServiceController.State state = controller.getState();
                switch (state) {
                    case UP: {
                        this.started.add(controller);
                        this.serviceStarted(controller);
                        break;
                    }
                    case START_FAILED: {
                        this.failed.add(controller);
                        this.serviceStartFailed(controller);
                        break;
                    }
                    default: {
                        this.trackedControllers.add(controller);
                        break;
                    }
                }
            } else {
                controller.removeListener((ServiceListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transition(ServiceController<? extends S> controller, ServiceController.Transition transition) {
        Set<ServiceController<? extends S>> set = this.trackedControllers;
        synchronized (set) {
            if (!this.allComplete.get()) {
                switch (transition) {
                    case STARTING_to_UP: {
                        FrameworkLogger.LOGGER.tracef("ServiceTracker %s transition to UP: %s", this.trackerName, controller.getName());
                        this.started.add(controller);
                        this.serviceStarted(controller);
                        this.serviceCompleteInternal(controller, false);
                        break;
                    }
                    case STARTING_to_START_FAILED: {
                        FrameworkLogger.LOGGER.tracef("ServiceTracker %s transition to START_FAILED: %s", this.trackerName, controller.getName());
                        this.failed.add(controller);
                        this.serviceStartFailed(controller);
                        this.serviceCompleteInternal(controller, true);
                        break;
                    }
                    case START_REQUESTED_to_DOWN: {
                        this.serviceCompleteInternal(controller, false);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronousListenerServiceStarted(ServiceController<? extends S> controller) {
        Set<ServiceController<? extends S>> set = this.trackedControllers;
        synchronized (set) {
            FrameworkLogger.LOGGER.tracef("ServiceTracker %s synchronous service started: %s", this.trackerName, controller.getName());
            this.started.add(controller);
            this.serviceStarted(controller);
            this.serviceCompleteInternal(controller, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronousListenerServiceFailed(ServiceController<? extends S> controller, Throwable th) {
        Set<ServiceController<? extends S>> set = this.trackedControllers;
        synchronized (set) {
            FrameworkLogger.LOGGER.tracef("ServiceTracker %s synchronous service failed: %s", this.trackerName, controller.getName());
            this.failed.add(controller);
            this.serviceStartFailed(controller);
            this.serviceCompleteInternal(controller, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndComplete() {
        Set<ServiceController<? extends S>> set = this.trackedControllers;
        synchronized (set) {
            if (this.trackedControllers.size() == 0 && this.allServicesAdded(Collections.unmodifiableSet(this.addedNames))) {
                this.completeInternal();
            }
        }
    }

    public boolean isComplete() {
        return this.allComplete.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void untrackService(ServiceController<? extends S> controller) {
        Set<ServiceController<? extends S>> set = this.trackedControllers;
        synchronized (set) {
            FrameworkLogger.LOGGER.tracef("ServiceTracker %s untrack service: %s", this.trackerName, controller.getName());
            this.trackedControllers.remove(controller);
            controller.removeListener((ServiceListener)this);
            this.checkAndComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServiceController<?>> getStartedServices() {
        Set<ServiceController<? extends S>> set = this.trackedControllers;
        synchronized (set) {
            return Collections.unmodifiableList(this.started);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServiceController<?>> getFailedServices() {
        Set<ServiceController<? extends S>> set = this.trackedControllers;
        synchronized (set) {
            return Collections.unmodifiableList(this.failed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getFirstFailure() {
        Set<ServiceController<? extends S>> set = this.trackedControllers;
        synchronized (set) {
            Throwable failure = null;
            for (ServiceController<?> controller : this.failed) {
                StartException startex = controller.getStartException();
                if (startex == null || startex.getCause() == null) continue;
                failure = startex.getCause();
                break;
            }
            return failure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFailedServices() {
        Set<ServiceController<? extends S>> set = this.trackedControllers;
        synchronized (set) {
            return !this.failed.isEmpty();
        }
    }

    public boolean awaitCompletion() throws InterruptedException {
        this.completionLatch.await();
        return !this.hasFailedServices();
    }

    public boolean awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!this.completionLatch.await(timeout, unit)) {
            throw new TimeoutException();
        }
        return !this.hasFailedServices();
    }

    protected boolean trackService(ServiceController<? extends S> controller) {
        return true;
    }

    protected boolean allServicesAdded(Set<ServiceName> trackedServices) {
        return true;
    }

    protected void serviceListenerAdded(ServiceController<? extends S> controller) {
    }

    protected void serviceStarted(ServiceController<? extends S> controller) {
    }

    protected void serviceStartFailed(ServiceController<? extends S> controller) {
    }

    protected void complete() {
    }

    private void serviceListerAddedInternal(ServiceController<? extends S> controller) {
        FrameworkLogger.LOGGER.tracef("ServiceTracker %s controller added: %s", this.trackerName, controller.getName());
        this.addedNames.add(controller.getName());
        this.serviceListenerAdded(controller);
    }

    private void serviceCompleteInternal(ServiceController<? extends S> controller, boolean failure) {
        this.trackedControllers.remove(controller);
        controller.removeListener((ServiceListener)this);
        if (failure && this.completeOnFirstFailure) {
            Iterator<ServiceController<S>> iterator = this.trackedControllers.iterator();
            while (iterator.hasNext()) {
                ServiceController<? extends S> aux = iterator.next();
                aux.removeListener((ServiceListener)this);
                iterator.remove();
            }
            this.completeInternal();
        } else {
            this.checkAndComplete();
        }
    }

    private void completeInternal() {
        if (this.allComplete.compareAndSet(false, true)) {
            FrameworkLogger.LOGGER.debugf("ServiceTracker %s complete", this.trackerName);
            this.completionLatch.countDown();
            this.complete();
        }
    }
}

