/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.io.IOException;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.StorageManagerImpl;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.StorageManager;

public class StorageManagerPlugin
extends AbstractIntegrationService<StorageManager> {
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final boolean firstInit;

    public StorageManagerPlugin(boolean firstInit) {
        super(IntegrationServices.STORAGE_MANAGER_PLUGIN);
        this.firstInit = firstInit;
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<StorageManager> builder) {
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, this.injectedBundleManager);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public void start(StartContext startContext) throws StartException {
        super.start(startContext);
        try {
            StorageManager bundleStorage = (StorageManager)this.getValue();
            BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
            bundleStorage.initialize(bundleManager.getProperties(), this.firstInit);
        }
        catch (IOException ex) {
            throw new StartException((Throwable)ex);
        }
    }

    @Override
    protected StorageManager createServiceValue(StartContext startContext) throws StartException {
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        return new StorageManagerImpl(bundleManager);
    }
}

