/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.util.HashSet;
import java.util.Set;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.SystemServices;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class SystemServicesPlugin
extends AbstractIntegrationService<SystemServices> {
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();
    private final InjectedValue<XResolver> injectedResolver = new InjectedValue();
    private final Set<ServiceRegistration<?>> registrations = new HashSet();

    public SystemServicesPlugin() {
        super(IntegrationServices.SYSTEM_SERVICES_PLUGIN);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<SystemServices> builder) {
        builder.addDependency(Services.FRAMEWORK_CREATE, BundleContext.class, this.injectedSystemContext);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, this.injectedEnvironment);
        builder.addDependency(Services.RESOLVER, XResolver.class, this.injectedResolver);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public void start(StartContext startContext) throws StartException {
        super.start(startContext);
        BundleContext systemContext = (BundleContext)this.injectedSystemContext.getValue();
        ((SystemServices)this.getValue()).registerServices(systemContext);
    }

    @Override
    protected SystemServices createServiceValue(StartContext startContext) throws StartException {
        return new SystemServicesImpl();
    }

    public void stop(StopContext context) {
        ((SystemServices)this.getValue()).unregisterServices();
    }

    class SystemServicesImpl
    implements SystemServices {
        SystemServicesImpl() {
        }

        @Override
        public void registerServices(BundleContext context) {
            SystemServicesPlugin.this.registrations.add(context.registerService(XEnvironment.class, SystemServicesPlugin.this.injectedEnvironment.getValue(), null));
            SystemServicesPlugin.this.registrations.add(context.registerService(XResolver.class, SystemServicesPlugin.this.injectedResolver.getValue(), null));
        }

        @Override
        public void unregisterServices() {
            for (ServiceRegistration sreg : SystemServicesPlugin.this.registrations) {
                sreg.unregister();
            }
        }
    }
}

