/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remotingjmx.protocol.v1;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.marshalling.AbstractClassResolver;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.remoting3.Channel;
import org.jboss.remotingjmx.protocol.CancellableDataOutputStream;
import org.xnio.IoUtils;

abstract class Common {
    private final Channel channel;
    private final MarshallerFactory marshallerFactory = Marshalling.getProvidedMarshallerFactory("river");

    Common(Channel channel) {
        if (this.marshallerFactory == null) {
            throw new RuntimeException("Could not find a marshaller factory for river marshalling strategy");
        }
        this.channel = channel;
    }

    protected Marshaller prepareForMarshalling(final DataOutput dataOutput) throws IOException {
        Marshaller marshaller = this.getMarshaller(this.marshallerFactory);
        OutputStream outputStream = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                int byteToWrite = b & 0xFF;
                dataOutput.write(byteToWrite);
            }
        };
        ByteOutput byteOutput = Marshalling.createByteOutput(outputStream);
        marshaller.start(byteOutput);
        return marshaller;
    }

    protected Unmarshaller prepareForUnMarshalling(DataInput dataInput) throws IOException {
        return this.prepareForUnMarshalling(dataInput, DefaultClassResolver.INSTANCE);
    }

    protected Unmarshaller prepareForUnMarshalling(final DataInput dataInput, ClassResolver classResolver) throws IOException {
        Unmarshaller unmarshaller = this.getUnMarshaller(this.marshallerFactory, classResolver);
        InputStream is = new InputStream(){

            @Override
            public int read() throws IOException {
                try {
                    byte b = dataInput.readByte();
                    return b & 0xFF;
                }
                catch (EOFException eof) {
                    return -1;
                }
            }
        };
        ByteInput byteInput = Marshalling.createByteInput(is);
        unmarshaller.start(byteInput);
        return unmarshaller;
    }

    private Marshaller getMarshaller(MarshallerFactory marshallerFactory) throws IOException {
        MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
        marshallingConfiguration.setVersion(2);
        return marshallerFactory.createMarshaller(marshallingConfiguration);
    }

    private Unmarshaller getUnMarshaller(MarshallerFactory marshallerFactory, ClassResolver classResolver) throws IOException {
        MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
        marshallingConfiguration.setVersion(2);
        marshallingConfiguration.setClassResolver(classResolver);
        return marshallerFactory.createUnmarshaller(marshallingConfiguration);
    }

    protected void write(MessageWriter writer) throws IOException {
        CancellableDataOutputStream output = new CancellableDataOutputStream(this.channel.writeMessage());
        try {
            writer.write(output);
        }
        catch (IOException e) {
            output.cancel();
            throw e;
        }
        finally {
            IoUtils.safeClose((Closeable)output);
        }
    }

    private static final class DefaultClassResolver
    extends AbstractClassResolver {
        public static final DefaultClassResolver INSTANCE = new DefaultClassResolver();
        private static final PrivilegedAction<ClassLoader> classLoaderAction = new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        };

        private DefaultClassResolver() {
        }

        @Override
        protected ClassLoader getClassLoader() {
            SecurityManager sm = System.getSecurityManager();
            ClassLoader classLoader = sm != null ? AccessController.doPrivileged(classLoaderAction) : Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                return DefaultClassResolver.class.getClassLoader();
            }
            return classLoader;
        }
    }

    static interface MessageHandler {
        public void handle(DataInput var1, int var2) throws IOException;
    }

    static interface MessageWriter {
        public void write(DataOutput var1) throws IOException;
    }
}

