/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.access.constraint.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ListValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class ListAttributeDefinition
extends AttributeDefinition {
    private final ParameterValidator elementValidator;

    public ListAttributeDefinition(String name, boolean allowNull, ParameterValidator elementValidator) {
        this(name, name, allowNull, false, 0, Integer.MAX_VALUE, elementValidator, null, null, null);
    }

    protected ListAttributeDefinition(String name, boolean allowNull, ParameterValidator elementValidator, AttributeAccess.Flag ... flags) {
        this(name, name, allowNull, false, 0, Integer.MAX_VALUE, elementValidator, (String[])null, (String[])null, (AttributeMarshaller)null, false, (DeprecationData)null, (AccessConstraintDefinition[])null, flags);
    }

    public ListAttributeDefinition(String name, String xmlName, boolean allowNull, int minSize, int maxSize, ParameterValidator elementValidator) {
        this(name, xmlName, allowNull, false, minSize, maxSize, elementValidator, null, null, null);
    }

    protected ListAttributeDefinition(String name, String xmlName, boolean allowNull, boolean allowExpressions, int minSize, int maxSize, ParameterValidator elementValidator, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecated, AttributeAccess.Flag ... flags) {
        this(name, xmlName, allowNull, allowExpressions, minSize, maxSize, elementValidator, alternatives, requires, attributeMarshaller, resourceOnly, deprecated, (AccessConstraintDefinition[])null, flags);
    }

    protected ListAttributeDefinition(String name, String xmlName, boolean allowNull, boolean allowExpressions, int minSize, int maxSize, ParameterValidator elementValidator, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecated, AccessConstraintDefinition[] accessConstraints, AttributeAccess.Flag ... flags) {
        this(name, xmlName, allowNull, allowExpressions, minSize, maxSize, elementValidator, alternatives, requires, attributeMarshaller, accessConstraints, flags);
    }

    protected ListAttributeDefinition(String name, String xmlName, boolean allowNull, boolean allowExpressions, int minSize, int maxSize, ParameterValidator elementValidator, String[] alternatives, String[] requires, AttributeAccess.Flag ... flags) {
        this(name, xmlName, allowNull, allowExpressions, minSize, maxSize, elementValidator, alternatives, requires, (AttributeMarshaller)null, (AccessConstraintDefinition[])null, flags);
    }

    protected ListAttributeDefinition(String name, String xmlName, boolean allowNull, boolean allowExpressions, int minSize, int maxSize, ParameterValidator elementValidator, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, AccessConstraintDefinition[] accessConstraints, AttributeAccess.Flag ... flags) {
        super(name, xmlName, null, ModelType.LIST, allowNull, allowExpressions, null, null, (ParameterValidator)new ListValidator(elementValidator, allowNull, minSize, maxSize), allowNull, alternatives, requires, attributeMarshaller, false, null, accessConstraints, flags);
        this.elementValidator = elementValidator;
    }

    public ParameterValidator getElementValidator() {
        return this.elementValidator;
    }

    public ModelNode parse(String value, XMLStreamReader reader) throws XMLStreamException {
        try {
            return this.parse(value);
        }
        catch (OperationFailedException e) {
            throw new XMLStreamException(e.getFailureDescription().toString(), reader.getLocation());
        }
    }

    public void parseAndAddParameterElement(String value, ModelNode operation, XMLStreamReader reader) throws XMLStreamException {
        ModelNode paramVal = this.parse(value, reader);
        operation.get(this.getName()).add(paramVal);
    }

    @Override
    public ModelNode addResourceAttributeDescription(ResourceBundle bundle2, String prefix, ModelNode resourceDescription) {
        ModelNode result = super.addResourceAttributeDescription(bundle2, prefix, resourceDescription);
        this.addValueTypeDescription(result, bundle2);
        return result;
    }

    @Override
    public ModelNode addResourceAttributeDescription(ModelNode resourceDescription, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode result = super.addResourceAttributeDescription(resourceDescription, resolver, locale, bundle2);
        this.addAttributeValueTypeDescription(result, resolver, locale, bundle2);
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ModelNode resourceDescription, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode result = super.addOperationParameterDescription(resourceDescription, operationName, resolver, locale, bundle2);
        this.addOperationParameterValueTypeDescription(result, operationName, resolver, locale, bundle2);
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ResourceBundle bundle2, String prefix, ModelNode operationDescription) {
        ModelNode result = super.addOperationParameterDescription(bundle2, prefix, operationDescription);
        this.addValueTypeDescription(result, bundle2);
        return result;
    }

    protected abstract void addValueTypeDescription(ModelNode var1, ResourceBundle var2);

    protected abstract void addAttributeValueTypeDescription(ModelNode var1, ResourceDescriptionResolver var2, Locale var3, ResourceBundle var4);

    protected abstract void addOperationParameterValueTypeDescription(ModelNode var1, String var2, ResourceDescriptionResolver var3, Locale var4, ResourceBundle var5);

    private ModelNode parse(String value) throws OperationFailedException {
        ModelNode node;
        String trimmed;
        String string = trimmed = value == null ? null : value.trim();
        if (trimmed != null) {
            node = this.isAllowExpression() ? ParseUtils.parsePossibleExpression(trimmed) : new ModelNode().set(trimmed);
            if (node.getType() != ModelType.EXPRESSION) {
                switch (this.getType()) {
                    case BIG_DECIMAL: {
                        node.set(node.asBigDecimal());
                        break;
                    }
                    case BIG_INTEGER: {
                        node.set(node.asBigInteger());
                        break;
                    }
                    case BOOLEAN: {
                        node.set(node.asBoolean());
                        break;
                    }
                    case BYTES: {
                        node.set(node.asBytes());
                        break;
                    }
                    case DOUBLE: {
                        node.set(node.asDouble());
                        break;
                    }
                    case INT: {
                        node.set(node.asInt());
                        break;
                    }
                    case LONG: {
                        node.set(node.asLong());
                    }
                }
            }
        } else {
            node = new ModelNode();
        }
        this.elementValidator.validateParameter(this.getXmlName(), node);
        return node;
    }

    @Override
    public void marshallAsElement(ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        this.attributeMarshaller.marshallAsElement(this, resourceModel, marshallDefault, writer);
    }

    @Override
    protected ModelNode convertParameterExpressions(ModelNode parameter) {
        ModelNode result = parameter;
        if (parameter.isDefined()) {
            boolean changeMade = false;
            ModelNode newList = new ModelNode().setEmptyList();
            for (ModelNode item : parameter.asList()) {
                ModelNode converted = this.convertParameterElementExpressions(item);
                newList.add(converted);
                changeMade |= !converted.equals(item);
            }
            if (changeMade) {
                result = newList;
            }
        }
        return result;
    }

    protected ModelNode convertParameterElementExpressions(ModelNode parameterElement) {
        return this.isAllowExpression() ? ListAttributeDefinition.convertStringExpression(parameterElement) : parameterElement;
    }
}

