/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.access.constraint.management.AccessConstraintDefinition;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;

public final class Action {
    private static final List<AccessConstraintDefinition> NO_CONSTRAINTS = Collections.emptyList();
    private final ModelNode operation;
    private final OperationEntry operationEntry;
    private final Set<ActionEffect> actionEffects;

    public Action(ModelNode operation, OperationEntry operationEntry) {
        this.operation = operation;
        this.operationEntry = operationEntry;
        this.actionEffects = Collections.unmodifiableSet(Action.determineActionEffects(operationEntry));
    }

    public Action(ModelNode operation, OperationEntry operationEntry, Set<ActionEffect> effects) {
        this.operation = operation;
        this.operationEntry = operationEntry;
        this.actionEffects = Collections.unmodifiableSet(effects);
    }

    private static Set<ActionEffect> determineActionEffects(OperationEntry operationEntry) {
        EnumSet<ActionEffect> result;
        if (operationEntry == null) {
            return Collections.emptySet();
        }
        if (operationEntry.getFlags().contains((Object)OperationEntry.Flag.RUNTIME_ONLY)) {
            result = EnumSet.of(ActionEffect.ADDRESS, ActionEffect.READ_RUNTIME);
            if (!operationEntry.getFlags().contains((Object)OperationEntry.Flag.READ_ONLY)) {
                result.add(ActionEffect.WRITE_RUNTIME);
            }
        } else {
            result = operationEntry.getFlags().contains((Object)OperationEntry.Flag.READ_ONLY) ? EnumSet.of(ActionEffect.ADDRESS, ActionEffect.READ_CONFIG, ActionEffect.READ_RUNTIME) : EnumSet.allOf(ActionEffect.class);
        }
        return result;
    }

    public ModelNode getOperation() {
        return this.operation;
    }

    public Set<ActionEffect> getActionEffects() {
        return this.actionEffects;
    }

    public EnumSet<OperationEntry.Flag> getFlags() {
        return this.operationEntry != null ? this.operationEntry.getFlags() : EnumSet.noneOf(OperationEntry.Flag.class);
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.operationEntry != null ? this.operationEntry.getAccessConstraints() : NO_CONSTRAINTS;
    }

    public Action limitAction(ActionEffect requiredEffect) {
        if (this.actionEffects.contains((Object)requiredEffect) && this.actionEffects.size() == 1) {
            return this;
        }
        return new Action(this.operation, this.operationEntry, EnumSet.of(requiredEffect));
    }

    public static enum ActionEffect {
        ADDRESS("address"),
        READ_CONFIG("read-config"),
        READ_RUNTIME("read-runtime"),
        WRITE_CONFIG("write-config"),
        WRITE_RUNTIME("write-runtime");

        private final String name;

        private ActionEffect(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

