/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.permission;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.access.Authorizer;
import org.jboss.as.controller.access.Caller;
import org.jboss.as.controller.access.Environment;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.access.permission.PermissionFactory;
import org.jboss.dmr.ModelNode;

public class ManagementPermissionAuthorizer
implements Authorizer {
    private final PermissionFactory permissionFactory;

    public ManagementPermissionAuthorizer(PermissionFactory permissionFactory) {
        this.permissionFactory = permissionFactory;
    }

    @Override
    public AuthorizationResult authorize(Caller caller, Environment callEnvironment, Action action, TargetAttribute target) {
        if (callEnvironment.getProcessState() == ControlledProcessState.State.STARTING) {
            return AuthorizationResult.PERMITTED;
        }
        PermissionCollection userPerms = this.permissionFactory.getUserPermissions(caller, callEnvironment, action, target);
        PermissionCollection requiredPerms = this.permissionFactory.getRequiredPermissions(action, target);
        return this.authorize(userPerms, requiredPerms);
    }

    @Override
    public AuthorizationResult authorize(Caller caller, Environment callEnvironment, Action action, TargetResource target) {
        if (callEnvironment.getProcessState() == ControlledProcessState.State.STARTING) {
            return AuthorizationResult.PERMITTED;
        }
        PermissionCollection userPerms = this.permissionFactory.getUserPermissions(caller, callEnvironment, action, target);
        PermissionCollection requiredPerms = this.permissionFactory.getRequiredPermissions(action, target);
        return this.authorize(userPerms, requiredPerms);
    }

    private AuthorizationResult authorize(PermissionCollection userPermissions, PermissionCollection requiredPermissions) {
        Enumeration<Permission> enumeration = requiredPermissions.elements();
        while (enumeration.hasMoreElements()) {
            Permission requiredPermission = enumeration.nextElement();
            if (userPermissions.implies(requiredPermission)) continue;
            return new AuthorizationResult(AuthorizationResult.Decision.DENY, new ModelNode("Permission denied"));
        }
        return AuthorizationResult.PERMITTED;
    }
}

