/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.permission;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.constraint.Constraint;
import org.jboss.as.controller.access.constraint.ScopingConstraint;
import org.jboss.as.controller.access.permission.ManagementPermission;
import org.jboss.as.controller.access.permission.ManagementPermissionCollection;

public class SimpleManagementPermission
extends ManagementPermission {
    private final Constraint[] constraints;

    public SimpleManagementPermission(Action.ActionEffect actionEffect, List<Constraint> constraints) {
        this(actionEffect, constraints.toArray(new Constraint[constraints.size()]));
    }

    public SimpleManagementPermission(Action.ActionEffect actionEffect, Constraint ... constraints) {
        super("SimpleManagementPermission", actionEffect);
        this.constraints = constraints;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new ManagementPermissionCollection(this.getClass());
    }

    @Override
    public boolean implies(Permission permission) {
        if (this.equals(permission)) {
            SimpleManagementPermission other = (SimpleManagementPermission)permission;
            assert (this.constraints.length == other.constraints.length) : String.format("incompatible ManagementPermission; differing constraint counts %d vs %d", this.constraints.length, other.constraints.length);
            for (int i = 0; i < this.constraints.length; ++i) {
                Constraint ours = this.constraints[i];
                Constraint theirs = other.constraints[i];
                assert (ours.getClass() == theirs.getClass()) : "incompatible constraints: ours = " + ours.getClass() + " -- theirs = " + theirs.getClass();
                if (!ours.violates(theirs)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagementPermission that = (ManagementPermission)o;
        return this.getActionEffect() == that.getActionEffect();
    }

    @Override
    public int hashCode() {
        return this.getActionEffect().hashCode();
    }

    @Override
    public String getActions() {
        return this.getActionEffect().toString();
    }

    @Override
    public ManagementPermission createScopedPermission(ScopingConstraint constraint) {
        boolean added = false;
        ArrayList<Constraint> newList = new ArrayList<Constraint>();
        for (Constraint existing : this.constraints) {
            int compare = existing.compareTo(constraint);
            if (compare > 0) {
                if (!added) {
                    newList.add(constraint);
                    added = true;
                }
            } else {
                if (compare == 0) {
                    assert (existing.equals(constraint)) : "inconsistent equals and compareTo in " + constraint + " and " + existing;
                    continue;
                }
                if (compare < 0) assert (!added) : "inconsistent ordering of constraints";
            }
            newList.add(existing);
        }
        if (!added) {
            newList.add(constraint);
        }
        return new SimpleManagementPermission(this.getActionEffect(), newList);
    }
}

