/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.rbac;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.Caller;
import org.jboss.as.controller.access.Environment;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.access.constraint.ApplicationTypeConstraint;
import org.jboss.as.controller.access.constraint.AuditConstraint;
import org.jboss.as.controller.access.constraint.Constraint;
import org.jboss.as.controller.access.constraint.ConstraintFactory;
import org.jboss.as.controller.access.constraint.HostEffectConstraint;
import org.jboss.as.controller.access.constraint.NonAuditConstraint;
import org.jboss.as.controller.access.constraint.ScopingConstraint;
import org.jboss.as.controller.access.constraint.SensitiveTargetConstraint;
import org.jboss.as.controller.access.constraint.SensitiveVaultExpressionConstraint;
import org.jboss.as.controller.access.constraint.ServerGroupEffectConstraint;
import org.jboss.as.controller.access.permission.CombinationManagementPermission;
import org.jboss.as.controller.access.permission.CombinationPolicy;
import org.jboss.as.controller.access.permission.ManagementPermission;
import org.jboss.as.controller.access.permission.ManagementPermissionCollection;
import org.jboss.as.controller.access.permission.PermissionFactory;
import org.jboss.as.controller.access.permission.SimpleManagementPermission;
import org.jboss.as.controller.access.rbac.RoleMapper;
import org.jboss.as.controller.access.rbac.StandardRole;

public class DefaultPermissionFactory
implements PermissionFactory {
    private static final PermissionCollection NO_PERMISSIONS = new NoPermissionsCollection();
    private final CombinationPolicy combinationPolicy;
    private final RoleMapper roleMapper;
    private final Set<ConstraintFactory> constraintFactories;
    private final Map<String, ManagementPermissionCollection> permissionsByRole = new HashMap<String, ManagementPermissionCollection>();
    private final Map<String, ScopedBase> scopedBaseMap = new HashMap<String, ScopedBase>();
    private boolean rolePermissionsConfigured;

    public DefaultPermissionFactory(CombinationPolicy combinationPolicy, RoleMapper roleMapper) {
        this(combinationPolicy, roleMapper, DefaultPermissionFactory.getStandardConstraintFactories());
    }

    DefaultPermissionFactory(CombinationPolicy combinationPolicy, RoleMapper roleMapper, Set<ConstraintFactory> constraintFactories) {
        this.combinationPolicy = combinationPolicy;
        this.roleMapper = roleMapper;
        this.constraintFactories = constraintFactories;
    }

    @Override
    public PermissionCollection getUserPermissions(Caller caller, Environment callEnvironment, Action action, TargetAttribute target) {
        return this.getUserPermissions(this.roleMapper.mapRoles(caller, callEnvironment, action, target));
    }

    @Override
    public PermissionCollection getUserPermissions(Caller caller, Environment callEnvironment, Action action, TargetResource target) {
        return this.getUserPermissions(this.roleMapper.mapRoles(caller, callEnvironment, action, target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionCollection getUserPermissions(Set<String> roles) {
        PermissionCollection result;
        this.configureRolePermissions();
        PermissionCollection simple = null;
        HashMap<Action.ActionEffect, CombinationManagementPermission> combined = null;
        for (String roleName : roles) {
            CombinationManagementPermission cmp;
            Action.ActionEffect actionEffect;
            ManagementPermission mperm;
            Enumeration<Permission> permissionEnumeration;
            if (this.combinationPolicy == CombinationPolicy.REJECTING && simple != null) {
                throw ControllerMessages.MESSAGES.illegalMultipleRoles();
            }
            ManagementPermissionCollection role = null;
            DefaultPermissionFactory defaultPermissionFactory = this;
            synchronized (defaultPermissionFactory) {
                role = this.permissionsByRole.get(roleName);
            }
            if (role == null) {
                throw new IllegalArgumentException("unknown role " + role);
            }
            if (simple == null) {
                simple = role;
                continue;
            }
            if (combined == null) {
                combined = new HashMap<Action.ActionEffect, CombinationManagementPermission>();
                permissionEnumeration = ((ManagementPermissionCollection)simple).elements();
                while (permissionEnumeration.hasMoreElements()) {
                    mperm = (ManagementPermission)permissionEnumeration.nextElement();
                    actionEffect = mperm.getActionEffect();
                    cmp = new CombinationManagementPermission(this.combinationPolicy, actionEffect);
                    cmp.addUnderlyingPermission(mperm);
                    combined.put(actionEffect, cmp);
                }
            }
            permissionEnumeration = role.elements();
            while (permissionEnumeration.hasMoreElements()) {
                mperm = (ManagementPermission)permissionEnumeration.nextElement();
                actionEffect = mperm.getActionEffect();
                cmp = (CombinationManagementPermission)combined.get((Object)actionEffect);
                if (cmp == null) {
                    cmp = new CombinationManagementPermission(this.combinationPolicy, actionEffect);
                    combined.put(actionEffect, cmp);
                }
                cmp.addUnderlyingPermission(mperm);
            }
        }
        if (combined == null) {
            result = simple != null ? simple : NO_PERMISSIONS;
        } else {
            result = new ManagementPermissionCollection(CombinationManagementPermission.class);
            for (CombinationManagementPermission cmp : combined.values()) {
                result.add(cmp);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionCollection getRequiredPermissions(Action action, TargetAttribute target) {
        ArrayList<ConstraintFactory> factories;
        DefaultPermissionFactory defaultPermissionFactory = this;
        synchronized (defaultPermissionFactory) {
            factories = new ArrayList<ConstraintFactory>(this.constraintFactories);
        }
        ManagementPermissionCollection result = new ManagementPermissionCollection(SimpleManagementPermission.class);
        for (Action.ActionEffect actionEffect : action.getActionEffects()) {
            TreeSet<Constraint> constraints = new TreeSet<Constraint>();
            for (ConstraintFactory factory : factories) {
                constraints.add(factory.getRequiredConstraint(actionEffect, action, target));
            }
            result.add(new SimpleManagementPermission(actionEffect, constraints.toArray(new Constraint[constraints.size()])));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionCollection getRequiredPermissions(Action action, TargetResource target) {
        ArrayList<ConstraintFactory> factories;
        DefaultPermissionFactory defaultPermissionFactory = this;
        synchronized (defaultPermissionFactory) {
            factories = new ArrayList<ConstraintFactory>(this.constraintFactories);
        }
        ManagementPermissionCollection result = new ManagementPermissionCollection(SimpleManagementPermission.class);
        for (Action.ActionEffect actionEffect : action.getActionEffects()) {
            TreeSet<Constraint> constraints = new TreeSet<Constraint>();
            for (ConstraintFactory factory : factories) {
                constraints.add(factory.getRequiredConstraint(actionEffect, action, target));
            }
            result.add(new SimpleManagementPermission(actionEffect, constraints.toArray(new Constraint[constraints.size()])));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConstraintFactory(ConstraintFactory factory) {
        DefaultPermissionFactory defaultPermissionFactory = this;
        synchronized (defaultPermissionFactory) {
            if (this.constraintFactories.add(factory)) {
                this.rolePermissionsConfigured = false;
            }
        }
    }

    public void addScopedRole(String roleName, String baseName, ScopingConstraint constraint) {
        StandardRole base = StandardRole.valueOf(baseName.toUpperCase(Locale.ENGLISH));
        this.configureRolePermissions();
        this.addScopedRoleInternal(roleName, base, constraint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScopedRole(String roleName) {
        try {
            StandardRole standard = StandardRole.valueOf(roleName.toUpperCase(Locale.ENGLISH));
            if (standard != null) {
                throw new IllegalStateException("cannot remove standard role " + roleName);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        DefaultPermissionFactory defaultPermissionFactory = this;
        synchronized (defaultPermissionFactory) {
            this.permissionsByRole.remove(roleName);
        }
    }

    private synchronized void configureRolePermissions() {
        if (!this.rolePermissionsConfigured) {
            this.permissionsByRole.clear();
            this.permissionsByRole.putAll(this.configureDefaultPermissions());
            for (Map.Entry<String, ScopedBase> entry : this.scopedBaseMap.entrySet()) {
                this.addScopedRoleInternal(entry.getKey(), entry.getValue().base, entry.getValue().constraint);
            }
            this.rolePermissionsConfigured = true;
        }
    }

    private synchronized Map<String, ManagementPermissionCollection> configureDefaultPermissions() {
        HashMap<String, ManagementPermissionCollection> result = new HashMap<String, ManagementPermissionCollection>();
        for (StandardRole standardRole : StandardRole.values()) {
            ManagementPermissionCollection rolePerms = new ManagementPermissionCollection(SimpleManagementPermission.class);
            for (Action.ActionEffect actionEffect : Action.ActionEffect.values()) {
                if (!standardRole.isActionEffectAllowed(actionEffect)) continue;
                TreeSet<Constraint> constraints = new TreeSet<Constraint>();
                for (ConstraintFactory factory : this.constraintFactories) {
                    constraints.add(factory.getStandardUserConstraint(standardRole, actionEffect));
                }
                rolePerms.add(new SimpleManagementPermission(actionEffect, constraints.toArray(new Constraint[constraints.size()])));
            }
            result.put(standardRole.toString(), rolePerms);
        }
        return result;
    }

    private synchronized void addScopedRoleInternal(String roleName, StandardRole base, ScopingConstraint constraint) {
        if (this.permissionsByRole.containsKey(roleName)) {
            throw new IllegalStateException(String.format("role %s is already registered", roleName));
        }
        ManagementPermissionCollection baseCollection = this.permissionsByRole.get(base.toString());
        if (baseCollection == null) {
            throw new IllegalArgumentException(String.format("Unknown base role %s", new Object[]{base}));
        }
        ManagementPermissionCollection scopedPermissions = null;
        Enumeration<Permission> permissionEnumeration = baseCollection.elements();
        while (permissionEnumeration.hasMoreElements()) {
            ManagementPermission basePerm = (ManagementPermission)permissionEnumeration.nextElement();
            ManagementPermission scopedPerm = basePerm.createScopedPermission(constraint);
            if (scopedPermissions == null) {
                scopedPermissions = (ManagementPermissionCollection)scopedPerm.newPermissionCollection();
            }
            scopedPermissions.add(scopedPerm);
        }
        this.permissionsByRole.put(roleName, scopedPermissions);
        this.scopedBaseMap.put(roleName, new ScopedBase(base, constraint));
    }

    private static Set<ConstraintFactory> getStandardConstraintFactories() {
        LinkedHashSet<ConstraintFactory> result = new LinkedHashSet<ConstraintFactory>();
        result.add(ApplicationTypeConstraint.FACTORY);
        result.add(AuditConstraint.FACTORY);
        result.add(NonAuditConstraint.FACTORY);
        result.add(HostEffectConstraint.FACTORY);
        result.add(SensitiveTargetConstraint.FACTORY);
        result.add(SensitiveVaultExpressionConstraint.FACTORY);
        result.add(ServerGroupEffectConstraint.FACTORY);
        return result;
    }

    private static class NoPermissionsCollection
    extends PermissionCollection {
        private static final long serialVersionUID = 426277167342589940L;

        private NoPermissionsCollection() {
        }

        @Override
        public void add(Permission permission) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean implies(Permission permission) {
            return false;
        }

        @Override
        public Enumeration<Permission> elements() {
            return new Enumeration<Permission>(){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                @Override
                public Permission nextElement() {
                    throw new NoSuchElementException();
                }
            };
        }
    }

    private class ScopedBase {
        private final StandardRole base;
        private final ScopingConstraint constraint;

        private ScopedBase(StandardRole base, ScopingConstraint constraint) {
            this.base = base;
            this.constraint = constraint;
        }
    }
}

