/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.audit;

import java.net.InetAddress;
import java.util.Date;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.audit.AuditLogItemFormatter;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.dmr.ModelNode;

abstract class AuditLogItem {
    private final Date date = new Date();
    private final String asVersion;
    protected final boolean readOnly;
    protected final boolean booting;
    protected final String userId;
    protected final String domainUUID;
    protected final AccessMechanism accessMechanism;
    protected final InetAddress remoteAddress;

    AuditLogItem(String asVersion, boolean readOnly, boolean booting, String userId, String domainUUID, AccessMechanism accessMechanism, InetAddress remoteAddress) {
        this.asVersion = asVersion;
        this.readOnly = readOnly;
        this.booting = booting;
        this.userId = userId;
        this.domainUUID = domainUUID;
        this.accessMechanism = accessMechanism;
        this.remoteAddress = remoteAddress;
    }

    static AuditLogItem createModelControllerItem(String asVersion, boolean readOnly, boolean booting, OperationContext.ResultAction resultAction, String userId, String domainUUID, AccessMechanism accessMechanism, InetAddress remoteAddress, Resource resultantModel, List<ModelNode> operations) {
        return new ModelControllerAuditLogItem(asVersion, readOnly, booting, resultAction, userId, domainUUID, accessMechanism, remoteAddress, resultantModel, operations);
    }

    static AuditLogItem createMethodAccessItem(String asVersion, boolean readOnly, boolean booting, String userId, String domainUUID, AccessMechanism accessMechanism, InetAddress remoteAddress, String methodName, String[] methodSignature, Object[] methodParams, Throwable error) {
        return new MethodAccessAuditLogItem(asVersion, readOnly, booting, userId, domainUUID, accessMechanism, remoteAddress, methodName, methodSignature, methodParams, error);
    }

    abstract String format(AuditLogItemFormatter var1);

    public String getAsVersion() {
        return this.asVersion;
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    boolean isBooting() {
        return this.booting;
    }

    String getUserId() {
        return this.userId;
    }

    String getDomainUUID() {
        return this.domainUUID;
    }

    AccessMechanism getAccessMechanism() {
        return this.accessMechanism;
    }

    InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public Date getDate() {
        return (Date)this.date.clone();
    }

    static class MethodAccessAuditLogItem
    extends AuditLogItem {
        private final String methodName;
        private final String[] methodSignature;
        private final Object[] methodParams;
        private final Throwable error;

        MethodAccessAuditLogItem(String asVersion, boolean readOnly, boolean booting, String userId, String domainUUID, AccessMechanism accessMechanism, InetAddress remoteAddress, String methodName, String[] methodSignature, Object[] methodParams, Throwable error) {
            super(asVersion, readOnly, booting, userId, domainUUID, accessMechanism, remoteAddress);
            this.methodName = methodName;
            this.methodSignature = methodSignature;
            this.methodParams = methodParams;
            this.error = error;
        }

        @Override
        String format(AuditLogItemFormatter formatter) {
            return formatter.formatAuditLogItem(this);
        }

        String getMethodName() {
            return this.methodName;
        }

        String[] getMethodSignature() {
            return this.methodSignature;
        }

        Object[] getMethodParams() {
            return this.methodParams;
        }

        Throwable getError() {
            return this.error;
        }
    }

    static class ModelControllerAuditLogItem
    extends AuditLogItem {
        private final OperationContext.ResultAction resultAction;
        private final Resource resultantModel;
        private final List<ModelNode> operations;

        ModelControllerAuditLogItem(String asVersion, boolean readOnly, boolean booting, OperationContext.ResultAction resultAction, String userId, String domainUUID, AccessMechanism accessMechanism, InetAddress remoteAddress, Resource resultantModel, List<ModelNode> operations) {
            super(asVersion, readOnly, booting, userId, domainUUID, accessMechanism, remoteAddress);
            this.resultAction = resultAction;
            this.resultantModel = resultantModel;
            this.operations = operations;
        }

        @Override
        String format(AuditLogItemFormatter formatter) {
            return formatter.formatAuditLogItem(this);
        }

        OperationContext.ResultAction getResultAction() {
            return this.resultAction;
        }

        Resource getResultantModel() {
            return this.resultantModel;
        }

        List<ModelNode> getOperations() {
            return this.operations;
        }
    }
}

