/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.access.constraint.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.constraint.management.ConstrainedResourceDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.AbstractResourceRegistration;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.AtomicMapFieldUpdater;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.NodeSubregistry;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;

final class ConcreteResourceRegistration
extends AbstractResourceRegistration {
    private volatile Map<String, NodeSubregistry> children;
    private volatile Map<String, OperationEntry> operations;
    private volatile ResourceDefinition resourceDefinition;
    private volatile Map<String, AttributeAccess> attributes;
    private final AtomicBoolean runtimeOnly = new AtomicBoolean();
    private static final AtomicMapFieldUpdater<ConcreteResourceRegistration, String, NodeSubregistry> childrenUpdater = AtomicMapFieldUpdater.newMapUpdater(AtomicReferenceFieldUpdater.newUpdater(ConcreteResourceRegistration.class, Map.class, "children"));
    private static final AtomicMapFieldUpdater<ConcreteResourceRegistration, String, OperationEntry> operationsUpdater = AtomicMapFieldUpdater.newMapUpdater(AtomicReferenceFieldUpdater.newUpdater(ConcreteResourceRegistration.class, Map.class, "operations"));
    private static final AtomicMapFieldUpdater<ConcreteResourceRegistration, String, AttributeAccess> attributesUpdater = AtomicMapFieldUpdater.newMapUpdater(AtomicReferenceFieldUpdater.newUpdater(ConcreteResourceRegistration.class, Map.class, "attributes"));
    private static final AtomicReferenceFieldUpdater<ConcreteResourceRegistration, ResourceDefinition> descriptionProviderUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcreteResourceRegistration.class, ResourceDefinition.class, "resourceDefinition");

    ConcreteResourceRegistration(String valueString, NodeSubregistry parent, ResourceDefinition provider, boolean runtimeOnly) {
        super(valueString, parent);
        childrenUpdater.clear(this);
        operationsUpdater.clear(this);
        attributesUpdater.clear(this);
        descriptionProviderUpdater.set(this, provider);
        this.runtimeOnly.set(runtimeOnly);
    }

    @Override
    public boolean isRuntimeOnly() {
        ConcreteResourceRegistration.checkPermission();
        return this.runtimeOnly.get();
    }

    @Override
    public void setRuntimeOnly(boolean runtimeOnly) {
        ConcreteResourceRegistration.checkPermission();
        this.runtimeOnly.set(runtimeOnly);
    }

    @Override
    public boolean isRemote() {
        ConcreteResourceRegistration.checkPermission();
        return false;
    }

    @Override
    public List<AccessConstraintDefinition> getAccessConstraints() {
        ConcreteResourceRegistration.checkPermission();
        AbstractResourceRegistration reg = this;
        ArrayList<AccessConstraintDefinition> list = new ArrayList<AccessConstraintDefinition>();
        while (reg != null) {
            ((AbstractResourceRegistration)reg).addAccessConstraints(list);
            NodeSubregistry parent = reg.getParent();
            reg = parent == null ? null : parent.getParent();
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    void addAccessConstraints(List<AccessConstraintDefinition> list) {
        if (this.resourceDefinition instanceof ConstrainedResourceDefinition) {
            list.addAll(((ConstrainedResourceDefinition)this.resourceDefinition).getAccessConstraints());
        }
    }

    @Override
    public ManagementResourceRegistration registerSubModel(ResourceDefinition resourceDefinition) {
        if (resourceDefinition == null) {
            throw ControllerMessages.MESSAGES.nullVar("resourceDefinition");
        }
        PathElement address = resourceDefinition.getPathElement();
        if (address == null) {
            throw ControllerMessages.MESSAGES.cannotRegisterSubmodelWithNullPath();
        }
        if (this.isRuntimeOnly()) {
            throw ControllerMessages.MESSAGES.cannotRegisterSubmodel();
        }
        AbstractResourceRegistration existing = this.getSubRegistration(PathAddress.pathAddress(address));
        if (existing != null && existing.getValueString().equals(address.getValue())) {
            throw ControllerMessages.MESSAGES.nodeAlreadyRegistered(existing.getLocationString());
        }
        String key = address.getKey();
        NodeSubregistry child = this.getOrCreateSubregistry(key);
        ManagementResourceRegistration resourceRegistration = child.register(address.getValue(), resourceDefinition, false);
        resourceDefinition.registerAttributes(resourceRegistration);
        resourceDefinition.registerOperations(resourceRegistration);
        resourceDefinition.registerChildren(resourceRegistration);
        return resourceRegistration;
    }

    @Override
    public void registerOperationHandler(OperationDefinition definition, OperationStepHandler handler, boolean inherited) {
        ConcreteResourceRegistration.checkPermission();
        if (operationsUpdater.putIfAbsent(this, definition.getName(), new OperationEntry(handler, definition.getDescriptionProvider(), inherited, definition.getEntryType(), definition.getFlags(), definition.getAccessConstraints())) != null) {
            throw this.alreadyRegistered("operation handler", definition.getName());
        }
    }

    @Override
    public void unregisterSubModel(PathElement address) throws IllegalArgumentException {
        Map<String, NodeSubregistry> snapshot = childrenUpdater.get(this);
        NodeSubregistry subregistry = snapshot.get(address.getKey());
        if (subregistry != null) {
            subregistry.unregisterSubModel(address.getValue());
        }
    }

    @Override
    OperationEntry getOperationEntry(ListIterator<PathElement> iterator, String operationName, OperationEntry inherited) {
        if (iterator.hasNext()) {
            OperationEntry ourInherited = this.getInheritableOperationEntry(operationName);
            OperationEntry inheritance = ourInherited == null ? inherited : ourInherited;
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.children.get(next.getKey());
            if (subregistry == null) {
                return null;
            }
            return subregistry.getOperationEntry(iterator, next.getValue(), operationName, inheritance);
        }
        ConcreteResourceRegistration.checkPermission();
        OperationEntry entry = operationsUpdater.get(this, operationName);
        return entry == null ? inherited : entry;
    }

    @Override
    OperationEntry getInheritableOperationEntry(String operationName) {
        ConcreteResourceRegistration.checkPermission();
        OperationEntry entry = operationsUpdater.get(this, operationName);
        if (entry != null && entry.isInherited()) {
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void getOperationDescriptions(ListIterator<PathElement> iterator, Map<String, OperationEntry> providers, boolean inherited) {
        if (!iterator.hasNext()) {
            ConcreteResourceRegistration.checkPermission();
            providers.putAll(operationsUpdater.get(this));
            if (inherited) {
                this.getInheritedOperations(providers, true);
            }
            return;
        }
        PathElement next = iterator.next();
        try {
            String key = next.getKey();
            Map<String, NodeSubregistry> snapshot = childrenUpdater.get(this);
            NodeSubregistry subregistry = snapshot.get(key);
            if (subregistry != null) {
                subregistry.getHandlers(iterator, next.getValue(), providers, inherited);
            }
        }
        finally {
            iterator.previous();
        }
    }

    @Override
    void getInheritedOperationEntries(Map<String, OperationEntry> providers) {
        ConcreteResourceRegistration.checkPermission();
        for (Map.Entry<String, OperationEntry> entry : operationsUpdater.get(this).entrySet()) {
            if (!entry.getValue().isInherited() || providers.containsKey(entry.getKey())) continue;
            providers.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, OperationEntry.EntryType entryType) {
        ConcreteResourceRegistration.checkPermission();
        if (operationsUpdater.putIfAbsent(this, operationName, new OperationEntry(handler, descriptionProvider, inherited, entryType)) != null) {
            throw this.alreadyRegistered("operation handler", operationName);
        }
    }

    @Override
    public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, OperationEntry.EntryType entryType, EnumSet<OperationEntry.Flag> flags) {
        ConcreteResourceRegistration.checkPermission();
        if (operationsUpdater.putIfAbsent(this, operationName, new OperationEntry(handler, descriptionProvider, inherited, entryType, flags, null)) != null) {
            throw this.alreadyRegistered("operation handler", operationName);
        }
    }

    @Override
    public void unregisterOperationHandler(String operationName) {
        ConcreteResourceRegistration.checkPermission();
        if (operationsUpdater.remove(this, operationName) == null) {
            throw this.operationNotRegisteredException(operationName, this.resourceDefinition.getPathElement());
        }
    }

    @Override
    public void registerReadWriteAttribute(String attributeName, OperationStepHandler readHandler, OperationStepHandler writeHandler, AttributeAccess.Storage storage) {
        ConcreteResourceRegistration.checkPermission();
        AttributeAccess aa = new AttributeAccess(AttributeAccess.AccessType.READ_WRITE, storage, readHandler, writeHandler, null, null);
        if (attributesUpdater.putIfAbsent(this, attributeName, aa) != null) {
            throw this.alreadyRegistered("attribute", attributeName);
        }
    }

    @Override
    public void registerReadWriteAttribute(String attributeName, OperationStepHandler readHandler, OperationStepHandler writeHandler, EnumSet<AttributeAccess.Flag> flags) {
        ConcreteResourceRegistration.checkPermission();
        AttributeAccess.Storage storage = flags != null && flags.contains((Object)AttributeAccess.Flag.STORAGE_RUNTIME) ? AttributeAccess.Storage.RUNTIME : AttributeAccess.Storage.CONFIGURATION;
        AttributeAccess aa = new AttributeAccess(AttributeAccess.AccessType.READ_WRITE, storage, readHandler, writeHandler, null, flags);
        if (attributesUpdater.putIfAbsent(this, attributeName, aa) != null) {
            throw this.alreadyRegistered("attribute", attributeName);
        }
    }

    @Override
    public void registerReadWriteAttribute(AttributeDefinition definition, OperationStepHandler readHandler, OperationStepHandler writeHandler) {
        ConcreteResourceRegistration.checkPermission();
        EnumSet<AttributeAccess.Flag> flags = definition.getFlags();
        String attributeName = definition.getName();
        AttributeAccess.Storage storage = flags != null && flags.contains((Object)AttributeAccess.Flag.STORAGE_RUNTIME) ? AttributeAccess.Storage.RUNTIME : AttributeAccess.Storage.CONFIGURATION;
        AttributeAccess aa = new AttributeAccess(AttributeAccess.AccessType.READ_WRITE, storage, readHandler, writeHandler, definition, flags);
        if (attributesUpdater.putIfAbsent(this, attributeName, aa) != null) {
            throw this.alreadyRegistered("attribute", attributeName);
        }
    }

    @Override
    public void registerReadOnlyAttribute(String attributeName, OperationStepHandler readHandler, AttributeAccess.Storage storage) {
        ConcreteResourceRegistration.checkPermission();
        AttributeAccess aa = new AttributeAccess(AttributeAccess.AccessType.READ_ONLY, storage, readHandler, null, null, null);
        if (attributesUpdater.putIfAbsent(this, attributeName, aa) != null) {
            throw this.alreadyRegistered("attribute", attributeName);
        }
    }

    @Override
    public void registerReadOnlyAttribute(String attributeName, OperationStepHandler readHandler, EnumSet<AttributeAccess.Flag> flags) {
        ConcreteResourceRegistration.checkPermission();
        AttributeAccess.Storage storage = flags != null && flags.contains((Object)AttributeAccess.Flag.STORAGE_RUNTIME) ? AttributeAccess.Storage.RUNTIME : AttributeAccess.Storage.CONFIGURATION;
        AttributeAccess aa = new AttributeAccess(AttributeAccess.AccessType.READ_ONLY, storage, readHandler, null, null, null);
        if (attributesUpdater.putIfAbsent(this, attributeName, aa) != null) {
            throw this.alreadyRegistered("attribute", attributeName);
        }
    }

    @Override
    public void registerReadOnlyAttribute(AttributeDefinition definition, OperationStepHandler readHandler) {
        ConcreteResourceRegistration.checkPermission();
        EnumSet<AttributeAccess.Flag> flags = definition.getFlags();
        String attributeName = definition.getName();
        AttributeAccess.Storage storage = flags != null && flags.contains((Object)AttributeAccess.Flag.STORAGE_RUNTIME) ? AttributeAccess.Storage.RUNTIME : AttributeAccess.Storage.CONFIGURATION;
        AttributeAccess aa = new AttributeAccess(AttributeAccess.AccessType.READ_ONLY, storage, readHandler, null, definition, flags);
        if (attributesUpdater.putIfAbsent(this, attributeName, aa) != null) {
            throw this.alreadyRegistered("attribute", attributeName);
        }
    }

    @Override
    public void registerMetric(String attributeName, OperationStepHandler metricHandler) {
        this.registerMetric(attributeName, metricHandler, null);
    }

    @Override
    public void registerMetric(String attributeName, OperationStepHandler metricHandler, EnumSet<AttributeAccess.Flag> flags) {
        ConcreteResourceRegistration.checkPermission();
        AttributeAccess aa = new AttributeAccess(AttributeAccess.AccessType.METRIC, AttributeAccess.Storage.RUNTIME, metricHandler, null, null, flags);
        if (attributesUpdater.putIfAbsent(this, attributeName, aa) != null) {
            throw this.alreadyRegistered("attribute", attributeName);
        }
    }

    @Override
    public void unregisterAttribute(String attributeName) {
        ConcreteResourceRegistration.checkPermission();
        attributesUpdater.remove(this, attributeName);
    }

    @Override
    public void registerMetric(AttributeDefinition definition, OperationStepHandler metricHandler) {
        ConcreteResourceRegistration.checkPermission();
        AttributeAccess aa = new AttributeAccess(AttributeAccess.AccessType.METRIC, AttributeAccess.Storage.RUNTIME, metricHandler, null, definition, definition.getFlags());
        if (attributesUpdater.putIfAbsent(this, definition.getName(), aa) != null) {
            throw this.alreadyRegistered("attribute", definition.getName());
        }
    }

    @Override
    public void registerProxyController(PathElement address, ProxyController controller) throws IllegalArgumentException {
        AbstractResourceRegistration existing = this.getSubRegistration(PathAddress.pathAddress(address));
        if (existing != null && existing.getValueString().equals(address.getValue())) {
            throw ControllerMessages.MESSAGES.nodeAlreadyRegistered(existing.getLocationString());
        }
        this.getOrCreateSubregistry(address.getKey()).registerProxyController(address.getValue(), controller);
    }

    @Override
    public void unregisterProxyController(PathElement address) throws IllegalArgumentException {
        Map<String, NodeSubregistry> snapshot = childrenUpdater.get(this);
        NodeSubregistry subregistry = snapshot.get(address.getKey());
        if (subregistry != null) {
            subregistry.unregisterProxyController(address.getValue());
        }
    }

    @Override
    public void registerAlias(PathElement address, AliasEntry alias, AbstractResourceRegistration target) {
        this.getOrCreateSubregistry(address.getKey()).registerAlias(address.getValue(), alias, target);
    }

    @Override
    public void unregisterAlias(PathElement address) {
        Map<String, NodeSubregistry> snapshot = childrenUpdater.get(this);
        NodeSubregistry subregistry = snapshot.get(address.getKey());
        if (subregistry != null) {
            subregistry.unregisterAlias(address.getValue());
        }
    }

    NodeSubregistry getOrCreateSubregistry(String key) {
        NodeSubregistry newRegistry;
        NodeSubregistry appearing;
        do {
            Map<String, NodeSubregistry> snapshot;
            NodeSubregistry subregistry;
            if ((subregistry = (snapshot = childrenUpdater.get(this)).get(key)) != null) {
                return subregistry;
            }
            ConcreteResourceRegistration.checkPermission();
            newRegistry = new NodeSubregistry(key, this);
            appearing = childrenUpdater.putAtomic(this, key, newRegistry, snapshot);
            if (appearing != null) continue;
            return newRegistry;
        } while (appearing == newRegistry);
        return appearing;
    }

    @Override
    DescriptionProvider getModelDescription(ListIterator<PathElement> iterator) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.children.get(next.getKey());
            if (subregistry == null) {
                return null;
            }
            return subregistry.getModelDescription(iterator, next.getValue());
        }
        ConcreteResourceRegistration.checkPermission();
        return this.resourceDefinition.getDescriptionProvider(this);
    }

    @Override
    Set<String> getAttributeNames(ListIterator<PathElement> iterator) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.children.get(next.getKey());
            if (subregistry == null) {
                return Collections.emptySet();
            }
            return subregistry.getAttributeNames(iterator, next.getValue());
        }
        ConcreteResourceRegistration.checkPermission();
        Map<String, AttributeAccess> snapshot = attributesUpdater.get(this);
        return snapshot.keySet();
    }

    @Override
    AttributeAccess getAttributeAccess(ListIterator<PathElement> iterator, String attributeName) {
        ModelNode desc;
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.children.get(next.getKey());
            if (subregistry == null) {
                return null;
            }
            return subregistry.getAttributeAccess(iterator, next.getValue(), attributeName);
        }
        ConcreteResourceRegistration.checkPermission();
        Map<String, AttributeAccess> snapshot = attributesUpdater.get(this);
        AttributeAccess access = snapshot.get(attributeName);
        if (access == null && this.hasNoAlternativeWildcardRegistration() && (desc = this.resourceDefinition.getDescriptionProvider(this).getModelDescription(null)).has("attributes") && desc.get("attributes").keys().contains(attributeName)) {
            access = new AttributeAccess(AttributeAccess.AccessType.READ_ONLY, AttributeAccess.Storage.CONFIGURATION, null, null, null, null);
        }
        return access;
    }

    @Override
    Set<String> getChildNames(ListIterator<PathElement> iterator) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.children.get(next.getKey());
            if (subregistry == null) {
                return Collections.emptySet();
            }
            return subregistry.getChildNames(iterator, next.getValue());
        }
        ConcreteResourceRegistration.checkPermission();
        Map<String, NodeSubregistry> children = this.children;
        if (children != null) {
            return Collections.unmodifiableSet(children.keySet());
        }
        return Collections.emptySet();
    }

    @Override
    Set<PathElement> getChildAddresses(ListIterator<PathElement> iterator) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.children.get(next.getKey());
            if (subregistry == null) {
                return Collections.emptySet();
            }
            return subregistry.getChildAddresses(iterator, next.getValue());
        }
        ConcreteResourceRegistration.checkPermission();
        Map<String, NodeSubregistry> children = this.children;
        if (children != null) {
            HashSet<PathElement> elements = new HashSet<PathElement>();
            for (Map.Entry<String, NodeSubregistry> entry : children.entrySet()) {
                for (String entryChild : entry.getValue().getChildNames()) {
                    elements.add(PathElement.pathElement(entry.getKey(), entryChild));
                }
            }
            return elements;
        }
        return Collections.emptySet();
    }

    @Override
    ProxyController getProxyController(ListIterator<PathElement> iterator) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.children.get(next.getKey());
            if (subregistry == null) {
                return null;
            }
            return subregistry.getProxyController(iterator, next.getValue());
        }
        return null;
    }

    @Override
    void getProxyControllers(ListIterator<PathElement> iterator, Set<ProxyController> controllers) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.children.get(next.getKey());
            if (subregistry == null) {
                return;
            }
            if (next.isWildcard()) {
                subregistry.getProxyControllers(iterator, null, controllers);
            } else if (next.isMultiTarget()) {
                for (String value : next.getSegments()) {
                    subregistry.getProxyControllers(iterator, value, controllers);
                }
            } else {
                subregistry.getProxyControllers(iterator, next.getValue(), controllers);
            }
        } else {
            Map<String, NodeSubregistry> snapshot = childrenUpdater.get(this);
            for (NodeSubregistry subregistry : snapshot.values()) {
                subregistry.getProxyControllers(iterator, null, controllers);
            }
        }
    }

    @Override
    AbstractResourceRegistration getResourceRegistration(ListIterator<PathElement> iterator) {
        if (!iterator.hasNext()) {
            ConcreteResourceRegistration.checkPermission();
            return this;
        }
        PathElement address = iterator.next();
        Map<String, NodeSubregistry> snapshot = childrenUpdater.get(this);
        NodeSubregistry subregistry = snapshot.get(address.getKey());
        if (subregistry != null) {
            return subregistry.getResourceRegistration(iterator, address.getValue());
        }
        return null;
    }

    private IllegalArgumentException alreadyRegistered(String type, String name) {
        return ControllerMessages.MESSAGES.alreadyRegistered(type, name, this.getLocationString());
    }

    private IllegalArgumentException operationNotRegisteredException(String op, PathElement address) {
        return ControllerMessages.MESSAGES.operationNotRegisteredException(op, PathAddress.pathAddress(address));
    }

    @Override
    public AliasEntry getAliasEntry() {
        ConcreteResourceRegistration.checkPermission();
        return null;
    }
}

