/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionListeners;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.wildfly.clustering.web.Batcher;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.undertow.session.ImmutableSessionAdapter;
import org.wildfly.clustering.web.undertow.session.SessionAdapter;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;

public class SessionManagerAdapter
implements UndertowSessionManager {
    private final SessionListeners sessionListeners = new SessionListeners();
    private final SessionManager<Void> manager;

    public SessionManagerAdapter(SessionManager<Void> manager) {
        this.manager = manager;
    }

    @Override
    public SessionListeners getSessionListeners() {
        return this.sessionListeners;
    }

    @Override
    public SessionManager<Void> getSessionManager() {
        return this.manager;
    }

    public Map.Entry<String, String> parse(String id) {
        int index = id != null ? id.indexOf(46) : -1;
        return index < 0 ? new AbstractMap.SimpleImmutableEntry<String, Object>(id, null) : new AbstractMap.SimpleImmutableEntry<String, String>(id.substring(0, index), id.substring(index + 1));
    }

    public String format(String sessionId, String routeId) {
        return routeId != null ? String.format("%s.%s", sessionId, routeId) : sessionId;
    }

    public String locate(String sessionId) {
        return this.manager.locate(sessionId);
    }

    public void start() {
        this.manager.start();
    }

    public void stop() {
        this.manager.stop();
    }

    public io.undertow.server.session.Session createSession(HttpServerExchange exchange, SessionConfig config) {
        if (config == null) {
            throw UndertowMessages.MESSAGES.couldNotFindSessionCookieConfig();
        }
        String id = this.findSessionId(exchange, config);
        if (id != null) {
            if (this.manager.containsSession(id)) {
                throw UndertowMessages.MESSAGES.sessionAlreadyExists(id);
            }
        } else {
            id = this.manager.createSessionId();
        }
        Batcher batcher = this.manager.getBatcher();
        boolean started = batcher.startBatch();
        try {
            Session session = this.manager.createSession(id);
            io.undertow.server.session.Session adapter = this.getSession((Session<Void>)session, exchange, config);
            this.sessionListeners.sessionCreated(adapter, exchange);
            return adapter;
        }
        catch (Error | RuntimeException e) {
            if (started) {
                batcher.endBatch(false);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public io.undertow.server.session.Session getSession(HttpServerExchange exchange, SessionConfig config) {
        String id = this.findSessionId(exchange, config);
        if (id == null) {
            return null;
        }
        Batcher batcher = this.manager.getBatcher();
        boolean started = batcher.startBatch();
        Session session = null;
        try {
            session = this.manager.findSession(id);
            io.undertow.server.session.Session session2 = session != null ? this.getSession((Session<Void>)session, exchange, config) : null;
            return session2;
        }
        finally {
            if (started && session == null) {
                batcher.endBatch(false);
            }
        }
    }

    private String findSessionId(HttpServerExchange exchange, SessionConfig config) {
        String id = config.findSessionId(exchange);
        return this.parse(id).getKey();
    }

    private io.undertow.server.session.Session getSession(Session<Void> session, HttpServerExchange exchange, SessionConfig config) {
        SessionAdapter adapter = new SessionAdapter(this, session, config);
        if (config != null) {
            String id = session.getId();
            String route = this.locate(id);
            config.setSessionId(exchange, route != null ? this.format(id, route) : id);
        }
        return adapter;
    }

    public void registerSessionListener(SessionListener listener) {
        this.sessionListeners.addSessionListener(listener);
    }

    public void removeSessionListener(SessionListener listener) {
        this.sessionListeners.removeSessionListener(listener);
    }

    public void setDefaultSessionTimeout(int timeout) {
        this.manager.setDefaultMaxInactiveInterval((long)timeout, TimeUnit.SECONDS);
    }

    public int activeSessions() {
        return this.manager.getActiveSessions().size();
    }

    public Set<String> getTransientSessions() {
        return Collections.emptySet();
    }

    public Set<String> getActiveSessions() {
        return this.manager.getActiveSessions();
    }

    public Set<String> getAllSessions() {
        return this.manager.getLocalSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public io.undertow.server.session.Session getSession(String sessionId) {
        Batcher batcher = this.manager.getBatcher();
        boolean started = batcher.startBatch();
        try {
            ImmutableSession session = this.manager.viewSession(sessionId);
            ImmutableSessionAdapter immutableSessionAdapter = session != null ? new ImmutableSessionAdapter(this, session) : null;
            return immutableSessionAdapter;
        }
        finally {
            if (started) {
                batcher.endBatch(false);
            }
        }
    }
}

