/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.action.spi.Executable;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Queryable;

public class BulkOperationCleanupAction
implements Executable,
Serializable {
    private final Serializable[] affectedTableSpaces;
    private final Set<EntityCleanup> entityCleanups = new HashSet<EntityCleanup>();
    private final Set<CollectionCleanup> collectionCleanups = new HashSet<CollectionCleanup>();
    private final Set<NaturalIdCleanup> naturalIdCleanups = new HashSet<NaturalIdCleanup>();

    public BulkOperationCleanupAction(SessionImplementor session, Queryable ... affectedQueryables) {
        SessionFactoryImplementor factory = session.getFactory();
        LinkedHashSet<String> spacesList = new LinkedHashSet<String>();
        for (Queryable persister : affectedQueryables) {
            Set<String> roles;
            spacesList.addAll(Arrays.asList((String[])persister.getQuerySpaces()));
            if (persister.hasCache()) {
                this.entityCleanups.add(new EntityCleanup(persister.getCacheAccessStrategy()));
            }
            if (persister.hasNaturalIdentifier() && persister.hasNaturalIdCache()) {
                this.naturalIdCleanups.add(new NaturalIdCleanup(persister.getNaturalIdCacheAccessStrategy()));
            }
            if ((roles = factory.getCollectionRolesByEntityParticipant(persister.getEntityName())) == null) continue;
            for (String role : roles) {
                CollectionPersister collectionPersister = factory.getCollectionPersister(role);
                if (!collectionPersister.hasCache()) continue;
                this.collectionCleanups.add(new CollectionCleanup(collectionPersister.getCacheAccessStrategy()));
            }
        }
        this.affectedTableSpaces = (Serializable[])spacesList.toArray(new String[spacesList.size()]);
    }

    public BulkOperationCleanupAction(SessionImplementor session, Set tableSpaces) {
        LinkedHashSet<String> spacesList = new LinkedHashSet<String>();
        spacesList.addAll(tableSpaces);
        SessionFactoryImplementor factory = session.getFactory();
        for (String entityName : factory.getAllClassMetadata().keySet()) {
            Set<String> roles;
            EntityPersister persister = factory.getEntityPersister(entityName);
            String[] entitySpaces = (String[])persister.getQuerySpaces();
            if (!this.affectedEntity(tableSpaces, (Serializable[])entitySpaces)) continue;
            spacesList.addAll(Arrays.asList(entitySpaces));
            if (persister.hasCache()) {
                this.entityCleanups.add(new EntityCleanup(persister.getCacheAccessStrategy()));
            }
            if (persister.hasNaturalIdentifier() && persister.hasNaturalIdCache()) {
                this.naturalIdCleanups.add(new NaturalIdCleanup(persister.getNaturalIdCacheAccessStrategy()));
            }
            if ((roles = session.getFactory().getCollectionRolesByEntityParticipant(persister.getEntityName())) == null) continue;
            for (String role : roles) {
                CollectionPersister collectionPersister = factory.getCollectionPersister(role);
                if (!collectionPersister.hasCache()) continue;
                this.collectionCleanups.add(new CollectionCleanup(collectionPersister.getCacheAccessStrategy()));
            }
        }
        this.affectedTableSpaces = (Serializable[])spacesList.toArray(new String[spacesList.size()]);
    }

    private boolean affectedEntity(Set affectedTableSpaces, Serializable[] checkTableSpaces) {
        if (affectedTableSpaces == null || affectedTableSpaces.isEmpty()) {
            return true;
        }
        for (Serializable checkTableSpace : checkTableSpaces) {
            if (!affectedTableSpaces.contains(checkTableSpace)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Serializable[] getPropertySpaces() {
        return this.affectedTableSpaces;
    }

    @Override
    public BeforeTransactionCompletionProcess getBeforeTransactionCompletionProcess() {
        return null;
    }

    @Override
    public AfterTransactionCompletionProcess getAfterTransactionCompletionProcess() {
        return new AfterTransactionCompletionProcess(){

            @Override
            public void doAfterTransactionCompletion(boolean success, SessionImplementor session) {
                for (Serializable cleanup : BulkOperationCleanupAction.this.entityCleanups) {
                    ((EntityCleanup)cleanup).release();
                }
                BulkOperationCleanupAction.this.entityCleanups.clear();
                for (Serializable cleanup : BulkOperationCleanupAction.this.naturalIdCleanups) {
                    ((NaturalIdCleanup)cleanup).release();
                }
                BulkOperationCleanupAction.this.entityCleanups.clear();
                for (Serializable cleanup : BulkOperationCleanupAction.this.collectionCleanups) {
                    ((CollectionCleanup)cleanup).release();
                }
                BulkOperationCleanupAction.this.collectionCleanups.clear();
            }
        };
    }

    @Override
    public void beforeExecutions() throws HibernateException {
    }

    @Override
    public void execute() throws HibernateException {
    }

    private static class NaturalIdCleanup
    implements Serializable {
        private final NaturalIdRegionAccessStrategy naturalIdCacheAccessStrategy;
        private final SoftLock cacheLock;

        public NaturalIdCleanup(NaturalIdRegionAccessStrategy naturalIdCacheAccessStrategy) {
            this.naturalIdCacheAccessStrategy = naturalIdCacheAccessStrategy;
            this.cacheLock = naturalIdCacheAccessStrategy.lockRegion();
            naturalIdCacheAccessStrategy.removeAll();
        }

        private void release() {
            this.naturalIdCacheAccessStrategy.unlockRegion(this.cacheLock);
        }
    }

    private static class CollectionCleanup
    implements Serializable {
        private final CollectionRegionAccessStrategy cacheAccess;
        private final SoftLock cacheLock;

        private CollectionCleanup(CollectionRegionAccessStrategy cacheAccess) {
            this.cacheAccess = cacheAccess;
            this.cacheLock = cacheAccess.lockRegion();
            cacheAccess.removeAll();
        }

        private void release() {
            this.cacheAccess.unlockRegion(this.cacheLock);
        }
    }

    private static class EntityCleanup
    implements Serializable {
        private final EntityRegionAccessStrategy cacheAccess;
        private final SoftLock cacheLock;

        private EntityCleanup(EntityRegionAccessStrategy cacheAccess) {
            this.cacheAccess = cacheAccess;
            this.cacheLock = cacheAccess.lockRegion();
            cacheAccess.removeAll();
        }

        private void release() {
            this.cacheAccess.unlockRegion(this.cacheLock);
        }
    }
}

