/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import java.util.Map;
import org.hibernate.Filter;
import org.hibernate.MappingException;
import org.hibernate.engine.FetchStyle;
import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.plan.spi.CollectionReference;
import org.hibernate.loader.plan.spi.EntityReference;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.spi.JoinableAssociation;
import org.hibernate.sql.JoinType;

public abstract class AbstractJoinableAssociationImpl
implements JoinableAssociation {
    private final PropertyPath propertyPath;
    private final Fetch currentFetch;
    private final EntityReference currentEntityReference;
    private final CollectionReference currentCollectionReference;
    private final JoinType joinType;
    private final String withClause;
    private final Map<String, Filter> enabledFilters;
    private final boolean hasRestriction;

    public AbstractJoinableAssociationImpl(Fetch currentFetch, EntityReference currentEntityReference, CollectionReference currentCollectionReference, String withClause, boolean hasRestriction, Map<String, Filter> enabledFilters) throws MappingException {
        this.propertyPath = currentFetch.getPropertyPath();
        this.joinType = currentFetch.getFetchStrategy().getStyle() == FetchStyle.JOIN ? (currentFetch.isNullable() ? JoinType.LEFT_OUTER_JOIN : JoinType.INNER_JOIN) : JoinType.NONE;
        this.currentFetch = currentFetch;
        this.currentEntityReference = currentEntityReference;
        this.currentCollectionReference = currentCollectionReference;
        this.withClause = withClause;
        this.hasRestriction = hasRestriction;
        this.enabledFilters = enabledFilters;
    }

    @Override
    public PropertyPath getPropertyPath() {
        return this.propertyPath;
    }

    @Override
    public JoinType getJoinType() {
        return this.joinType;
    }

    @Override
    public Fetch getCurrentFetch() {
        return this.currentFetch;
    }

    @Override
    public EntityReference getCurrentEntityReference() {
        return this.currentEntityReference;
    }

    @Override
    public CollectionReference getCurrentCollectionReference() {
        return this.currentCollectionReference;
    }

    @Override
    public boolean hasRestriction() {
        return this.hasRestriction;
    }

    @Override
    public String getWithClause() {
        return this.withClause;
    }

    @Override
    public Map<String, Filter> getEnabledFilters() {
        return this.enabledFilters;
    }
}

