/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.internal;

import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.plan.internal.LoadPlanImpl;
import org.hibernate.loader.plan.spi.CollectionReturn;
import org.hibernate.loader.plan.spi.EntityReturn;
import org.hibernate.loader.plan.spi.LoadPlan;
import org.hibernate.loader.plan.spi.Return;
import org.hibernate.loader.plan.spi.build.AbstractLoadPlanBuilderStrategy;
import org.hibernate.loader.plan.spi.build.LoadPlanBuilderStrategy;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.walking.spi.AssociationAttributeDefinition;
import org.hibernate.persister.walking.spi.CollectionDefinition;
import org.hibernate.persister.walking.spi.EntityDefinition;

public class SingleRootReturnLoadPlanBuilderStrategy
extends AbstractLoadPlanBuilderStrategy
implements LoadPlanBuilderStrategy {
    private final LoadQueryInfluencers loadQueryInfluencers;
    private Return rootReturn;
    private PropertyPath propertyPath = new PropertyPath("");

    public SingleRootReturnLoadPlanBuilderStrategy(SessionFactoryImplementor sessionFactory, LoadQueryInfluencers loadQueryInfluencers) {
        super(sessionFactory);
        this.loadQueryInfluencers = loadQueryInfluencers;
    }

    @Override
    protected boolean supportsRootEntityReturns() {
        return true;
    }

    @Override
    protected boolean supportsRootCollectionReturns() {
        return true;
    }

    @Override
    protected void addRootReturn(Return rootReturn) {
        if (this.rootReturn != null) {
            throw new HibernateException("Root return already identified");
        }
        this.rootReturn = rootReturn;
    }

    @Override
    public LoadPlan buildLoadPlan() {
        return new LoadPlanImpl(false, this.rootReturn);
    }

    @Override
    protected FetchStrategy determineFetchPlan(AssociationAttributeDefinition attributeDefinition) {
        FetchStrategy fetchStrategy = attributeDefinition.determineFetchPlan(this.loadQueryInfluencers, this.propertyPath);
        if (fetchStrategy.getTiming() == FetchTiming.IMMEDIATE && fetchStrategy.getStyle() == FetchStyle.JOIN) {
            fetchStrategy = this.adjustJoinFetchIfNeeded(attributeDefinition, fetchStrategy);
        }
        return fetchStrategy;
    }

    protected FetchStrategy adjustJoinFetchIfNeeded(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy) {
        if (this.currentDepth() > this.sessionFactory().getSettings().getMaximumFetchDepth()) {
            return new FetchStrategy(fetchStrategy.getTiming(), FetchStyle.SELECT);
        }
        if (attributeDefinition.getType().isCollectionType() && this.isTooManyCollections()) {
            return new FetchStrategy(fetchStrategy.getTiming(), FetchStyle.SELECT);
        }
        return fetchStrategy;
    }

    @Override
    protected boolean isTooManyCollections() {
        return false;
    }

    @Override
    protected EntityReturn buildRootEntityReturn(EntityDefinition entityDefinition) {
        String entityName = entityDefinition.getEntityPersister().getEntityName();
        return new EntityReturn(this.sessionFactory(), LockMode.NONE, entityName);
    }

    @Override
    protected CollectionReturn buildRootCollectionReturn(CollectionDefinition collectionDefinition) {
        CollectionPersister persister = collectionDefinition.getCollectionPersister();
        String collectionRole = persister.getRole();
        return new CollectionReturn(this.sessionFactory(), LockMode.NONE, persister.getOwnerEntityPersister().getEntityName(), StringHelper.unqualify(collectionRole));
    }
}

