/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import org.hibernate.engine.internal.JoinHelper;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.FetchOwnerDelegate;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;

public class EntityFetchOwnerDelegate
implements FetchOwnerDelegate {
    private final EntityPersister entityPersister;

    public EntityFetchOwnerDelegate(EntityPersister entityPersister) {
        this.entityPersister = entityPersister;
    }

    @Override
    public boolean isNullable(Fetch fetch) {
        return this.entityPersister.getPropertyNullability()[this.determinePropertyIndex(fetch)];
    }

    @Override
    public Type getType(Fetch fetch) {
        return this.entityPersister.getPropertyTypes()[this.determinePropertyIndex(fetch)];
    }

    @Override
    public String[] getColumnNames(Fetch fetch) {
        OuterJoinLoadable outerJoinLoadable = (OuterJoinLoadable)this.entityPersister;
        Type fetchType = this.getType(fetch);
        if (fetchType.isAssociationType()) {
            return JoinHelper.getLHSColumnNames((AssociationType)fetchType, this.determinePropertyIndex(fetch), outerJoinLoadable, outerJoinLoadable.getFactory());
        }
        return outerJoinLoadable.getPropertyColumnNames(this.determinePropertyIndex(fetch));
    }

    private int determinePropertyIndex(Fetch fetch) {
        return this.entityPersister.getEntityMetamodel().getPropertyIndex(fetch.getOwnerPropertyName());
    }
}

