/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Membership;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.MergeData;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Digest;
import org.jgroups.util.MergeId;
import org.jgroups.util.MutableDigest;
import org.jgroups.util.ResponseCollector;
import org.jgroups.util.Util;

public class Merger {
    private final GMS gms;
    private final Log log = LogFactory.getLog(this.getClass());
    private final MergeTask merge_task = new MergeTask();
    private final ResponseCollector<MergeData> merge_rsps = new ResponseCollector();
    private final ResponseCollector<Digest> digest_collector = new ResponseCollector();
    private final Lock merge_lock = new ReentrantLock();
    private MergeId merge_id = null;
    protected final BoundedList<MergeId> merge_id_history = new BoundedList(20);
    private Future<?> merge_killer = null;
    private final Lock merge_killer_lock = new ReentrantLock();

    public Merger(GMS gms) {
        this.gms = gms;
    }

    public String getMergeIdAsString() {
        return this.merge_id != null ? this.merge_id.toString() : null;
    }

    public String getMergeIdHistory() {
        return this.merge_id_history.toString();
    }

    public void merge(Map<Address, View> views) {
        if (this.isMergeInProgress()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.gms.local_addr + ": merge is already running (merge_id=" + this.merge_id + ")");
            }
            return;
        }
        Collection<Address> coords = Util.determineActualMergeCoords(views);
        if (coords.isEmpty()) {
            this.log.error(this.gms.local_addr + ": unable to determine merge leader from " + views + "; not starting a merge");
            return;
        }
        Membership tmp = new Membership(coords);
        tmp.sort();
        Address merge_leader = tmp.elementAt(0);
        if (merge_leader.equals(this.gms.local_addr)) {
            if (this.log.isDebugEnabled()) {
                Collection<Address> merge_participants = Util.determineMergeParticipants(views);
                this.log.debug("I (" + this.gms.local_addr + ") will be the leader. Starting the merge task for " + merge_participants.size() + " coords");
            }
            this.merge_task.start(views);
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("I (" + this.gms.local_addr + ") am not the merge leader, " + "waiting for merge leader (" + merge_leader + ") to initiate merge");
        }
    }

    public void handleMergeRequest(Address sender, MergeId merge_id, Collection<? extends Address> mbrs) {
        try {
            this._handleMergeRequest(sender, merge_id, mbrs);
        }
        catch (Throwable t) {
            this.cancelMerge(merge_id);
            this.sendMergeRejectedResponse(sender, merge_id);
        }
    }

    protected void _handleMergeRequest(Address sender, MergeId merge_id, Collection<? extends Address> mbrs) throws Exception {
        ViewId tmp_vid;
        boolean success;
        boolean bl = success = this.matchMergeId(merge_id) || this.setMergeId(null, merge_id);
        if (!success) {
            throw new Exception("merge " + this.merge_id + " is already in progress, received merge-id=" + merge_id);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.gms.local_addr + ": got merge request from " + sender + ", merge_id=" + merge_id + ", mbrs=" + mbrs);
        }
        LinkedList<Address> members = new LinkedList<Address>();
        if (mbrs != null) {
            for (Address address : mbrs) {
                if (members.contains(address)) continue;
                members.add(address);
            }
        }
        if ((tmp_vid = this.gms.getViewId()) != null) {
            tmp_vid = tmp_vid.copy();
        }
        if (tmp_vid == null) {
            throw new Exception("view ID is null; cannot return merge response");
        }
        View view = new View(tmp_vid, new ArrayList<Address>(members));
        if (this.gms.flushProtocolInStack && !this.gms.startFlush(view)) {
            throw new Exception("flush failed");
        }
        Digest digest = this.fetchDigestsFromAllMembersInSubPartition(members, merge_id);
        if (digest == null || digest.size() == 0) {
            throw new Exception("failed fetching digests from subpartition members; dropping merge response");
        }
        this.sendMergeResponse(sender, view, digest, merge_id);
    }

    public void handleMergeResponse(MergeData data, MergeId merge_id) {
        if (!this.matchMergeId(merge_id)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.gms.local_addr + ": this.merge_id (" + this.merge_id + ") is different from merge_id " + merge_id + " sent by " + data.getSender() + " as merge response, discarding it");
            }
            return;
        }
        this.merge_rsps.add(data.getSender(), data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMergeView(MergeData data, MergeId merge_id) {
        if (!this.matchMergeId(merge_id)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.gms.local_addr + ": merge_ids (mine: " + this.merge_id + ", received: " + merge_id + ") don't match; merge view " + data.view.getViewId() + " is discarded");
            }
            return;
        }
        ArrayList<Address> newViewMembers = new ArrayList<Address>(data.view.getMembers());
        newViewMembers.removeAll(this.gms.members.getMembers());
        try {
            this.gms.castViewChange(data.view, data.digest, null, newViewMembers);
            if (this.gms.flushProtocolInStack) {
                Message ack = new Message(data.getSender()).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL);
                GMS.GmsHeader ack_hdr = new GMS.GmsHeader(12);
                ack.putHeader(this.gms.getId(), ack_hdr);
                this.gms.getDownProtocol().down(new Event(1, ack));
            }
        }
        finally {
            this.cancelMerge(merge_id);
        }
    }

    public void handleMergeCancelled(MergeId merge_id) {
        try {
            this.gms.stopFlush();
        }
        catch (Throwable t) {
            this.log.error("stop flush failed", t);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.gms.local_addr + ": merge " + merge_id + " is cancelled");
        }
        this.cancelMerge(merge_id);
    }

    public void handleDigestResponse(Address sender, Digest digest) {
        this.digest_collector.add(sender, digest);
    }

    public static void sanitizeViews(Map<Address, View> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<Address, View> entry : map.entrySet()) {
            Address key = entry.getKey();
            ArrayList<Address> members = new ArrayList<Address>(entry.getValue().getMembers());
            boolean modified = false;
            Iterator it = members.iterator();
            while (it.hasNext()) {
                View view;
                List<Address> tmp_mbrs;
                Address val = (Address)it.next();
                if (val.equals(key) || (tmp_mbrs = (view = map.get(val)) != null ? view.getMembers() : null) == null || tmp_mbrs.contains(key)) continue;
                it.remove();
                modified = true;
            }
            if (!modified) continue;
            View old_view = entry.getValue();
            entry.setValue(new View(old_view.getVid(), members));
        }
    }

    private void sendMergeResponse(Address sender, View view, Digest digest, MergeId merge_id) {
        Message msg = new Message(sender).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL);
        GMS.GmsHeader hdr = new GMS.GmsHeader(7);
        hdr.merge_id = merge_id;
        hdr.view = view;
        hdr.my_digest = digest;
        msg.putHeader(this.gms.getId(), hdr);
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.gms.local_addr + ": sending merge response=" + hdr);
        }
        this.gms.getDownProtocol().down(new Event(1, msg));
    }

    private void sendMergeView(Collection<Address> coords, MergeData combined_merge_data, MergeId merge_id) {
        if (coords == null || combined_merge_data == null) {
            return;
        }
        View view = combined_merge_data.view;
        Digest digest = combined_merge_data.digest;
        if (view == null || digest == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("view or digest is null, cannot send consolidated merge view/digest");
            }
            return;
        }
        int size = 0;
        if (this.gms.flushProtocolInStack) {
            this.gms.merge_ack_collector.reset(coords);
            size = this.gms.merge_ack_collector.size();
        }
        long start = System.currentTimeMillis();
        for (Address coord : coords) {
            Message msg = new Message(coord);
            GMS.GmsHeader hdr = new GMS.GmsHeader(8);
            hdr.view = view;
            hdr.my_digest = digest;
            hdr.merge_id = merge_id;
            msg.putHeader(this.gms.getId(), hdr);
            this.gms.getDownProtocol().down(new Event(1, msg));
        }
        if (this.gms.flushProtocolInStack) {
            try {
                this.gms.merge_ack_collector.waitForAllAcks(this.gms.view_ack_collection_timeout);
                if (this.log.isTraceEnabled()) {
                    this.log.trace(this.gms.local_addr + ": received all ACKs (" + size + ") for merge view " + view + " in " + (System.currentTimeMillis() - start) + "ms");
                }
            }
            catch (TimeoutException e) {
                this.log.warn(this.gms.local_addr + ": failed to collect all ACKs (" + size + ") for merge view " + view + " after " + this.gms.view_ack_collection_timeout + "ms, missing ACKs from " + this.gms.merge_ack_collector.printMissing());
            }
        }
    }

    protected void sendMergeRejectedResponse(Address sender, MergeId merge_id) {
        Message msg = new Message(sender).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL);
        GMS.GmsHeader hdr = new GMS.GmsHeader(7);
        hdr.merge_rejected = true;
        hdr.merge_id = merge_id;
        msg.putHeader(this.gms.getId(), hdr);
        this.gms.getDownProtocol().down(new Event(1, msg));
    }

    private void sendMergeCancelledMessage(Collection<Address> coords, MergeId merge_id) {
        if (coords == null || merge_id == null) {
            return;
        }
        for (Address coord : coords) {
            Message msg = new Message(coord);
            GMS.GmsHeader hdr = new GMS.GmsHeader(9);
            hdr.merge_id = merge_id;
            msg.putHeader(this.gms.getId(), hdr);
            this.gms.getDownProtocol().down(new Event(1, msg));
        }
    }

    private Digest fetchDigestsFromAllMembersInSubPartition(List<Address> current_mbrs, MergeId merge_id) {
        if (current_mbrs == null || current_mbrs.size() == 1 && current_mbrs.get(0).equals(this.gms.local_addr)) {
            return (Digest)this.gms.getDownProtocol().down(new Event(39, this.gms.local_addr));
        }
        GMS.GmsHeader hdr = new GMS.GmsHeader(13);
        hdr.merge_id = merge_id;
        Message get_digest_req = new Message().setFlag(Message.Flag.OOB, Message.Flag.INTERNAL).putHeader(this.gms.getId(), hdr);
        long max_wait_time = this.gms.merge_timeout / 2L;
        this.digest_collector.reset(current_mbrs);
        this.gms.getDownProtocol().down(new Event(1, get_digest_req));
        Digest digest = (Digest)this.gms.getDownProtocol().down(new Event(39, this.gms.local_addr));
        this.digest_collector.add(this.gms.local_addr, digest);
        this.digest_collector.waitForAllResponses(max_wait_time);
        if (this.log.isTraceEnabled()) {
            if (this.digest_collector.hasAllResponses()) {
                this.log.trace(this.gms.local_addr + ": fetched all digests for " + current_mbrs);
            } else {
                this.log.trace(this.gms.local_addr + ": fetched incomplete digests (after timeout of " + max_wait_time + ") ms for " + current_mbrs);
            }
        }
        HashMap<Address, Digest> responses = new HashMap<Address, Digest>(this.digest_collector.getResults());
        MutableDigest retval = new MutableDigest(responses.size());
        for (Digest dig : responses.values()) {
            if (dig == null) continue;
            retval.add(dig);
        }
        return retval;
    }

    void fixDigests() {
        Digest digest = this.fetchDigestsFromAllMembersInSubPartition(this.gms.view.getMembers(), null);
        Message msg = new Message();
        GMS.GmsHeader hdr = new GMS.GmsHeader(15);
        hdr.my_digest = digest;
        msg.putHeader(this.gms.getId(), hdr);
        this.gms.getDownProtocol().down(new Event(1, msg));
    }

    void stop() {
        this.merge_task.stop();
    }

    void cancelMerge(MergeId id) {
        if (this.setMergeId(id, null)) {
            this.merge_task.stop();
            this.stopMergeKiller();
            this.merge_rsps.reset();
            this.gms.getViewHandler().resume();
            this.gms.getDownProtocol().down(new Event(66));
        }
    }

    boolean isMergeTaskRunning() {
        return this.merge_task.isRunning();
    }

    boolean isMergeKillerTaskRunning() {
        return this.merge_killer != null && !this.merge_killer.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceCancelMerge() {
        this.merge_lock.lock();
        try {
            if (this.merge_id != null) {
                this.cancelMerge(this.merge_id);
            }
        }
        finally {
            this.merge_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setMergeId(MergeId expected, MergeId new_value) {
        this.merge_lock.lock();
        try {
            boolean match = Util.match(this.merge_id, expected);
            if (match) {
                if (new_value != null && this.merge_id_history.contains(new_value)) {
                    boolean bl = false;
                    return bl;
                }
                this.merge_id_history.add(new_value);
                this.merge_id = new_value;
                if (this.merge_id != null) {
                    this.gms.getViewHandler().suspend();
                    this.gms.getDownProtocol().down(new Event(65, 20000));
                    this.startMergeKiller();
                }
            }
            boolean bl = match;
            return bl;
        }
        finally {
            this.merge_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MergeId getMergeId() {
        this.merge_lock.lock();
        try {
            MergeId mergeId = this.merge_id;
            return mergeId;
        }
        finally {
            this.merge_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMergeInProgress() {
        this.merge_lock.lock();
        try {
            boolean bl = this.merge_id != null;
            return bl;
        }
        finally {
            this.merge_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matchMergeId(MergeId id) {
        this.merge_lock.lock();
        try {
            boolean bl = Util.match(this.merge_id, id);
            return bl;
        }
        finally {
            this.merge_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMergeKiller() {
        this.merge_killer_lock.lock();
        try {
            if (this.merge_killer == null || this.merge_killer.isDone()) {
                MergeKiller task = new MergeKiller(this.merge_id);
                this.merge_killer = this.gms.timer.schedule(task, this.gms.merge_timeout * 2L, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.merge_killer_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMergeKiller() {
        this.merge_killer_lock.lock();
        try {
            if (this.merge_killer != null) {
                this.merge_killer.cancel(false);
                this.merge_killer = null;
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this.merge_killer_lock.unlock();
        }
    }

    private class MergeKiller
    implements Runnable {
        private final MergeId my_merge_id;

        MergeKiller(MergeId my_merge_id) {
            this.my_merge_id = my_merge_id;
        }

        @Override
        public void run() {
            Merger.this.cancelMerge(this.my_merge_id);
        }

        public String toString() {
            return Merger.class.getSimpleName() + ": " + this.getClass().getSimpleName();
        }
    }

    class MergeTask
    implements Runnable {
        private Thread thread = null;
        private final ConcurrentMap<Address, Collection<Address>> coords = Util.createConcurrentMap(8, 0.75f, 8);

        MergeTask() {
        }

        public synchronized void start(Map<Address, View> views) {
            if (this.thread != null && this.thread.isAlive()) {
                return;
            }
            this.coords.clear();
            Merger.sanitizeViews(views);
            Collection<Address> coordinators = Util.determineMergeCoords(views);
            for (Address coord : coordinators) {
                View view = views.get(coord);
                if (view == null) continue;
                this.coords.put(coord, new ArrayList<Address>(view.getMembers()));
            }
            Collection<Address> merge_participants = Util.determineMergeParticipants(views);
            merge_participants.removeAll(coordinators);
            for (Address merge_participant : merge_participants) {
                ArrayList<Address> tmp = new ArrayList<Address>();
                tmp.add(merge_participant);
                this.coords.putIfAbsent(merge_participant, tmp);
            }
            this.thread = Merger.this.gms.getThreadFactory().newThread(this, "MergeTask");
            this.thread.setDaemon(true);
            this.thread.start();
        }

        public synchronized void stop() {
            Thread tmp = this.thread;
            if (this.thread != null && this.thread.isAlive()) {
                tmp.interrupt();
            }
            this.thread = null;
        }

        public synchronized boolean isRunning() {
            return this.thread != null && this.thread.isAlive();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MergeId new_merge_id = MergeId.create(((Merger)Merger.this).gms.local_addr);
            ArrayList<Address> coordsCopy = new ArrayList<Address>(this.coords.keySet());
            long start = System.currentTimeMillis();
            try {
                this._run(new_merge_id, coordsCopy);
            }
            catch (Throwable ex) {
                if (Merger.this.log.isWarnEnabled()) {
                    Merger.this.log.warn(((Merger)Merger.this).gms.local_addr + ": " + ex + ", merge is cancelled");
                }
                Merger.this.sendMergeCancelledMessage(coordsCopy, new_merge_id);
                Merger.this.cancelMerge(new_merge_id);
            }
            finally {
                if (((Merger)Merger.this).gms.flushProtocolInStack) {
                    Merger.this.gms.stopFlush();
                }
                this.thread = null;
            }
            long diff = System.currentTimeMillis() - start;
            if (Merger.this.log.isDebugEnabled()) {
                Merger.this.log.debug(((Merger)Merger.this).gms.local_addr + ": merge " + new_merge_id + " took " + diff + " ms");
            }
        }

        protected void _run(MergeId new_merge_id, Collection<Address> coordsCopy) throws Exception {
            boolean success = Merger.this.setMergeId(null, new_merge_id);
            if (!success) {
                Merger.this.log.warn("failed to set my own merge_id (" + Merger.this.merge_id + ") to " + new_merge_id);
                return;
            }
            if (Merger.this.log.isDebugEnabled()) {
                Merger.this.log.debug(((Merger)Merger.this).gms.local_addr + ": merge task " + Merger.this.merge_id + " started with " + this.coords.keySet().size() + " coords");
            }
            success = this.getMergeDataFromSubgroupCoordinators(this.coords, new_merge_id, ((Merger)Merger.this).gms.merge_timeout);
            List<Address> missing = null;
            if (!success) {
                missing = Merger.this.merge_rsps.getMissing();
                if (Merger.this.log.isDebugEnabled()) {
                    Merger.this.log.debug("merge leader " + ((Merger)Merger.this).gms.local_addr + " did not get responses from all " + this.coords.keySet().size() + " partition coordinators; missing responses from " + missing.size() + " members, removing them from the merge");
                }
                Merger.this.merge_rsps.remove(missing);
            }
            if (missing != null && !missing.isEmpty()) {
                this.coords.keySet().removeAll(missing);
                coordsCopy.removeAll(missing);
            }
            this.removeRejectedMergeRequests(this.coords.keySet());
            if (Merger.this.merge_rsps.size() == 0) {
                throw new Exception("did not get any merge responses from partition coordinators");
            }
            if (!this.coords.keySet().contains(((Merger)Merger.this).gms.local_addr)) {
                throw new Exception("merge leader rejected merge request");
            }
            ArrayList<MergeData> merge_data = new ArrayList<MergeData>(Merger.this.merge_rsps.getResults().values());
            MergeData combined_merge_data = this.consolidateMergeData(merge_data);
            if (combined_merge_data == null) {
                throw new Exception("could not consolidate merge");
            }
            if (Merger.this.log.isDebugEnabled()) {
                Merger.this.log.debug(((Merger)Merger.this).gms.local_addr + ": installing merge view " + combined_merge_data.view.getViewId() + " (" + combined_merge_data.view.size() + " members) in " + this.coords.keySet().size() + " coords");
            }
            Merger.this.sendMergeView(this.coords.keySet(), combined_merge_data, new_merge_id);
        }

        protected boolean getMergeDataFromSubgroupCoordinators(Map<Address, Collection<Address>> coords, MergeId new_merge_id, long timeout) {
            long start = System.currentTimeMillis();
            Merger.this.merge_rsps.reset(coords.keySet());
            if (Merger.this.log.isTraceEnabled()) {
                Merger.this.log.trace(((Merger)Merger.this).gms.local_addr + ": sending MERGE_REQ to " + coords.keySet());
            }
            for (Map.Entry<Address, Collection<Address>> entry : coords.entrySet()) {
                Address coord = entry.getKey();
                Collection<Address> mbrs = entry.getValue();
                Message msg = new Message(coord).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL);
                GMS.GmsHeader hdr = new GMS.GmsHeader(6, mbrs);
                hdr.mbr = ((Merger)Merger.this).gms.local_addr;
                hdr.merge_id = new_merge_id;
                msg.putHeader(Merger.this.gms.getId(), hdr);
                Merger.this.gms.getDownProtocol().down(new Event(1, msg));
            }
            Merger.this.merge_rsps.waitForAllResponses(timeout);
            boolean gotAllResponses = Merger.this.merge_rsps.hasAllResponses();
            long stop = System.currentTimeMillis();
            if (Merger.this.log.isTraceEnabled()) {
                Merger.this.log.trace(((Merger)Merger.this).gms.local_addr + ": collected " + Merger.this.merge_rsps.numberOfValidResponses() + " merge response(s) in " + (stop - start) + " ms");
            }
            return gotAllResponses;
        }

        private void removeRejectedMergeRequests(Collection<Address> coords) {
            int num_removed = 0;
            Iterator it = Merger.this.merge_rsps.getResults().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                MergeData data = (MergeData)entry.getValue();
                if (!data.merge_rejected) continue;
                if (data.getSender() != null) {
                    coords.remove(data.getSender());
                }
                it.remove();
                ++num_removed;
            }
            if (num_removed > 0 && Merger.this.log.isTraceEnabled()) {
                Merger.this.log.trace(((Merger)Merger.this).gms.local_addr + ": removed " + num_removed + " rejected merge responses");
            }
        }

        private MergeData consolidateMergeData(List<MergeData> merge_rsps) {
            Address new_coord;
            long logical_time = 0L;
            Membership new_mbrs = new Membership();
            ArrayList<View> subgroups = new ArrayList<View>(11);
            for (MergeData tmp_data : merge_rsps) {
                View tmp_view = tmp_data.getView();
                if (tmp_view == null) continue;
                ViewId tmp_vid = tmp_view.getVid();
                if (tmp_vid != null) {
                    logical_time = Math.max(logical_time, tmp_vid.getId());
                }
                new_mbrs.add(tmp_view.getMembers());
                subgroups.add(tmp_view.copy());
            }
            Digest new_digest = this.consolidateDigests(merge_rsps, merge_rsps.size());
            if (new_digest == null) {
                return null;
            }
            new_mbrs.retainAll(new_digest.getMembers());
            new_mbrs.sort();
            Address address = new_coord = new_mbrs.size() > 0 ? new_mbrs.elementAt(0) : null;
            if (new_coord == null) {
                return null;
            }
            ViewId new_vid = new ViewId(new_coord, logical_time + 1L);
            MergeView new_view = new MergeView(new_vid, new_mbrs.getMembers(), subgroups);
            if (Merger.this.log.isTraceEnabled()) {
                Merger.this.log.trace(((Merger)Merger.this).gms.local_addr + ": consolidated view=" + new_view + "\nconsolidated digest=" + new_digest);
            }
            return new MergeData(((Merger)Merger.this).gms.local_addr, new_view, new_digest);
        }

        private Digest consolidateDigests(List<MergeData> merge_rsps, int num_mbrs) {
            MutableDigest retval = new MutableDigest(num_mbrs);
            for (MergeData data : merge_rsps) {
                Digest tmp_digest = data.getDigest();
                if (tmp_digest == null) continue;
                retval.merge(tmp_digest);
            }
            return retval.copy();
        }
    }
}

