/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.List;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.JGroupsLogger;
import org.jboss.as.clustering.jgroups.ProtocolDefaults;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemRootResource;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemRootResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolDefaultsService;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class JGroupsSubsystemAdd
extends AbstractAddStepHandler {
    public static final JGroupsSubsystemAdd INSTANCE = new JGroupsSubsystemAdd();

    static ModelNode createOperation(ModelNode address, ModelNode existing) throws OperationFailedException {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        JGroupsSubsystemAdd.populate(existing, operation);
        return operation;
    }

    protected Resource createResource(OperationContext context) {
        assert (context.getServiceRegistry(false) != null);
        JGroupsSubsystemRootResource resource = new JGroupsSubsystemRootResource();
        resource.setRegistry(context.getServiceRegistry(false));
        context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)resource);
        return resource;
    }

    private static void populate(ModelNode source, ModelNode target) throws OperationFailedException {
        JGroupsSubsystemRootResourceDefinition.DEFAULT_STACK.validateAndSet(source, target);
        target.get("stack").setEmptyObject();
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        JGroupsSubsystemAdd.populate(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        this.installRuntimeServices(context, operation, model, verificationHandler, newControllers);
    }

    protected void installRuntimeServices(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        JGroupsLogger.ROOT_LOGGER.activatingSubsystem();
        ServiceTarget target = context.getServiceTarget();
        ServiceController<ProtocolDefaults> pdsController = this.installProtocolDefaultsService(target, verificationHandler);
        if (newControllers != null) {
            newControllers.add(pdsController);
        }
        String stack = JGroupsSubsystemRootResourceDefinition.DEFAULT_STACK.resolveModelAttribute(context, model).asString();
        ServiceController<ChannelFactory> dcfsController = this.installDefaultChannelFactoryService(target, stack, verificationHandler);
        if (newControllers != null) {
            newControllers.add(dcfsController);
        }
    }

    protected ServiceController<ProtocolDefaults> installProtocolDefaultsService(ServiceTarget target, ServiceVerificationHandler verificationHandler) {
        return AsynchronousService.addService((ServiceTarget)target, (ServiceName)ProtocolDefaultsService.SERVICE_NAME, (Service)new ProtocolDefaultsService()).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    protected ServiceController<ChannelFactory> installDefaultChannelFactoryService(ServiceTarget target, String stack, ServiceVerificationHandler verificationHandler) {
        InjectedValue factory = new InjectedValue();
        return target.addService(ChannelFactoryService.getServiceName(null), (Service)new ValueService((Value)factory)).addDependency(ChannelFactoryService.getServiceName(stack), ChannelFactory.class, (Injector)factory).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }
}

