/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.CanonicalPathHandler;
import io.undertow.server.handlers.NameVirtualHostHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.error.SimpleErrorPageHandler;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.AbstractListenerService;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.UndertowLogger;
import org.wildfly.extension.undertow.UndertowService;

public class Server
implements Service<Server> {
    private final String defaultHost;
    private final String name;
    private final NameVirtualHostHandler virtualHostHandler = new NameVirtualHostHandler();
    private final InjectedValue<ServletContainerService> servletContainer = new InjectedValue();
    private final InjectedValue<UndertowService> undertowService = new InjectedValue();
    private volatile HttpHandler root;
    private final List<AbstractListenerService<?>> listeners = new LinkedList();
    private final Set<Host> hosts = new CopyOnWriteArraySet<Host>();

    protected Server(String name, String defaultHost) {
        this.name = name;
        this.defaultHost = defaultHost;
    }

    public void start(StartContext startContext) throws StartException {
        this.root = this.virtualHostHandler;
        this.root = new SimpleErrorPageHandler(this.root);
        this.root = new CanonicalPathHandler(this.root);
        UndertowLogger.ROOT_LOGGER.infof("Starting server server service: %s", startContext.getController().getName());
        ((UndertowService)this.undertowService.getValue()).registerServer(this);
    }

    protected void registerListener(AbstractListenerService<?> listener) {
        this.listeners.add(listener);
        if (listener.isSecure()) {
            SocketBinding binding = (SocketBinding)listener.getBinding().getValue();
            ((ServletContainerService)this.servletContainer.getValue()).registerSecurePort(listener.getName(), binding.getSocketAddress().getPort());
        }
    }

    protected void unregisterListener(AbstractListenerService<?> listener) {
        this.listeners.add(listener);
        if (listener.isSecure()) {
            ((ServletContainerService)this.servletContainer.getValue()).unregisterSecurePort(listener.getName());
        }
    }

    protected void registerHost(Host host) {
        this.hosts.add(host);
        for (String hostName : host.getAllAliases()) {
            this.virtualHostHandler.addHost(hostName, host.getRootHandler());
        }
        if (host.getName().equals(this.getDefaultHost())) {
            this.virtualHostHandler.setDefaultHandler(host.getRootHandler());
        }
    }

    protected void unregisterHost(Host host) {
        for (String hostName : host.getAllAliases()) {
            this.virtualHostHandler.removeHost(hostName);
            this.hosts.remove(host);
        }
        if (host.getName().equals(this.getDefaultHost())) {
            this.virtualHostHandler.setDefaultHandler((HttpHandler)ResponseCodeHandler.HANDLE_404);
        }
    }

    public void stop(StopContext stopContext) {
        ((UndertowService)this.undertowService.getValue()).unregisterServer(this);
    }

    public Server getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    protected InjectedValue<ServletContainerService> getServletContainer() {
        return this.servletContainer;
    }

    protected HttpHandler getRoot() {
        return this.root;
    }

    protected InjectedValue<UndertowService> getUndertowService() {
        return this.undertowService;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultHost() {
        return this.defaultHost;
    }

    public Set<Host> getHosts() {
        return Collections.unmodifiableSet(this.hosts);
    }

    public List<AbstractListenerService<?>> getListeners() {
        return this.listeners;
    }
}

