/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ServiceLoader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.ParserContext;
import org.infinispan.util.FileLookup;
import org.infinispan.util.FileLookupFactory;
import org.infinispan.util.Util;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLMapper;

public class ParserRegistry {
    private final XMLMapper xmlMapper = XMLMapper.Factory.create();
    private final WeakReference<ClassLoader> cl;

    public ParserRegistry(ClassLoader classLoader) {
        this.cl = new WeakReference<ClassLoader>(classLoader);
        ServiceLoader<ConfigurationParser> parsers = ServiceLoader.load(ConfigurationParser.class, (ClassLoader)this.cl.get());
        for (ConfigurationParser parser : parsers) {
            for (Namespace ns : parser.getSupportedNamespaces()) {
                this.xmlMapper.registerRootElement(new QName(ns.getUri(), ns.getRootElement()), (XMLElementReader)parser);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationBuilderHolder parseFile(String filename) throws IOException {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        InputStream is = fileLookup.lookupFile(filename, (ClassLoader)this.cl.get());
        if (is == null) {
            throw new FileNotFoundException(filename);
        }
        try {
            ConfigurationBuilderHolder configurationBuilderHolder = this.parse(is);
            return configurationBuilderHolder;
        }
        finally {
            Util.close((Closeable)is);
        }
    }

    public ConfigurationBuilderHolder parse(InputStream is) {
        try {
            BufferedInputStream input = new BufferedInputStream(is);
            XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(input);
            ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder((ClassLoader)this.cl.get());
            this.xmlMapper.parseDocument((Object)holder, streamReader);
            streamReader.close();
            for (ParserContext parserContext : holder.getParserContexts().values()) {
                parserContext.fireParsingComplete();
            }
            return holder;
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }
}

