/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.RepeatableReadEntry;
import org.infinispan.container.entries.versioned.Versioned;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.InequalVersionComparisonResult;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusteredRepeatableReadEntry
extends RepeatableReadEntry
implements Versioned {
    private static final Log log = LogFactory.getLog(ClusteredRepeatableReadEntry.class);

    public ClusteredRepeatableReadEntry(Object key, Object value, Metadata metadata) {
        super(key, value, metadata);
    }

    public boolean performWriteSkewCheck(DataContainer container, TxInvocationContext ctx, boolean previousRead) {
        EntryVersion prevVersion;
        InternalCacheEntry ice = container.get(this.key);
        EntryVersion version = this.metadata.version();
        if (ice == null) {
            log.tracef("No entry for key %s found in data container", this.key);
            prevVersion = ctx.getCacheTransaction().getLookedUpRemoteVersion(this.key);
            if (prevVersion == null) {
                log.tracef("No looked up remote version for key %s found in context", this.key);
                return version == null;
            }
        } else {
            prevVersion = ice.getMetadata().version();
            if (prevVersion == null) {
                throw new IllegalStateException("Entries cannot have null versions!");
            }
        }
        if (log.isTraceEnabled()) {
            log.tracef("Is going to compare versions %s and %s for key %s. Was previously read? %s", new Object[]{prevVersion, version, this.key, previousRead});
        }
        if (version == null) {
            return !previousRead;
        }
        log.tracef("Comparing versions %s and %s for key %s: %s", new Object[]{prevVersion, version, this.key, prevVersion.compareTo(version)});
        return InequalVersionComparisonResult.AFTER != prevVersion.compareTo(version);
    }

    @Override
    public EntryVersion getVersion() {
        return this.metadata.version();
    }

    @Override
    public void setVersion(EntryVersion version) {
        this.metadata = this.metadata.builder().version(version).build();
    }
}

