/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.impl.AbstractTxInvocationContext;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.AbstractCacheTransaction;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.CollectionFactory;
import org.infinispan.util.InfinispanCollections;

public class LocalTxInvocationContext
extends AbstractTxInvocationContext {
    public final Map<Object, CacheEntry> emptyEntryMap;
    private LocalTransaction localTransaction;

    public LocalTxInvocationContext(Equivalence<Object> keyEq) {
        this.emptyEntryMap = CollectionFactory.makeMap(0, keyEq, AnyEquivalence.getInstance());
    }

    @Override
    public boolean isTransactionValid() {
        Transaction t = this.getTransaction();
        int status = -1;
        if (t != null) {
            try {
                status = t.getStatus();
            }
            catch (SystemException systemException) {
                // empty catch block
            }
        }
        return status == 0 || status == 7;
    }

    @Override
    public boolean isOriginLocal() {
        return true;
    }

    @Override
    public Object getLockOwner() {
        return this.localTransaction.getGlobalTransaction();
    }

    @Override
    public GlobalTransaction getGlobalTransaction() {
        return this.localTransaction.getGlobalTransaction();
    }

    @Override
    public List<WriteCommand> getModifications() {
        return this.localTransaction == null ? null : this.localTransaction.getModifications();
    }

    public void setLocalTransaction(LocalTransaction localTransaction) {
        this.localTransaction = localTransaction;
    }

    @Override
    public CacheEntry lookupEntry(Object key) {
        return this.localTransaction != null ? this.localTransaction.lookupEntry(key) : null;
    }

    @Override
    public Map<Object, CacheEntry> getLookedUpEntries() {
        return this.localTransaction != null ? this.localTransaction.getLookedUpEntries() : this.emptyEntryMap;
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        this.localTransaction.putLookedUpEntry(key, e);
    }

    @Override
    public void putLookedUpEntries(Map<Object, CacheEntry> lookedUpEntries) {
        this.localTransaction.putLookedUpEntries(lookedUpEntries);
    }

    @Override
    public void removeLookedUpEntry(Object key) {
        this.localTransaction.removeLookedUpEntry(key);
    }

    @Override
    public void clearLookedUpEntries() {
        this.localTransaction.clearLookedUpEntries();
    }

    @Override
    public boolean hasLockedKey(Object key) {
        return this.localTransaction != null && this.localTransaction.ownsLock(key);
    }

    public void remoteLocksAcquired(Collection<Address> nodes) {
        this.localTransaction.locksAcquired(nodes);
    }

    public Collection<Address> getRemoteLocksAcquired() {
        return this.localTransaction.getRemoteLocksAcquired();
    }

    @Override
    public AbstractCacheTransaction getCacheTransaction() {
        return this.localTransaction;
    }

    @Override
    public Set<Object> getLockedKeys() {
        return this.localTransaction == null ? InfinispanCollections.emptySet() : this.localTransaction.getLockedKeys();
    }

    @Override
    public void addLockedKey(Object key) {
        this.localTransaction.registerLockedKey(key);
    }

    @Override
    public Transaction getTransaction() {
        Transaction tx = super.getTransaction();
        return tx == null ? this.localTransaction.getTransaction() : tx;
    }
}

