/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.Closeable;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import org.infinispan.CacheConfigurationException;
import org.infinispan.CacheException;
import org.infinispan.commons.hash.Hash;
import org.infinispan.marshall.Marshaller;
import org.infinispan.util.SysPropertyActions;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class Util {
    private static final boolean IS_ARRAYS_DEBUG = Boolean.getBoolean("infinispan.arrays.debug");
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final Log log = LogFactory.getLog(Util.class);
    private static final String javaVendor = SysPropertyActions.getProperty("java.vendor", "");
    private static String INDENT = "    ";
    static final String HEX_VALUES = "0123456789ABCDEF";

    public static <T> Class<T> loadClass(String classname, ClassLoader cl) {
        try {
            return Util.loadClassStrict(classname, cl);
        }
        catch (ClassNotFoundException e) {
            throw new CacheConfigurationException("Unable to instantiate class " + classname, e);
        }
    }

    public static ClassLoader[] getClassLoaders(ClassLoader appClassLoader) {
        return new ClassLoader[]{appClassLoader, Util.class.getClassLoader(), ClassLoader.getSystemClassLoader()};
    }

    public static <T> Class<T> loadClassStrict(String classname, ClassLoader userClassLoader) throws ClassNotFoundException {
        Object[] cls = Util.getClassLoaders(userClassLoader);
        ClassNotFoundException e = null;
        NoClassDefFoundError ne = null;
        for (ClassLoader classLoader : cls) {
            if (classLoader == null) continue;
            try {
                return Class.forName(classname, true, classLoader);
            }
            catch (ClassNotFoundException ce) {
                e = ce;
            }
            catch (NoClassDefFoundError ce) {
                ne = ce;
            }
        }
        if (e != null) {
            throw e;
        }
        if (ne != null) {
            log.unableToLoadClass(classname, Arrays.toString(cls), ne);
            throw new ClassNotFoundException(classname, ne);
        }
        throw new IllegalStateException();
    }

    private static Method getFactoryMethod(Class<?> c) {
        for (Method m : c.getMethods()) {
            if (!m.getName().equals("getInstance") || m.getParameterTypes().length != 0 || !Modifier.isStatic(m.getModifiers())) continue;
            return m;
        }
        return null;
    }

    public static <T> T getInstance(Class<T> clazz) {
        try {
            return Util.getInstanceStrict(clazz);
        }
        catch (IllegalAccessException iae) {
            throw new CacheConfigurationException("Unable to instantiate class " + clazz.getName(), iae);
        }
        catch (InstantiationException ie) {
            throw new CacheConfigurationException("Unable to instantiate class " + clazz.getName(), ie);
        }
    }

    public static <T> T getInstanceStrict(Class<T> clazz) throws IllegalAccessException, InstantiationException {
        Object instance = null;
        try {
            Method factoryMethod = Util.getFactoryMethod(clazz);
            if (factoryMethod != null) {
                instance = factoryMethod.invoke(null, new Object[0]);
            }
        }
        catch (Exception e) {
            instance = null;
        }
        if (instance == null) {
            instance = clazz.newInstance();
        }
        return (T)instance;
    }

    public static <T> T getInstance(String classname, ClassLoader cl) {
        if (classname == null) {
            throw new IllegalArgumentException("Cannot load null class!");
        }
        Class<T> clazz = Util.loadClass(classname, cl);
        return Util.getInstance(clazz);
    }

    public static <T> T getInstanceStrict(String classname, ClassLoader cl) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (classname == null) {
            throw new IllegalArgumentException("Cannot load null class!");
        }
        Class<T> clazz = Util.loadClassStrict(classname, cl);
        return Util.getInstanceStrict(clazz);
    }

    public static <T> T cloneWithMarshaller(Marshaller marshaller, T x) {
        if (marshaller == null) {
            throw new IllegalArgumentException("Cannot use null Marshaller for clone");
        }
        try {
            byte[] byteBuffer = marshaller.objectToByteBuffer(x);
            return (T)marshaller.objectFromByteBuffer(byteBuffer);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException(e);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    private Util() {
    }

    public static boolean safeEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static String prettyPrintTime(long time, TimeUnit unit) {
        return Util.prettyPrintTime(unit.toMillis(time));
    }

    public static final long currentMillisFromNanotime() {
        return TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    public static String prettyPrintTime(long millis) {
        if (millis < 1000L) {
            return millis + " milliseconds";
        }
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(2);
        double toPrint = (double)millis / 1000.0;
        if (toPrint < 300.0) {
            return nf.format(toPrint) + " seconds";
        }
        if ((toPrint /= 60.0) < 120.0) {
            return nf.format(toPrint) + " minutes";
        }
        return nf.format(toPrint /= 60.0) + " hours";
    }

    public static void close(Closeable cl) {
        if (cl == null) {
            return;
        }
        try {
            cl.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(Socket s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(Closeable ... cls) {
        for (Closeable cl : cls) {
            Util.close(cl);
        }
    }

    public static void close(Context ctx) {
        if (ctx == null) {
            return;
        }
        try {
            ctx.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void flushAndCloseStream(OutputStream o) {
        if (o == null) {
            return;
        }
        try {
            o.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            o.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void flushAndCloseOutput(ObjectOutput o) {
        if (o == null) {
            return;
        }
        try {
            o.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            o.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String formatString(Object message, Object ... params) {
        if (params.length == 0) {
            return message == null ? "null" : message.toString();
        }
        return String.format(message.toString(), params);
    }

    public static String toStr(Object o) {
        if (o instanceof byte[]) {
            byte[] array = (byte[])o;
            StringBuilder sb = new StringBuilder();
            sb.append("[B0x");
            if (IS_ARRAYS_DEBUG) {
                sb.append(Util.toHexString(array));
            } else {
                sb.append(Util.toHexString(array, 8));
                sb.append("..(");
                sb.append(array.length);
                sb.append(')');
            }
            return sb.toString();
        }
        if (o == null) {
            return "null";
        }
        return o.toString();
    }

    public static <E> String toStr(Collection<E> collection) {
        if (collection == null) {
            return "[]";
        }
        Iterator<E> i = collection.iterator();
        if (!i.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            E e;
            sb.append((e = i.next()) == collection ? "(this Collection)" : Util.toStr(e));
            if (!i.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(", ");
        }
    }

    public static String printArray(byte[] array, boolean withHash) {
        if (array == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("ByteArray{size=").append(array.length);
        if (withHash) {
            sb.append(", hashCode=").append(Integer.toHexString(Arrays.hashCode(array)));
        }
        sb.append(", array=0x");
        if (IS_ARRAYS_DEBUG) {
            sb.append(Util.toHexString(array));
        } else {
            sb.append(Util.toHexString(array, 8));
            sb.append("..");
        }
        sb.append("}");
        return sb.toString();
    }

    public static String toHexString(byte[] input) {
        return Util.toHexString(input, input.length);
    }

    public static String toHexString(byte[] input, int limit) {
        if (input == null || input.length <= 0) {
            return null;
        }
        char[] lookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] result = new char[(input.length < limit ? input.length : limit) * 2];
        for (int i = 0; i < limit && i < input.length; ++i) {
            result[2 * i] = lookup[input[i] >> 4 & 0xF];
            result[2 * i + 1] = lookup[input[i] & 0xF];
        }
        return String.valueOf(result);
    }

    public static String padString(String s, int minWidth) {
        if (s.length() < minWidth) {
            StringBuilder sb = new StringBuilder(s);
            while (sb.length() < minWidth) {
                sb.append(" ");
            }
            return sb.toString();
        }
        return s;
    }

    public static String threadDump() {
        StringBuilder threadDump = new StringBuilder();
        ThreadMXBean threadMx = ManagementFactory.getThreadMXBean();
        if (threadMx.isObjectMonitorUsageSupported() && threadMx.isSynchronizerUsageSupported()) {
            Util.dumpThreadInfo(threadDump, true, threadMx);
        } else {
            Util.dumpThreadInfo(threadDump, false, threadMx);
        }
        return threadDump.toString();
    }

    private static void dumpThreadInfo(StringBuilder threadDump, boolean withLocks, ThreadMXBean threadMx) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = dateFormat.format(new Date());
        threadDump.append(timestamp);
        threadDump.append("\nFull thread dump ");
        threadDump.append("\n");
        if (withLocks) {
            ThreadInfo[] threadInfos;
            for (ThreadInfo threadInfo : threadInfos = threadMx.dumpAllThreads(true, true)) {
                Util.printThreadInfo(threadInfo, threadDump);
                LockInfo[] syncs = threadInfo.getLockedSynchronizers();
                Util.printLockInfo(syncs, threadDump);
            }
            threadDump.append("\n");
        } else {
            ThreadInfo[] threadInfos;
            long[] threadIds = threadMx.getAllThreadIds();
            for (ThreadInfo threadInfo : threadInfos = threadMx.getThreadInfo(threadIds, Integer.MAX_VALUE)) {
                Util.printThreadInfo(threadInfo, threadDump);
            }
        }
    }

    private static void printThreadInfo(ThreadInfo threadInfo, StringBuilder threadDump) {
        Util.printThread(threadInfo, threadDump);
        StackTraceElement[] stacktrace = threadInfo.getStackTrace();
        MonitorInfo[] monitors = threadInfo.getLockedMonitors();
        for (int i = 0; i < stacktrace.length; ++i) {
            StackTraceElement ste = stacktrace[i];
            threadDump.append(INDENT + "at " + ste.toString());
            threadDump.append("\n");
            for (int j = 1; j < monitors.length; ++j) {
                MonitorInfo mi = monitors[j];
                if (mi.getLockedStackDepth() != i) continue;
                threadDump.append(INDENT + "  - locked " + mi);
                threadDump.append("\n");
            }
        }
        threadDump.append("\n");
    }

    private static void printLockInfo(LockInfo[] locks, StringBuilder threadDump) {
        threadDump.append(INDENT + "Locked synchronizers: count = " + locks.length);
        threadDump.append("\n");
        for (LockInfo li : locks) {
            threadDump.append(INDENT + "  - " + li);
            threadDump.append("\n");
        }
        threadDump.append("\n");
    }

    private static void printThread(ThreadInfo threadInfo, StringBuilder threadDump) {
        StringBuilder sb = new StringBuilder("\"" + threadInfo.getThreadName() + "\"" + " nid=" + threadInfo.getThreadId() + " state=" + (Object)((Object)threadInfo.getThreadState()));
        if (threadInfo.getLockName() != null && threadInfo.getThreadState() != Thread.State.BLOCKED) {
            String[] lockInfo = threadInfo.getLockName().split("@");
            sb.append("\n" + INDENT + "- waiting on <0x" + lockInfo[1] + "> (a " + lockInfo[0] + ")");
            sb.append("\n" + INDENT + "- locked <0x" + lockInfo[1] + "> (a " + lockInfo[0] + ")");
        } else if (threadInfo.getLockName() != null && threadInfo.getThreadState() == Thread.State.BLOCKED) {
            String[] lockInfo = threadInfo.getLockName().split("@");
            sb.append("\n" + INDENT + "- waiting to lock <0x" + lockInfo[1] + "> (a " + lockInfo[0] + ")");
        }
        if (threadInfo.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            sb.append(" (running in native)");
        }
        threadDump.append(sb.toString());
        threadDump.append("\n");
        if (threadInfo.getLockOwnerName() != null) {
            threadDump.append(INDENT + " owned by " + threadInfo.getLockOwnerName() + " id=" + threadInfo.getLockOwnerId());
            threadDump.append("\n");
        }
    }

    public static CacheException rewrapAsCacheException(Throwable t) {
        if (t instanceof CacheException) {
            return (CacheException)t;
        }
        return new CacheException(t);
    }

    public static <T> Set<T> asSet(T ... a) {
        if (a.length > 1) {
            return new HashSet<T>(Arrays.asList(a));
        }
        return Collections.singleton(a[0]);
    }

    public static String hexIdHashCode(Object o) {
        return Integer.toHexString(System.identityHashCode(o));
    }

    public static String hexDump(byte[] buffer) {
        StringBuilder buf = new StringBuilder(buffer.length << 1);
        for (byte b : buffer) {
            Util.addHexByte(buf, b);
        }
        return buf.toString();
    }

    public static String hexDump(ByteBuffer buffer) {
        byte[] data = new byte[buffer.remaining()];
        int pos = buffer.position();
        buffer.get(data);
        buffer.position(pos);
        StringBuilder buf = new StringBuilder(buffer.remaining() + 22);
        for (byte b : data) {
            Util.addHexByte(buf, b);
        }
        return buf.toString();
    }

    private static void addHexByte(StringBuilder buf, byte b) {
        buf.append(HEX_VALUES.charAt((b & 0xF0) >> 4)).append(HEX_VALUES.charAt(b & 0xF));
    }

    public static Double constructDouble(Class<?> type, Object o) {
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return (double)((Long)o);
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return (Double)o;
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return (double)((Integer)o);
        }
        if (type.equals(String.class)) {
            return Double.valueOf((String)o);
        }
        throw new IllegalStateException(String.format("Expected a value that can be converted into a double: type=%s, value=%s", type, o));
    }

    public static int getNormalizedHash(Object object, Hash hashFct) {
        return hashFct.hash(object) & Integer.MAX_VALUE;
    }

    public static boolean isIBMJavaVendor() {
        return javaVendor.toLowerCase().contains("ibm");
    }

    public static String join(List<String> strings, String separator) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String string : strings) {
            if (!first) {
                sb.append(separator);
            } else {
                first = false;
            }
            sb.append(string);
        }
        return sb.toString();
    }
}

