/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.configuration.cache.CacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser52;
import org.infinispan.loaders.jdbc.configuration.AbstractJdbcCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.Attribute;
import org.infinispan.loaders.jdbc.configuration.Element;
import org.infinispan.loaders.jdbc.configuration.JdbcBinaryCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.JdbcMixedCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.JdbcStringBasedCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.ManagedConnectionFactoryConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.PooledConnectionFactoryConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.SimpleConnectionFactoryConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.TableManipulationConfigurationBuilder;
import org.infinispan.util.StringPropertyReplacer;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class JdbcCacheStoreConfigurationParser52
implements ConfigurationParser<ConfigurationBuilderHolder> {
    private static final Namespace[] NAMESPACES = new Namespace[]{new Namespace("urn:infinispan:config", "jdbc", Element.STRING_KEYED_JDBC_STORE.getLocalName(), 5, 2), new Namespace("urn:infinispan:config", "jdbc", Element.BINARY_KEYED_JDBC_STORE.getLocalName(), 5, 2), new Namespace("urn:infinispan:config", "jdbc", Element.MIXED_KEYED_JDBC_STORE.getLocalName(), 5, 2)};

    public Namespace[] getSupportedNamespaces() {
        return NAMESPACES;
    }

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case STRING_KEYED_JDBC_STORE: {
                this.parseStringKeyedJdbcStore(reader, builder.loaders());
                break;
            }
            case BINARY_KEYED_JDBC_STORE: {
                this.parseBinaryKeyedJdbcStore(reader, builder.loaders());
                break;
            }
            case MIXED_KEYED_JDBC_STORE: {
                this.parseMixedKeyedJdbcStore(reader, builder.loaders());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseStringKeyedJdbcStore(XMLExtendedStreamReader reader, LoadersConfigurationBuilder loadersBuilder) throws XMLStreamException {
        JdbcStringBasedCacheStoreConfigurationBuilder builder = new JdbcStringBasedCacheStoreConfigurationBuilder(loadersBuilder);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case KEY_TO_STRING_MAPPER: {
                    builder.key2StringMapper(value);
                    continue block6;
                }
                default: {
                    Parser52.parseCommonStoreAttributes((XMLExtendedStreamReader)reader, (int)i, (CacheStoreConfigurationBuilder)builder);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STRING_KEYED_TABLE: {
                    this.parseTable(reader, builder.table());
                    continue block7;
                }
            }
            this.parseCommonJdbcStoreElements(reader, element, builder);
        }
        loadersBuilder.addStore((CacheStoreConfigurationBuilder)builder);
    }

    private void parseBinaryKeyedJdbcStore(XMLExtendedStreamReader reader, LoadersConfigurationBuilder loadersBuilder) throws XMLStreamException {
        JdbcBinaryCacheStoreConfigurationBuilder builder = new JdbcBinaryCacheStoreConfigurationBuilder(loadersBuilder);
        this.parseCommonJdbcStoreAttributes(reader, builder);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case BINARY_KEYED_TABLE: {
                    this.parseTable(reader, builder.table());
                    continue block3;
                }
            }
            this.parseCommonJdbcStoreElements(reader, element, builder);
        }
        loadersBuilder.addStore((CacheStoreConfigurationBuilder)builder);
    }

    private void parseCommonJdbcStoreElements(XMLExtendedStreamReader reader, Element element, AbstractJdbcCacheStoreConfigurationBuilder<?, ?> builder) throws XMLStreamException {
        switch (element) {
            case CONNECTION_POOL: {
                this.parseConnectionPoolAttributes(reader, builder.connectionPool());
                break;
            }
            case DATA_SOURCE: {
                this.parseDataSourceAttributes(reader, builder.dataSource());
                break;
            }
            case SIMPLE_CONNECTION: {
                this.parseSimpleConnectionAttributes(reader, builder.simpleConnection());
                break;
            }
            default: {
                Parser52.parseCommonStoreChildren((XMLExtendedStreamReader)reader, builder);
            }
        }
    }

    private void parseCommonJdbcStoreAttributes(XMLExtendedStreamReader reader, AbstractJdbcCacheStoreConfigurationBuilder<?, ?> builder) throws XMLStreamException {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Parser52.parseCommonStoreAttributes((XMLExtendedStreamReader)reader, (int)i, builder);
        }
    }

    private void parseDataSourceAttributes(XMLExtendedStreamReader reader, ManagedConnectionFactoryConfigurationBuilder<?> builder) throws XMLStreamException {
        String jndiUrl = ParseUtils.requireSingleAttribute((XMLStreamReader)reader, (String)Attribute.JNDI_URL.getLocalName());
        builder.jndiUrl(jndiUrl);
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseConnectionPoolAttributes(XMLExtendedStreamReader reader, PooledConnectionFactoryConfigurationBuilder<?> builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CONNECTION_URL: {
                    builder.connectionUrl(value);
                    continue block6;
                }
                case DRIVER_CLASS: {
                    builder.driverClass(value);
                    continue block6;
                }
                case PASSWORD: {
                    builder.password(value);
                    continue block6;
                }
                case USERNAME: {
                    builder.username(value);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseSimpleConnectionAttributes(XMLExtendedStreamReader reader, SimpleConnectionFactoryConfigurationBuilder<?> builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CONNECTION_URL: {
                    builder.connectionUrl(value);
                    continue block6;
                }
                case DRIVER_CLASS: {
                    builder.driverClass(value);
                    continue block6;
                }
                case PASSWORD: {
                    builder.password(value);
                    continue block6;
                }
                case USERNAME: {
                    builder.username(value);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseMixedKeyedJdbcStore(XMLExtendedStreamReader reader, LoadersConfigurationBuilder loadersBuilder) throws XMLStreamException {
        JdbcMixedCacheStoreConfigurationBuilder builder = new JdbcMixedCacheStoreConfigurationBuilder(loadersBuilder);
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case KEY_TO_STRING_MAPPER: {
                    builder.key2StringMapper(value);
                    continue block7;
                }
                default: {
                    Parser52.parseCommonStoreAttributes((XMLExtendedStreamReader)reader, (int)i, (CacheStoreConfigurationBuilder)builder);
                }
            }
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STRING_KEYED_TABLE: {
                    this.parseTable(reader, builder.stringTable());
                    continue block8;
                }
                case BINARY_KEYED_TABLE: {
                    this.parseTable(reader, builder.binaryTable());
                    continue block8;
                }
            }
            this.parseCommonJdbcStoreElements(reader, element, builder);
        }
        loadersBuilder.addStore((CacheStoreConfigurationBuilder)builder);
    }

    private void parseTable(XMLExtendedStreamReader reader, TableManipulationConfigurationBuilder<?, ?> builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case BATCH_SIZE: {
                    builder.batchSize(Integer.parseInt(value));
                    continue block7;
                }
                case CREATE_ON_START: {
                    builder.createOnStart(Boolean.parseBoolean(value));
                    continue block7;
                }
                case DROP_ON_EXIT: {
                    builder.dropOnExit(Boolean.parseBoolean(value));
                    continue block7;
                }
                case FETCH_SIZE: {
                    builder.fetchSize(Integer.parseInt(value));
                    continue block7;
                }
                case PREFIX: {
                    builder.tableNamePrefix(value);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        this.parseTableElements(reader, builder);
    }

    private void parseTableElements(XMLExtendedStreamReader reader, TableManipulationConfigurationBuilder<?, ?> builder) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ID_COLUMN: {
                    Column column = this.parseTableElementAttributes(reader);
                    builder.idColumnName(column.name);
                    builder.idColumnType(column.type);
                    continue block5;
                }
                case DATA_COLUMN: {
                    Column column = this.parseTableElementAttributes(reader);
                    builder.dataColumnName(column.name);
                    builder.dataColumnType(column.type);
                    continue block5;
                }
                case TIMESTAMP_COLUMN: {
                    Column column = this.parseTableElementAttributes(reader);
                    builder.timestampColumnName(column.name);
                    builder.timestampColumnType(column.type);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private Column parseTableElementAttributes(XMLExtendedStreamReader reader) throws XMLStreamException {
        Column column = new Column();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    column.name = value;
                    continue block4;
                }
                case TYPE: {
                    column.type = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
        return column;
    }

    class Column {
        String name;
        String type;

        Column() {
        }
    }
}

