/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.stringbased;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.io.ByteBuffer;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderMetadata;
import org.infinispan.loaders.LockSupportCacheStore;
import org.infinispan.loaders.jdbc.DataManipulationHelper;
import org.infinispan.loaders.jdbc.JdbcUtil;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.logging.Log;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStoreConfig;
import org.infinispan.loaders.keymappers.Key2StringMapper;
import org.infinispan.loaders.keymappers.TwoWayKey2StringMapper;
import org.infinispan.loaders.keymappers.UnsupportedKeyTypeException;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.util.logging.LogFactory;

@CacheLoaderMetadata(configurationClass=JdbcStringBasedCacheStoreConfig.class)
public class JdbcStringBasedCacheStore
extends LockSupportCacheStore<String> {
    private static final Log log = (Log)LogFactory.getLog(JdbcStringBasedCacheStore.class, Log.class);
    private static final byte STRING_STREAM_DELIMITER = 100;
    private JdbcStringBasedCacheStoreConfig config;
    private Key2StringMapper key2StringMapper;
    private ConnectionFactory connectionFactory;
    private TableManipulation tableManipulation;
    private DataManipulationHelper dmHelper;
    private String cacheName;

    public void init(CacheLoaderConfig config, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        super.init(config, cache, m);
        this.config = (JdbcStringBasedCacheStoreConfig)config;
        this.cacheName = cache.getName();
    }

    public void start() throws CacheLoaderException {
        super.start();
        if (this.config.isManageConnectionFactory()) {
            String connectionFactoryClass = this.config.getConnectionFactoryConfig().getConnectionFactoryClass();
            if (log.isTraceEnabled()) {
                log.tracef("Using managed connection factory: %s", connectionFactoryClass);
            }
            ConnectionFactory connectionFactory = ConnectionFactory.getConnectionFactory(connectionFactoryClass, this.config.getClassLoader());
            connectionFactory.start(this.config.getConnectionFactoryConfig(), this.config.getClassLoader());
            this.doConnectionFactoryInitialization(connectionFactory);
        }
        this.key2StringMapper = this.config.getKey2StringMapper();
        if (log.isTraceEnabled()) {
            log.tracef("Using key2StringMapper: %s", this.key2StringMapper.getClass().getName());
        }
        if (this.isUsingPreload()) {
            this.enforceTwoWayMapper("preload");
        }
        if (this.isDistributed()) {
            this.enforceTwoWayMapper("distribution/rehashing");
        }
        this.dmHelper = new DataManipulationHelper(this.connectionFactory, this.tableManipulation, this.marshaller, this.timeService){

            @Override
            protected String getLoadAllKeysSql() {
                return JdbcStringBasedCacheStore.this.tableManipulation.getLoadAllKeysStringSql();
            }

            @Override
            public void loadAllProcess(ResultSet rs, Set<InternalCacheEntry> result) throws SQLException, CacheLoaderException {
                InputStream inputStream = rs.getBinaryStream(1);
                InternalCacheValue icv = (InternalCacheValue)JdbcUtil.unmarshall(JdbcStringBasedCacheStore.this.getMarshaller(), inputStream);
                String keyStr = rs.getString(2);
                Object key = ((TwoWayKey2StringMapper)JdbcStringBasedCacheStore.this.key2StringMapper).getKeyMapping(keyStr);
                result.add(icv.toInternalCacheEntry(key));
            }

            @Override
            public void loadAllProcess(ResultSet rs, Set<InternalCacheEntry> result, int maxEntries) throws SQLException, CacheLoaderException {
                this.loadAllProcess(rs, result);
            }

            @Override
            public void loadAllKeysProcess(ResultSet rs, Set<Object> keys, Set<Object> keysToExclude) throws SQLException, CacheLoaderException {
                String keyStr = rs.getString(1);
                Object key = ((TwoWayKey2StringMapper)JdbcStringBasedCacheStore.this.key2StringMapper).getKeyMapping(keyStr);
                if (this.includeKey(key, keysToExclude)) {
                    keys.add(key);
                }
            }

            @Override
            public void toStreamProcess(ResultSet rs, InputStream is, ObjectOutput objectOutput) throws CacheLoaderException, SQLException, IOException {
                InternalCacheValue icv = (InternalCacheValue)JdbcUtil.unmarshall(JdbcStringBasedCacheStore.this.getMarshaller(), is);
                String key = rs.getString(2);
                this.marshaller.objectToObjectStream((Object)icv.toInternalCacheEntry((Object)key), objectOutput);
            }

            @Override
            public boolean fromStreamProcess(Object objFromStream, PreparedStatement ps, ObjectInput objectInput) throws SQLException, CacheLoaderException, InterruptedException {
                if (objFromStream instanceof InternalCacheEntry) {
                    InternalCacheEntry se = (InternalCacheEntry)objFromStream;
                    ByteBuffer buffer = JdbcUtil.marshall(JdbcStringBasedCacheStore.this.getMarshaller(), se.toInternalCacheValue());
                    ps.setBinaryStream(1, buffer.getStream(), buffer.getLength());
                    ps.setLong(2, se.getExpiryTime());
                    ps.setString(3, (String)se.getKey());
                    return true;
                }
                return false;
            }
        };
    }

    public void stop() throws CacheLoaderException {
        super.stop();
        Throwable cause = null;
        try {
            this.tableManipulation.stop();
        }
        catch (Throwable t) {
            cause = t.getCause();
            if (cause == null) {
                cause = t;
            }
            log.debug("Exception while stopping", t);
        }
        try {
            if (this.config.isManageConnectionFactory()) {
                log.tracef("Stopping mananged connection factory: %s", this.connectionFactory);
                this.connectionFactory.stop();
            }
        }
        catch (Throwable t) {
            if (cause == null) {
                cause = t;
            }
            log.debug("Exception while stopping", t);
        }
        if (cause != null) {
            throw new CacheLoaderException("Exceptions occurred while stopping store", cause);
        }
    }

    protected String getLockFromKey(Object key) throws CacheLoaderException {
        if (!this.key2StringMapper.isSupportedType(key.getClass())) {
            throw new UnsupportedKeyTypeException(key);
        }
        return this.key2StringMapper.getStringMapping(key);
    }

    /*
     * Exception decompiling
     */
    public void storeLockSafe(InternalCacheEntry ed, String lockingKey) throws CacheLoaderException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean removeLockSafe(Object key, String keyStr) throws CacheLoaderException {
        boolean bl;
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            String sql = this.tableManipulation.getDeleteRowSql();
            if (log.isTraceEnabled()) {
                log.tracef("Running sql '%s' on %s", sql, keyStr);
            }
            connection = this.connectionFactory.getConnection();
            ps = connection.prepareStatement(sql);
            ps.setString(1, keyStr);
            bl = ps.executeUpdate() == 1;
        }
        catch (SQLException ex) {
            try {
                log.sqlFailureRemovingKeys(ex);
                throw new CacheLoaderException("Error while removing string keys from database", (Throwable)ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(connection);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(connection);
        return bl;
    }

    public void fromStreamLockSafe(ObjectInput objectInput) throws CacheLoaderException {
        this.dmHelper.fromStreamSupport(objectInput);
    }

    protected void toStreamLockSafe(ObjectOutput objectOutput) throws CacheLoaderException {
        this.dmHelper.toStreamSupport(objectOutput, (byte)100, true);
    }

    protected void clearLockSafe() throws CacheLoaderException {
        this.dmHelper.clear();
    }

    protected Set<InternalCacheEntry> loadAllLockSafe() throws CacheLoaderException {
        return this.dmHelper.loadAllSupport(true);
    }

    protected Set<InternalCacheEntry> loadLockSafe(int maxEntries) throws CacheLoaderException {
        return this.dmHelper.loadSome(maxEntries);
    }

    protected Set<Object> loadAllKeysLockSafe(Set<Object> keysToExclude) throws CacheLoaderException {
        return this.dmHelper.loadAllKeysSupport(keysToExclude);
    }

    public void purgeInternal() throws CacheLoaderException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            String sql = this.tableManipulation.getDeleteExpiredRowsSql();
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setLong(1, this.timeService.wallClockTime());
            int result = ps.executeUpdate();
            if (log.isTraceEnabled()) {
                log.tracef("Successfully purged %d rows.", result);
            }
        }
        catch (SQLException ex) {
            try {
                log.failedClearingJdbcCacheStore(ex);
                throw new CacheLoaderException("Failed clearing string based JDBC store", (Throwable)ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
    }

    protected InternalCacheEntry loadLockSafe(Object key, String lockingKey) throws CacheLoaderException {
        InternalCacheEntry storedEntry = this.readStoredEntry(key, lockingKey);
        if (storedEntry != null && storedEntry.isExpired(this.timeService.wallClockTime())) {
            if (log.isTraceEnabled()) {
                log.tracef("Not returning '%s' as it is expired. It will be removed from DB by purging thread!", storedEntry);
            }
            return null;
        }
        return storedEntry;
    }

    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return JdbcStringBasedCacheStoreConfig.class;
    }

    public boolean supportsKey(Class<?> keyType) {
        return this.key2StringMapper.isSupportedType(keyType);
    }

    public void doConnectionFactoryInitialization(ConnectionFactory connectionFactory) throws CacheLoaderException {
        this.connectionFactory = connectionFactory;
        this.tableManipulation = this.config.getTableManipulation();
        this.tableManipulation.setCacheName(this.cacheName);
        this.tableManipulation.start(connectionFactory);
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public TableManipulation getTableManipulation() {
        return this.tableManipulation;
    }

    private void enforceTwoWayMapper(String where) throws CacheLoaderException {
        if (!(this.key2StringMapper instanceof TwoWayKey2StringMapper)) {
            log.invalidKey2StringMapper(where, this.key2StringMapper.getClass().getName());
            throw new CacheLoaderException(String.format("Invalid key to string mapper", this.key2StringMapper.getClass().getName()));
        }
    }

    public boolean isUsingPreload() {
        return this.cache.getConfiguration() != null && this.cache.getConfiguration().getCacheLoaderManagerConfig() != null && this.cache.getConfiguration().getCacheLoaderManagerConfig().isPreload() != false;
    }

    public boolean isDistributed() {
        return this.cache.getConfiguration() != null && this.cache.getConfiguration().getCacheMode().isDistributed();
    }

    private InternalCacheEntry readStoredEntry(Object key, String lockingKey) throws CacheLoaderException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        InternalCacheEntry storedEntry = null;
        try {
            String sql = this.tableManipulation.getSelectRowSql();
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, lockingKey);
            rs = ps.executeQuery();
            if (rs.next()) {
                InputStream inputStream = rs.getBinaryStream(2);
                InternalCacheValue icv = (InternalCacheValue)JdbcUtil.unmarshall(this.getMarshaller(), inputStream);
                storedEntry = icv.toInternalCacheEntry(key);
            }
        }
        catch (SQLException e) {
            try {
                log.sqlFailureReadingKey(key, lockingKey, e);
                throw new CacheLoaderException(String.format("SQL error while fetching stored entry with key: %s, lockingKey: %s", key, lockingKey), (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
        return storedEntry;
    }
}

