/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.jms.Queue;
import org.hornetq.jms.client.HornetQQueue;
import org.hornetq.jms.server.JMSServerManager;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.messaging.HornetQActivationService;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.server.Services;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class JMSQueueService
implements Service<Queue> {
    private final InjectedValue<JMSServerManager> jmsServer = new InjectedValue();
    private final InjectedValue<ExecutorService> executorInjector = new InjectedValue();
    private final String queueName;
    private final String selectorString;
    private final boolean durable;
    private final String[] jndi;
    private Queue queue;

    public JMSQueueService(String queueName, String selectorString, boolean durable, String[] jndi) {
        this.queueName = queueName;
        this.selectorString = selectorString;
        this.durable = durable;
        this.jndi = jndi;
    }

    public synchronized void start(final StartContext context) throws StartException {
        context.asynchronous();
        final JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        ((ExecutorService)this.executorInjector.getValue()).execute(new Runnable(){

            @Override
            public void run() {
                try {
                    jmsManager.createQueue(false, JMSQueueService.this.queueName, JMSQueueService.this.selectorString, JMSQueueService.this.durable, JMSQueueService.this.jndi);
                    JMSQueueService.this.queue = (Queue)new HornetQQueue(JMSQueueService.this.queueName);
                    context.complete();
                }
                catch (Throwable e) {
                    context.failed(MessagingMessages.MESSAGES.failedToCreate(e, "queue"));
                }
            }
        });
    }

    public synchronized void stop(final StopContext context) {
        context.asynchronous();
        final JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        ((ExecutorService)this.executorInjector.getValue()).execute(new Runnable(){

            @Override
            public void run() {
                try {
                    jmsManager.removeQueueFromJNDI(JMSQueueService.this.queueName);
                    JMSQueueService.this.queue = null;
                }
                catch (Throwable e) {
                    MessagingLogger.MESSAGING_LOGGER.failedToDestroy(e, "queue", JMSQueueService.this.queueName);
                }
                context.complete();
            }
        });
    }

    public Queue getValue() throws IllegalStateException, IllegalArgumentException {
        return this.queue;
    }

    public static Service<Queue> installService(ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, String name, ServiceTarget serviceTarget, ServiceName hqServiceName, String selector, boolean durable, String[] jndiBindings) {
        JMSQueueService service = new JMSQueueService(name, selector, durable, jndiBindings);
        ServiceName serviceName = JMSServices.getJmsQueueBaseServiceName(hqServiceName).append(new String[]{name});
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)service).addDependency(HornetQActivationService.getHornetQActivationServiceName(hqServiceName)).addDependency(JMSServices.getJmsManagerBaseServiceName(hqServiceName), JMSServerManager.class, service.jmsServer).setInitialMode(ServiceController.Mode.PASSIVE);
        Services.addServerExecutorDependency((ServiceBuilder)serviceBuilder, service.executorInjector, (boolean)false);
        if (verificationHandler != null) {
            serviceBuilder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController controller = serviceBuilder.install();
        if (newControllers != null) {
            newControllers.add(controller);
        }
        return service;
    }
}

