/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.sql.DataSource;

public class JDBCLogHandler
implements HttpHandler,
Runnable {
    private final HttpHandler next;
    private final String formatString;
    private final ExchangeCompletionListener exchangeCompletionListener = new JDBCLogCompletionListener();
    private final Executor logWriteExecutor;
    private final Deque<JDBCLogAttribute> pendingMessages;
    private volatile int state = 0;
    private static final AtomicIntegerFieldUpdater<JDBCLogHandler> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(JDBCLogHandler.class, "state");
    protected boolean useLongContentLength = false;
    private final DataSource dataSource;
    private String tableName;
    private String remoteHostField;
    private String userField;
    private String timestampField;
    private String virtualHostField;
    private String methodField;
    private String queryField;
    private String statusField;
    private String bytesField;
    private String refererField;
    private String userAgentField;

    public JDBCLogHandler(HttpHandler next, Executor logWriteExecutor, String formatString, DataSource dataSource) {
        this.next = next;
        this.formatString = formatString;
        this.dataSource = dataSource;
        this.tableName = "access";
        this.remoteHostField = "remoteHost";
        this.userField = "userName";
        this.timestampField = "timestamp";
        this.virtualHostField = "virtualHost";
        this.methodField = "method";
        this.queryField = "query";
        this.statusField = "status";
        this.bytesField = "bytes";
        this.refererField = "referer";
        this.userAgentField = "userAgent";
        this.logWriteExecutor = logWriteExecutor;
        this.pendingMessages = new ConcurrentLinkedDeque<JDBCLogAttribute>();
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.addExchangeCompleteListener(this.exchangeCompletionListener);
        this.next.handleRequest(exchange);
    }

    public void logMessage(String pattern, HttpServerExchange exchange) {
        JDBCLogAttribute jdbcLogAttribute = new JDBCLogAttribute();
        if (pattern.equals("combined")) {
            jdbcLogAttribute.pattern = pattern;
        }
        jdbcLogAttribute.remoteHost = ((InetSocketAddress)exchange.getConnection().getPeerAddress()).getAddress().getHostAddress();
        SecurityContext sc = exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        jdbcLogAttribute.user = sc == null || !sc.isAuthenticated() ? null : sc.getAuthenticatedAccount().getPrincipal().getName();
        jdbcLogAttribute.query = exchange.getQueryString();
        jdbcLogAttribute.bytes = exchange.getResponseContentLength();
        if (jdbcLogAttribute.bytes < 0L) {
            jdbcLogAttribute.bytes = 0L;
        }
        jdbcLogAttribute.status = exchange.getResponseCode();
        if (jdbcLogAttribute.pattern.equals("combined")) {
            jdbcLogAttribute.virtualHost = exchange.getRequestHeaders().getFirst(Headers.HOST);
            jdbcLogAttribute.method = exchange.getRequestMethod().toString();
            jdbcLogAttribute.referer = exchange.getRequestHeaders().getFirst(Headers.REFERER);
            jdbcLogAttribute.userAgent = exchange.getRequestHeaders().getFirst(Headers.USER_AGENT);
        }
        this.pendingMessages.add(jdbcLogAttribute);
        int state = stateUpdater.get(this);
        if (state == 0 && stateUpdater.compareAndSet(this, 0, 1)) {
            this.logWriteExecutor.execute(this);
        }
    }

    @Override
    public void run() {
        if (!stateUpdater.compareAndSet(this, 1, 2)) {
            return;
        }
        ArrayList<JDBCLogAttribute> messages = new ArrayList<JDBCLogAttribute>();
        JDBCLogAttribute msg = null;
        for (int i = 0; i < 1000 && (msg = this.pendingMessages.poll()) != null; ++i) {
            messages.add(msg);
        }
        if (!messages.isEmpty()) {
            this.writeMessage(messages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMessage(List<JDBCLogAttribute> messages) {
        Statement ps = null;
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            conn.setAutoCommit(true);
            ps = this.prepareStatement(conn);
            for (JDBCLogAttribute jdbcLogAttribute : messages) {
                for (int numberOfTries = 2; numberOfTries > 0; --numberOfTries) {
                    try {
                        ps.clearParameters();
                        ps.setString(1, jdbcLogAttribute.remoteHost);
                        ps.setString(2, jdbcLogAttribute.user);
                        ps.setTimestamp(3, jdbcLogAttribute.timestamp);
                        ps.setString(4, jdbcLogAttribute.query);
                        ps.setInt(5, jdbcLogAttribute.status);
                        if (this.useLongContentLength) {
                            ps.setLong(6, jdbcLogAttribute.bytes);
                        } else {
                            if (jdbcLogAttribute.bytes > Integer.MAX_VALUE) {
                                jdbcLogAttribute.bytes = -1L;
                            }
                            ps.setInt(6, (int)jdbcLogAttribute.bytes);
                        }
                        ps.setString(7, jdbcLogAttribute.virtualHost);
                        ps.setString(8, jdbcLogAttribute.method);
                        ps.setString(9, jdbcLogAttribute.referer);
                        ps.setString(10, jdbcLogAttribute.userAgent);
                        ps.executeUpdate();
                        numberOfTries = 0;
                        continue;
                    }
                    catch (SQLException e) {
                        UndertowLogger.ROOT_LOGGER.error(e);
                    }
                }
            }
            ps.close();
            stateUpdater.set(this, 0);
            if (!this.pendingMessages.isEmpty() && stateUpdater.compareAndSet(this, 0, 1)) {
                this.logWriteExecutor.execute(this);
            }
        }
        catch (SQLException e) {
            UndertowLogger.ROOT_LOGGER.errorWritingJDBCLog(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    UndertowLogger.ROOT_LOGGER.debug("Exception closing prepared statement", e);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    UndertowLogger.ROOT_LOGGER.debug("Exception closing connection", e);
                }
            }
        }
    }

    void awaitWrittenForTest() throws InterruptedException {
        while (!this.pendingMessages.isEmpty()) {
            Thread.sleep(10L);
        }
        while (this.state != 0) {
            Thread.sleep(10L);
        }
    }

    private PreparedStatement prepareStatement(Connection conn) throws SQLException {
        return conn.prepareStatement("INSERT INTO " + this.tableName + " (" + this.remoteHostField + ", " + this.userField + ", " + this.timestampField + ", " + this.queryField + ", " + this.statusField + ", " + this.bytesField + ", " + this.virtualHostField + ", " + this.methodField + ", " + this.refererField + ", " + this.userAgentField + ") VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    }

    public boolean isUseLongContentLength() {
        return this.useLongContentLength;
    }

    public void setUseLongContentLength(boolean useLongContentLength) {
        this.useLongContentLength = useLongContentLength;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getRemoteHostField() {
        return this.remoteHostField;
    }

    public void setRemoteHostField(String remoteHostField) {
        this.remoteHostField = remoteHostField;
    }

    public String getUserField() {
        return this.userField;
    }

    public void setUserField(String userField) {
        this.userField = userField;
    }

    public String getTimestampField() {
        return this.timestampField;
    }

    public void setTimestampField(String timestampField) {
        this.timestampField = timestampField;
    }

    public String getVirtualHostField() {
        return this.virtualHostField;
    }

    public void setVirtualHostField(String virtualHostField) {
        this.virtualHostField = virtualHostField;
    }

    public String getMethodField() {
        return this.methodField;
    }

    public void setMethodField(String methodField) {
        this.methodField = methodField;
    }

    public String getQueryField() {
        return this.queryField;
    }

    public void setQueryField(String queryField) {
        this.queryField = queryField;
    }

    public String getStatusField() {
        return this.statusField;
    }

    public void setStatusField(String statusField) {
        this.statusField = statusField;
    }

    public String getBytesField() {
        return this.bytesField;
    }

    public void setBytesField(String bytesField) {
        this.bytesField = bytesField;
    }

    public String getRefererField() {
        return this.refererField;
    }

    public void setRefererField(String refererField) {
        this.refererField = refererField;
    }

    public String getUserAgentField() {
        return this.userAgentField;
    }

    public void setUserAgentField(String userAgentField) {
        this.userAgentField = userAgentField;
    }

    public String toString() {
        return "JDBCLogHandler{formatString='" + this.formatString + '\'' + '}';
    }

    private class JDBCLogAttribute {
        protected String remoteHost = "";
        protected String user = "";
        protected String query = "";
        protected long bytes = 0L;
        protected int status = 0;
        protected String virtualHost = "";
        protected String method = "";
        protected String referer = "";
        protected String userAgent = "";
        protected String pattern = "common";
        protected Timestamp timestamp = new Timestamp(System.currentTimeMillis());

        private JDBCLogAttribute() {
        }
    }

    private class JDBCLogCompletionListener
    implements ExchangeCompletionListener {
        private JDBCLogCompletionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
            try {
                JDBCLogHandler.this.logMessage(JDBCLogHandler.this.formatString, exchange);
            }
            finally {
                nextListener.proceed();
            }
        }
    }
}

