/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.hornetq.jms.client.JmsExceptionUtils;

public class HornetQJMSConsumer
implements JMSConsumer {
    private final JMSContext context;
    private final MessageConsumer consumer;

    HornetQJMSConsumer(JMSContext context, MessageConsumer consumer) {
        this.context = context;
        this.consumer = consumer;
    }

    @Override
    public String getMessageSelector() {
        try {
            return this.consumer.getMessageSelector();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public MessageListener getMessageListener() throws JMSRuntimeException {
        try {
            return this.consumer.getMessageListener();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public void setMessageListener(MessageListener listener) throws JMSRuntimeException {
        try {
            this.consumer.setMessageListener(listener);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public Message receive() {
        try {
            return this.consumer.receive();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public Message receive(long timeout) {
        try {
            return this.consumer.receive(timeout);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public Message receiveNoWait() {
        try {
            return this.consumer.receiveNoWait();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.consumer.close();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public <T> T receiveBody(Class<T> c) {
        try {
            Message message = this.consumer.receive();
            return message == null ? null : (T)message.getBody(c);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public <T> T receiveBody(Class<T> c, long timeout) {
        try {
            Message message = this.consumer.receive(timeout);
            return message == null ? null : (T)message.getBody(c);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public <T> T receiveBodyNoWait(Class<T> c) {
        try {
            Message message = this.consumer.receiveNoWait();
            return message == null ? null : (T)message.getBody(c);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }
}

