/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.validator;

import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.ValidationProviderResolver;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import org.jboss.as.jpa.validator.WildFlyProviderResolver;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JPALazyValidatorFactory
implements ValidatorFactory {
    private volatile ValidatorFactory delegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidatorFactory getDelegate() {
        ValidatorFactory result = this.delegate;
        if (result == null) {
            JPALazyValidatorFactory jPALazyValidatorFactory = this;
            synchronized (jPALazyValidatorFactory) {
                result = this.delegate;
                if (result == null) {
                    this.delegate = result = this.initFactory();
                }
            }
        }
        return result;
    }

    public Validator getValidator() {
        return this.getDelegate().getValidator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidatorFactory initFactory() {
        ClassLoader oldTCCL = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTCCL);
            ValidatorFactory validatorFactory = Validation.byDefaultProvider().providerResolver((ValidationProviderResolver)new WildFlyProviderResolver()).configure().buildValidatorFactory();
            return validatorFactory;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTCCL);
        }
    }

    public ValidatorContext usingContext() {
        return this.getDelegate().usingContext();
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.getDelegate().getMessageInterpolator();
    }

    public TraversableResolver getTraversableResolver() {
        return this.getDelegate().getTraversableResolver();
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.getDelegate().getConstraintValidatorFactory();
    }

    public ParameterNameProvider getParameterNameProvider() {
        return this.getDelegate().getParameterNameProvider();
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)this.getDelegate().unwrap(clazz);
    }

    public void close() {
        this.getDelegate().close();
    }
}

